local ZGV = ZygorGuidesViewer
if not ZGV then return end

local ZGVG=ZGV.Gold

if not ZGV.Gold.Auctions then ZGV.Gold.Auctions = {} end
local Auctions = ZGV.Gold.Auctions

Auctions.Flags = {
	ARMOR =		{mod=0,  type="Red",	name="Armor, may take longer to sell", description="May not sell quickly"},
	TRADEGOODS_1 =	{mod=10, type="Green",	name="Popular trade goods", description="Popular trade good, should sell very nicely."},
	TRADEGOODS_2 =	{mod=7,  type="Green",	name="Trade goods", description="Trade good, should sell nicely."},
	WEAPON =	{mod=0,  type="Red",	name="Weapon", description=""},
	CONSUMABLE =	{mod=5,  type="Green",	name="Consumable", description=""},
	CONTAINERS =	{mod=5,  type="Green",	name="Bag", description="Bags can sell in waves, or not sell often."},
	GEMS =		{mod=0,  type="Green",	name="Gems", description=""},
	RECIPE =	{mod=0,  type="Green",	name="Recipe", description=""},
	XMOG =		{mod=5,  type="Green",	name="Transmogrification", description="Is used in popular xmog looks."},
	OLD =		{mod=-2, type="Red",	name="Older expansion", description=""}, -- don't use together with xmog, use old_eq or old_weapon instead
	CURRENT =	{mod=2,  type="Green",	name="Current expansion", description=""},
	OLD_EQUIP =	{mod=0,  type="Green",	name="Older expansion", description=""},
	OLD_WEAPON =	{mod=0,	 type="Green",	name="Older expansion", description=""},
	TWINK =		{mod=7,	 type="Green",	name="Optimized for tier PVP", description=""},
	PVP =		{mod=0,	 type="Green",	name="Pvp", description=""},
	QUEST =		{mod=6,	 type="Green",	name="Quest items", description=""},
	--NAME = {mod=0,  type="Green", name="", description=""},
} 

Auctions.BaseValues = {
	[ZGV.L["type_armor"]] = {
		[ZGV.L["subtype_armor_miscellaneous"]] = {"ARMOR"},
		[ZGV.L["subtype_armor_cloth"]] = {"ARMOR"},
		[ZGV.L["subtype_armor_leather"]] = {"ARMOR"},
		[ZGV.L["subtype_armor_mail"]] = {"ARMOR"},
		[ZGV.L["subtype_armor_plate"]] = {"ARMOR"},
		[ZGV.L["subtype_armor_shields"]] = {"ARMOR"},
		[ZGV.L["subtype_armor_librams"]] = {"ARMOR"},
		[ZGV.L["subtype_armor_idols"]] = {"ARMOR"},
		[ZGV.L["subtype_armor_totems"]] = {"ARMOR"},
		[ZGV.L["subtype_armor_sigils"]] = {"ARMOR"},
	},

	[ZGV.L["type_consumable"]] = {
		[ZGV.L["subtype_consumable_food_drink"]] = {"CONSUMABLE"},
		[ZGV.L["subtype_consumable_potion"]] = {"CONSUMABLE"},
		[ZGV.L["subtype_consumable_elixir"]] = {"CONSUMABLE"},
		[ZGV.L["subtype_consumable_flask"]] = {"CONSUMABLE"},
		[ZGV.L["subtype_consumable_bandage"]] = {"CONSUMABLE"},
		[ZGV.L["subtype_consumable_item_enhancement"]] = {"CONSUMABLE"},
		[ZGV.L["subtype_consumable_scroll"]] = {},
		[ZGV.L["subtype_consumable_other"]] = {},
		[ZGV.L["subtype_consumable_consumable"]] = {"CONSUMABLE"},
	},

	[ZGV.L["type_container"]] = {
		[ZGV.L["subtype_container_bag"]] = {"CONTAINERS"},
		[ZGV.L["subtype_container_enchanting"]] = {},
		[ZGV.L["subtype_container_engineering"]] = {},
		[ZGV.L["subtype_container_gem"]] = {},
		[ZGV.L["subtype_container_herb"]] = {},
		[ZGV.L["subtype_container_mining"]] = {},
		[ZGV.L["subtype_container_soul"]] = {},
		[ZGV.L["subtype_container_leatherworking"]] = {},
	},

	[ZGV.L["type_gem"]] = {
		[ZGV.L["subtype_gem_blue"]] = {"GEMS"},
		[ZGV.L["subtype_gem_green"]] = {"GEMS"},
		[ZGV.L["subtype_gem_orange"]] = {"GEMS"},
		[ZGV.L["subtype_gem_meta"]] = {"GEMS"},
		[ZGV.L["subtype_gem_prismatic"]] = {"GEMS"},
		[ZGV.L["subtype_gem_purple"]] = {"GEMS"},
		[ZGV.L["subtype_gem_red"]] = {"GEMS"},
		[ZGV.L["subtype_gem_simple"]] = {"GEMS"},
		[ZGV.L["subtype_gem_yellow"]] = {"GEMS"},
	},

	[ZGV.L["type_key"]] = {
		[ZGV.L["subtype_key_key"]] = {},
	},

	[ZGV.L["type_miscellaneous"]] = {
		[ZGV.L["subtype_miscellaneous_junk"]] = {},
		[ZGV.L["subtype_miscellaneous_reagent"]] = {},
		[ZGV.L["subtype_miscellaneous_pet"]] = {},
		[ZGV.L["subtype_miscellaneous_holiday"]] = {},
		[ZGV.L["subtype_miscellaneous_mount"]] = {},
		[ZGV.L["subtype_miscellaneous_pther"]] = {},
	},

	[ZGV.L["type_reagent"]] = {
		[ZGV.L["subtype_reagent_reagent"]] = {},
	},

	[ZGV.L["type_recipe"]] = {
		[ZGV.L["subtype_recipe_alchemy"]] = {"RECIPE"},
		[ZGV.L["subtype_recipe_blacksmithing"]] = {"RECIPE"},
		[ZGV.L["subtype_recipe_book"]] = {"RECIPE"},
		[ZGV.L["subtype_recipe_cooking"]] = {"RECIPE"},
		[ZGV.L["subtype_recipe_enchanting"]] = {"RECIPE"},
		[ZGV.L["subtype_recipe_engineering"]] = {"RECIPE"},
		[ZGV.L["subtype_recipe_first_aid"]] = {"RECIPE"},
		[ZGV.L["subtype_recipe_leatherworking"]] = {"RECIPE"},
		[ZGV.L["subtype_recipe_tailoring"]] = {"RECIPE"},
	},

	[ZGV.L["type_trade_goods"]] = {
		[ZGV.L["subtype_trade_goods_cloth"]] = {"TRADEGOODS_1"},
		[ZGV.L["subtype_trade_goods_cooking"]] = {"TRADEGOODS_1"},
		[ZGV.L["subtype_trade_goods_devices"]] = {},
		[ZGV.L["subtype_trade_goods_elemental"]] = {"TRADEGOODS_1"},
		[ZGV.L["subtype_trade_goods_enchanting"]] = {"TRADEGOODS_1"},
		[ZGV.L["subtype_trade_goods_explosives"]] = {},
		[ZGV.L["subtype_trade_goods_herb"]] = {"TRADEGOODS_1"},
		[ZGV.L["subtype_trade_goods_item_enchantment"]] = {"TRADEGOODS_2"},
		[ZGV.L["subtype_trade_goods_jewelcrafting"]] = {"TRADEGOODS_1"},
		[ZGV.L["subtype_trade_goods_leather"]] = {"TRADEGOODS_1"},
		[ZGV.L["subtype_trade_goods_materials"]] = {"TRADEGOODS_1"},
		[ZGV.L["subtype_trade_goods_meat"]] = {"TRADEGOODS_2"},
		[ZGV.L["subtype_trade_goods_metal_stone"]] = {"TRADEGOODS_1"},
		[ZGV.L["subtype_trade_goods_other"]] = {"TRADEGOODS_2"},
		[ZGV.L["subtype_trade_goods_parts"]] = {"TRADEGOODS_2"},
		[ZGV.L["subtype_trade_goods_trade_goods"]] = {"TRADEGOODS_2"},
	},

	[ZGV.L["type_weapon"]] = {
		[ZGV.L["subtype_weapon_bows"]] = {"WEAPON"},
		[ZGV.L["subtype_weapon_crossbows"]] = {"WEAPON"},
		[ZGV.L["subtype_weapon_daggers"]] = {"WEAPON"},
		[ZGV.L["subtype_weapon_guns"]] = {"WEAPON"},
		[ZGV.L["subtype_weapon_fishing_poles"]] = {"WEAPON"},
		[ZGV.L["subtype_weapon_fist_weapons"]] = {"WEAPON"},
		[ZGV.L["subtype_weapon_miscellaneous"]] = {"WEAPON"},
		[ZGV.L["subtype_weapon_one_handed_axes"]] = {"WEAPON"},
		[ZGV.L["subtype_weapon_one_handed_maces"]] = {"WEAPON"},
		[ZGV.L["subtype_weapon_one_handed_swords"]] = {"WEAPON"},
		[ZGV.L["subtype_weapon_polearms"]] = {"WEAPON"},
		[ZGV.L["subtype_weapon_staves"]] = {"WEAPON"},
		[ZGV.L["subtype_weapon_thrown"]] = {"WEAPON"},
		[ZGV.L["subtype_weapon_two_handed_axes"]] = {"WEAPON"},
		[ZGV.L["subtype_weapon_two_handed_maces"]] = {"WEAPON"},
		[ZGV.L["subtype_weapon_two_handed_swords"]] = {"WEAPON"},
		[ZGV.L["subtype_weapon_wands"]] = {"WEAPON"},
	},

	[ZGV.L["type_glyph"]] = {
		[ZGV.L["subtype_glyph_death_knight"]] = {},
		[ZGV.L["subtype_glyph_druid"]] = {},
		[ZGV.L["subtype_glyph_hunter"]] = {},
		[ZGV.L["subtype_glyph_mage"]] = {},
		[ZGV.L["subtype_glyph_monk"]] = {},
		[ZGV.L["subtype_glyph_paladin"]] = {},
		[ZGV.L["subtype_glyph_priest"]] = {},
		[ZGV.L["subtype_glyph_rogue"]] = {},
		[ZGV.L["subtype_glyph_shaman"]] = {},
		[ZGV.L["subtype_glyph_warlock"]] = {},
		[ZGV.L["subtype_glyph_warrior"]] = {},
	},
}

Auctions.ItemStatus = {
	[82800] = {}, -- DEFAULT FOR ALL PETS

--	[114234] = { OVERRIDE=10, "XMOG" },
--	[114230] = { "TRADEGOODS_1", "XMOG", "OLD" },
	[118472] = { "-TRADEGOODS_2", "TRADEGOODS_1" },
--ARMOR
	[14920] = { "-ARMOR", "XMOG" }, --Jade Legplates
	[14913] = { "-ARMOR", "XMOG" }, --Jade Greaves##14913
	[14918] = { "-ARMOR", "XMOG" }, --Jade Belt##14918
	[14914] = { "-ARMOR", "XMOG" }, --Jade Bracers##14914
	[14917] = { "-ARMOR", "XMOG" }, --Jade Gauntlets##14917
	[14915] = { "-ARMOR", "XMOG" }, --Jade Breastplate##14915
	[14919] = { "-ARMOR", "XMOG" }, --Jade Circlet##14919
	[14921] = { "-ARMOR", "XMOG" }, --Jade Epaulets##14921
	[14901] = { "-ARMOR", "XMOG" }, --Saltstone Shoulder Pads##14901 
	[14895] = { "-ARMOR", "XMOG" }, --Saltstone Surcoat##14895
	[14897] = { "-ARMOR", "XMOG" }, --Saltstone Gauntlets##14897
	[14903] = { "-ARMOR", "XMOG" }, --Saltstone Armsplints##14903
	[14898] = { "-ARMOR", "XMOG" }, --Saltstone Girdle##14898
	[14900] = { "-ARMOR", "XMOG" }, --Saltstone Legplates##14900
	[14896] = { "-ARMOR", "XMOG" }, --Saltstone Sabatons##14896
	[14835] = { "-ARMOR", "XMOG" }, --Tyrant's Chestpiece##14835
	[14840] = { "-ARMOR", "XMOG" }, --Tyrant's Legplates##14840
	[14839] = { "-ARMOR", "XMOG" }, --Tyrant's Greaves##14839
	[14833] = { "-ARMOR", "XMOG" }, --Tyrant's Gauntlets##14833
	[14838] = { "-ARMOR", "XMOG" }, --Tyrant's Belt##14838
	[14841] = { "-ARMOR", "XMOG" }, --tyrants-epaulets
	[24944] = { "-ARMOR", "XMOG" }, --Bloodscale Breastplate##24944
	[24942] = { "-ARMOR", "XMOG" }, --Bloodscale Belt##24942
	[24943] = { "-ARMOR", "XMOG" }, --Bloodscale Sabatons##24943
	[24945] = { "-ARMOR", "XMOG" }, --Bloodscale Gauntlets##24945 
	[24947] = { "-ARMOR", "XMOG" }, --Bloodscale Legguards##24947
	[24949] = { "-ARMOR", "XMOG" }, --Bloodscale Bracers##24949
	[8269] = { "-ARMOR", "XMOG" }, --Ebonhold Boots##8269
	[8264] = { "-ARMOR", "XMOG" }, --Ebonhold Wristguards##8264
	[8267] = { "-ARMOR", "XMOG" }, --Ebonhold Gauntlets##8267
	[8268] = { "-ARMOR", "XMOG" }, --Ebonhold Girdle##8268
	[8265] = { "-ARMOR", "XMOG" }, --Ebonhold Armor##8265
	[8271] = { "-ARMOR", "XMOG" }, --Ebonhold Leggings##8271
	[8266] = { "-ARMOR", "XMOG" }, --Ebonhold Cloak
	[15639] = { "-ARMOR", "XMOG" }, --Ironhide Bracers##15639
	[15642] = { "-ARMOR", "XMOG" }, --Ironhide Greaves##15642
	[15641] = { "-ARMOR", "XMOG" }, --Ironhide Belt##15641
	[15644 ] = { "-ARMOR", "XMOG" }, --Ironhide Gauntlets##15644 
	[15647] = { "-ARMOR", "XMOG" }, --Ironhide Pauldrons##15647
	[15646] = { "-ARMOR", "XMOG" }, --Ironhide Legguards##15646
	[15640] = { "-ARMOR", "XMOG" }, --Ironhide Breastplate##15640
	[14804] = { "-ARMOR", "XMOG" }, --Bloodlust Helm##14804
	[14805] = { "-ARMOR", "XMOG" }, --Bloodlust Britches##14805 
	[14799 ] = { "-ARMOR", "XMOG" }, --Bloodlust Boots##14799 
	[14806 ] = { "-ARMOR", "XMOG" }, --Bloodlust Epaulets##14806 
	[14798] = { "-ARMOR", "XMOG" }, --Bloodlust Breastplate##14798
	[14807] = { "-ARMOR", "XMOG" }, --Bloodlust Bracelets##14807
	[14802] = { "-ARMOR", "XMOG" }, --Bloodlust Gauntlets##14802
	[15599] = { "-ARMOR", "XMOG" }, --Ancient Greaves##15599
	[15607] = { "-ARMOR", "XMOG" }, --Ancient Legguards##15607
	[15601] = { "-ARMOR", "XMOG" }, --Ancient Chest##15601
	[15605] = { "-ARMOR", "XMOG" }, --Ancient Gauntlets##15605
	[15600] = { "-ARMOR", "XMOG" }, --Ancient Vambraces##15600
	[15602] = { "-ARMOR", "XMOG" }, --Ancient Crown##15602
	[15608] = { "-ARMOR", "XMOG" }, --Ancient Pauldrons##15608
	[15167] = { "-ARMOR", "XMOG" }, --Imposing Bandana##15167
	[15164] = { "-ARMOR", "XMOG" }, --Imposing Vest##15164
	[15166] = { "-ARMOR", "XMOG" }, --Imposing Gloves##15166
	[15168] = { "-ARMOR", "XMOG" }, --Imposing Pants##15168
	[15162] = { "-ARMOR", "XMOG" }, --Imposing Boots##15162
	[15169] = { "-ARMOR", "XMOG" }, --Imposing Shoulder##15169
	[15165] = { "-ARMOR", "XMOG" }, --Imposing Cape##15165
	[15161] = { "-ARMOR", "XMOG" }, --Imposing Belt##15161
	[15163] = { "-ARMOR", "XMOG" }, --Imposing Bracers##15163
	[6433] = { "-ARMOR", "XMOG" }, --Imperial Leather Helm##6433
	[4737] = { "-ARMOR", "XMOG" }, --Imperial Leather Spaulder##4737
	[6430] = { "-ARMOR", "XMOG" }, --Imperial Leather Breastplate##6430
	[4063] = { "-ARMOR", "XMOG" }, --Imperial Leather Glove##4063
	[4062] = { "-ARMOR", "XMOG" }, --Imperial Leather Pants##4062
	[6431] = { "-ARMOR", "XMOG" }, --Imperial Leather Boots##6431
	[4738] = { "-ARMOR", "XMOG" }, --Imperial Leather Belt##4738
	[24697] = { "-ARMOR", "XMOG" }, --Bonechewer Skincloak##24697
	[24695] = { "-ARMOR", "XMOG" }, --Bonechewer Chestpiece##24695
	[24700] = { "-ARMOR", "XMOG" }, --Bonechewer Bands##24700
	[24696] = { "-ARMOR", "XMOG" }, --Bonechewer Spikegloves##24696
	[24693] = { "-ARMOR", "XMOG" }, --Bonechewer Pelt-Girdle##24693
	[24698] = { "-ARMOR", "XMOG" }, --Bonechewer Ripleggings##24698
	[24694] = { "-ARMOR", "XMOG" }, --Bonechewer Shredboots##24694
	[24699] = { "-ARMOR", "XMOG" }, --Bonechewer Shoulderguards##24699
	[24693] = { "-ARMOR", "XMOG" }, --Bonechewer Pelt-Girdle##24693
	[14296] = { "-ARMOR", "XMOG" }, --Arachnidian Pauldrons##14296
	[14289] = { "-ARMOR", "XMOG" }, --Arachnidian Girdle##14289
	[14290] = { "-ARMOR", "XMOG" }, --Arachnidian Footpads##14290
	[14288] = { "-ARMOR", "XMOG" }, --Arachnidian Armor##14288
	[14295] = { "-ARMOR", "XMOG" }, --Arachnidian Legguards##14295
	[14291] = { "-ARMOR", "XMOG" }, --Arachnidian Bracelets##14291
	[14294] = { "-ARMOR", "XMOG" }, --Arachnidian Gloves##14294
	[8115] = { "-ARMOR", "XMOG" }, --Hibernal Cowl##8115 
	[8111] = { "-ARMOR", "XMOG" }, --Hibernal Mantle##8111
	[8108] = { "-ARMOR", "XMOG" }, --Hibernal Bracers##8108
	[8110] = { "-ARMOR", "XMOG" }, --Hibernal Gloves##8110
	[8114] = { "-ARMOR", "XMOG" }, --Hibernal Sash##8114
	[8112] = { "-ARMOR", "XMOG" }, --Hibernal Pants##8112
	[8107] = { "-ARMOR", "XMOG" }, --Hibernal Boots##8107
	[8106] = { "-ARMOR", "XMOG" }, --Hibernal Armor##8106 
	[8113] = { "-ARMOR", "XMOG" }, --Hibernal Robe##8113
	[10250] = { "-ARMOR", "XMOG" }, --Master's Hat##10250
	[10253] = { "-ARMOR", "XMOG" }, --Master's Mantle##10253
	[10246] = { "-ARMOR", "XMOG" }, --Master's Vest##10246
	[10248] = { "-ARMOR", "XMOG" }, --Master's Bracers##10248
	[10251] = { "-ARMOR", "XMOG" }, --Master's Gloves##10251
	[10255] = { "-ARMOR", "XMOG" }, --Master's Belt##10255
	[10247] = { "-ARMOR", "XMOG" }, --Master's Boots##10247
	[10252] = { "-ARMOR", "XMOG" }, --Master's Leggings##10252
	[10253] = { "-ARMOR", "XMOG" }, --Master's Mantle##10253
	[10246] = { "-ARMOR", "XMOG" }, --Master's Vest##10246
	[10248] = { "-ARMOR", "XMOG" }, --Master's Bracers##10248
	[10251] = { "-ARMOR", "XMOG" }, --Master's Gloves##10251
	[10255] = { "-ARMOR", "XMOG" }, --Master's Belt##10255
	[10247] = { "-ARMOR", "XMOG" }, --Master's Boots##10247
	[10252] = { "-ARMOR", "XMOG" }, --Master's Leggings##10252
	[14403] = { "-ARMOR", "XMOG" }, --Resilient Handgrips##14403
	[14406] = { "-ARMOR", "XMOG" }, --Resilient Cord##14406
	[14399] = { "-ARMOR", "XMOG" }, --Resilient Boots##14399
	[14398] = { "-ARMOR", "XMOG" }, --Resilient Tunic###14398
	[14404] = { "-ARMOR", "XMOG" }, --Resilient Leggings##14404
	[23489] = { "-ARMOR", "XMOG" }, --Fel Iron Breastplate
	[31152] = { "-ARMOR", "XMOG" }, --Chestguard of Illumination
	[24960] = { "-ARMOR", "XMOG" }, --Khan'aish Breastplate
	[37792] = { "-ARMOR", "XMOG" }, --Agin's Crushing Carapace
	[25016] = { "-ARMOR", "XMOG" }, --Shattered Hand Breastplate
	[24920] = { "-ARMOR", "XMOG" }, --Grimscale Armor
	[14924] = { "-ARMOR", "XMOG" }, --Lofty Breastplate
	[7939] = { "-ARMOR", "XMOG" }, --Truesilver Breastplate
	[12613] = { "-ARMOR", "XMOG" }, --Runic Breastplate
	[14948] = { "-ARMOR", "XMOG" }, --Bloodforged Chestpiece
	[14975] = { "-ARMOR", "XMOG" }, --Exalted Harness
	[14904] = { "-ARMOR", "XMOG" }, --Brutish Breastplate
	[47594] = { "-ARMOR", "XMOG" }, --Sunforged Breastplate
	[55060] = { "-ARMOR", "XMOG" }, --Elementium Deathplate
	[22196] = { "-ARMOR", "XMOG" }, --Thick Obsidian Breastplate
	[23522] = { "-ARMOR", "XMOG" }, --Ragesteel Breastplate
	[14966] = { "-ARMOR", "XMOG" }, --Glorious Breastplate
	[14958] = { "-ARMOR", "XMOG" }, --High Chief's Armor
	[43586] = { "-ARMOR", "XMOG" }, --Icebane Chestguard
	[114232] = { "-ARMOR", "XMOG" }, --Truesteel Breastplate
	[14821] = { "-ARMOR", "XMOG" }, --Symbolic Breastplate
	[98784] = { "-ARMOR", "XMOG" }, --Crafted Malevolent Gladiator's Dreadplate Chestpiece
	[10384] = { "-ARMOR", "XMOG" }, --Hyperion Armor
	[10203] = { "-ARMOR", "XMOG" }, --Overlord's Chestplate
	[10275] = { "-ARMOR", "XMOG" }, --Emerald Breastplate
	[8312] = { "-ARMOR", "XMOG" }, --Alabaster Breastplate
	[8274] = { "-ARMOR", "XMOG" }, --Valorous Chestguard
	[14844] = { "-ARMOR", "XMOG" }, --Sunscale Chestguard
	[98926] = { "-ARMOR", "XMOG" }, --Crafted Malevolent Gladiator's Plate Chestpiece
	[93620] = { "-ARMOR", "XMOG" }, --Crafted Dreadful Gladiator's Plate Chestpiece
	[10378] = { "-ARMOR", "XMOG" }, --Commander's Armor
	[8157] = { "-ARMOR", "XMOG" }, --Jouster's Chestplate
	[94085] = { "-ARMOR", "XMOG" }, --Tarnished Fanatic's Battlevest
	[23507] = { "-ARMOR", "XMOG" }, --Adamantite Breastplate
	[90577] = { "-ARMOR", "XMOG" }, --Boblet's Bouncing Hauberk
	[10368] = { "-ARMOR", "XMOG" }, --Imbued Plate Armor
	[42725] = { "-ARMOR", "XMOG" }, --Ornate Saronite Hauberk
	[10128] = { "-ARMOR", "XMOG" }, --Revenant Chestplate
	[55032] = { "-ARMOR", "XMOG" }, --Redsteel Breastplate
	[8138] = { "-ARMOR", "XMOG" }, --Chromite Chestplate
	[10086] = { "-ARMOR", "XMOG" }, --Gothic Plate Armor
	[24968] = { "-ARMOR", "XMOG" }, --Talonguard Armor
	[106390] = { "-ARMOR", "XMOG" }, --Bladespire Breastplate
	[24936] = { "-ARMOR", "XMOG" }, --Darkcrest Breastplate
	[24952] = { "-ARMOR", "XMOG" }, --Bogslayer Breastplate
	[45167] = { "-ARMOR", "XMOG" }, --Lifeforge Breastplate
	[14931] = { "-ARMOR", "XMOG" }, --Heroic Armor
	[9966] = { "-ARMOR", "XMOG" }, --Embossed Plate Armor
	[106687] = { "-ARMOR", "XMOG" }, --Ironfist Breastplate
	[12405] = { "-ARMOR", "XMOG" }, --Thorium Armor
	[31320] = { "-ARMOR", "XMOG" }, --Chestguard of Exile
	[94034] = { "-ARMOR", "XMOG" }, --Primordial Bloodsoaked Breastplate
	[9286] = { "-ARMOR", "XMOG" }, --Field Plate Armor
	[87426] = { "-ARMOR", "XMOG" }, --Deathspite Breastplate
	[87424] = { "-ARMOR", "XMOG" }, --Cryptwarden's Breastplate
	[25000] = { "-ARMOR", "XMOG" }, --Bloodfist Breastplate
	[36389] = { "-ARMOR", "XMOG" }, --Revenant Armor
	[10240] = { "-ARMOR", "XMOG" }, --Heavy Lamellar Chestpiece
	[7930] = { "-ARMOR", "XMOG" }, --Heavy Mithril Breastplate
	[24976] = { "-ARMOR", "XMOG" }, --Reaver Armor
	[94039] = { "-ARMOR", "XMOG" }, --Forgotten Peacekeeper Breastplate
	[23489] = { "-ARMOR", "XMOG" }, --Fel Iron Breastplate
	[24928] = { "-ARMOR", "XMOG" }, --Ango'rosh Breastplate
	[14939] = { "-ARMOR", "XMOG" }, --Warbringer's Chestguard
	[25024] = { "-ARMOR", "XMOG" }, --Warlord's Iron-Breastplate
	[13067] = { "-ARMOR", "XMOG" }, --Hydralick Armor
	[36309] = { "-ARMOR", "XMOG" }, --Baleheim Armor
	[106555] = { "-ARMOR", "XMOG" }, --Stonebreaker Breastplate
	[106588] = { "-ARMOR", "XMOG" }, --Sharptusk Breastplate
	[67024] = { "-ARMOR", "XMOG" }, --Breastplate of Solemn Vows
	[36373] = { "-ARMOR", "XMOG" }, --Kraken Breastplate
	[31136] = { "-ARMOR", "XMOG" }, --Breastplate of Blade Turning
	[116427] = { "-ARMOR", "XMOG" }, --Smoldering Breastplate
	[36349] = { "-ARMOR", "XMOG" }, --Jormungar Breastplate
	[106489] = { "-ARMOR", "XMOG" }, --Shardback Breastplate
	[82287] = { "-ARMOR", "XMOG" }, --Temple Breastplate
	[25008] = { "-ARMOR", "XMOG" }, --Conqueror's Breastplate
	[37792] = { "-ARMOR", "XMOG" }, --Agin's Crushing Carapace
	[12422] = { "-ARMOR", "XMOG" }, --Imperial Plate Chest
	[82122] = { "-ARMOR", "XMOG" }, --Miner Breastplate
	[66992] = { "-ARMOR", "XMOG" }, --Harbinger's Breastplate
	[24960] = { "-ARMOR", "XMOG" }, --Khan'aish Breastplate
	[24920] = { "-ARMOR", "XMOG" }, --Grimscale Armor
	[55501] = { "-ARMOR", "XMOG" }, --Fargodeep Breastplate
	[36317] = { "-ARMOR", "XMOG" }, --Wyrmskull Breastplate
	[36381] = { "-ARMOR", "XMOG" }, --Golem Breastplate
	[31152] = { "-ARMOR", "XMOG" }, --Chestguard of Illumination
	[25016] = { "-ARMOR", "XMOG" }, --Shattered Hand Breastplate
	[36397] = { "-ARMOR", "XMOG" }, --Necropolis Breastplate
	[36389] = { "-ARMOR", "XMOG" }, --Revenant Armor
	[9286] = { "-ARMOR", "XMOG" }, --Field Plate Armor
	[42725] = { "-ARMOR", "XMOG" }, --Ornate Saronite Hauberk
	[20039] = { "-ARMOR", "XMOG" }, --Dark Iron Boots
	[119341] = { "-ARMOR", "XMOG" }, --Doomslag Greatboots
	[31232] = { "-ARMOR", "XMOG" }, --Grim Sabatons
	[14972] = { "-ARMOR", "XMOG" }, --Glorious Sabatons
	[69946] = { "-ARMOR", "XMOG" }, --Warboots of Mighty Lords
	[69948] = { "-ARMOR", "XMOG" }, --Emberforged Elementium Boots
	[49907] = { "-ARMOR", "XMOG" }, --Boots of Kingly Upheaval
	[49905] = { "-ARMOR", "XMOG" }, --Protectors of Life
	[14978] = { "-ARMOR", "XMOG" }, --Exalted Sabatons
	[82949] = { "-ARMOR", "XMOG" }, --Contender's Revenant Boots
	[14957] = { "-ARMOR", "XMOG" }, --High Chief's Sabatons
	[14922] = { "-ARMOR", "XMOG" }, --Lofty Sabatons
	[114235] = { "-ARMOR", "XMOG" }, --Truesteel Boots
	[14828] = { "-ARMOR", "XMOG" }, --Symbolic Greaves
	[87436] = { "-ARMOR", "XMOG" }, --Sollerets of Immovability
	[41392] = { "-ARMOR", "XMOG" }, --Tempered Titansteel Treads
	[14857] = { "-ARMOR", "XMOG" }, --Vanguard Sabatons
	[67233] = { "-ARMOR", "XMOG" }, --Sussurating Treads of Shok'sharak
	[41391] = { "-ARMOR", "XMOG" }, --Spiked Titansteel Treads
	[10089] = { "-ARMOR", "XMOG" }, --Gothic Sabatons
	[14839] = { "-ARMOR", "XMOG" }, --Tyrant's Greaves
	[41394] = { "-ARMOR", "XMOG" }, --Brilliant Titansteel Treads
	[14848] = { "-ARMOR", "XMOG" }, --Sunscale Sabatons
	[43588] = { "-ARMOR", "XMOG" }, --Icebane Treads
	[8141] = { "-ARMOR", "XMOG" }, --Chromite Greaves
	[14896] = { "-ARMOR", "XMOG" }, --Saltstone Sabatons
	[10371] = { "-ARMOR", "XMOG" }, --Imbued Plate Greaves
	[8278] = { "-ARMOR", "XMOG" }, --Valorous Greaves
	[8316] = { "-ARMOR", "XMOG" }, --Alabaster Plate Greaves
	[14549] = { "-ARMOR", "XMOG" }, --Boots of Avoidance
	[14911] = { "-ARMOR", "XMOG" }, --Brutish Boots
	[59464] = { "-ARMOR", "XMOG" }, --Treads of Savage Beatings
	[10167] = { "-ARMOR", "XMOG" }, --Templar Boots
	[24927] = { "-ARMOR", "XMOG" }, --Ango'rosh Sabatons
	[8160] = { "-ARMOR", "XMOG" }, --Jouster's Greaves
	[9973] = { "-ARMOR", "XMOG" }, --Embossed Plate Boots
	[14865] = { "-ARMOR", "XMOG" }, --Warleader's Greaves
	[9289] = { "-ARMOR", "XMOG" }, --Field Plate Boots
	[41348] = { "-ARMOR", "XMOG" }, --Savage Saronite Walkers
	[106627] = { "-ARMOR", "XMOG" }, --Ravenskar Sabatons
	[14940] = { "-ARMOR", "XMOG" }, --Warbringer's Sabatons
	[13068] = { "-ARMOR", "XMOG" }, --Obsidian Greaves
	[24959] = { "-ARMOR", "XMOG" }, --Khan'aish Greaves
	[42730] = { "-ARMOR", "XMOG" }, --Ornate Saronite Walkers
	[66986] = { "-ARMOR", "XMOG" }, --Troubled Steps
	[40187] = { "-ARMOR", "XMOG" }, --Poignant Sabatons
	[106594] = { "-ARMOR", "XMOG" }, --Sharptusk Sabatons
	[10276] = { "-ARMOR", "XMOG" }, --Emerald Sabatons
	[24975] = { "-ARMOR", "XMOG" }, --Reaver Greaves
	[71029] = { "-ARMOR", "XMOG" }, --Arachnaflame Treads
	[94033] = { "-ARMOR", "XMOG" }, --Primordial Bloodsoaked Greaves
	[10385] = { "-ARMOR", "XMOG" }, --Hyperion Greaves
	[24943] = { "-ARMOR", "XMOG" }, --Bloodscale Sabatons
	[87433] = { "-ARMOR", "XMOG" }, --Blackfooted Greatboots
	[7933] = { "-ARMOR", "XMOG" }, --Heavy Mithril Boots
	[10376] = { "-ARMOR", "XMOG" }, --Commander's Boots
	[94037] = { "-ARMOR", "XMOG" }, --Forgotten Peacekeeper Boots
	[10238] = { "-ARMOR", "XMOG" }, --Heavy Lamellar Boots
	[24951] = { "-ARMOR", "XMOG" }, --Bogslayer Sabatons
	[12409] = { "-ARMOR", "XMOG" }, --Thorium Boots
	[94086] = { "-ARMOR", "XMOG" }, --Tarnished Fanatic's Warboots
	[39717] = { "-ARMOR", "XMOG" }, --Inexorable Sabatons
	[24999] = { "-ARMOR", "XMOG" }, --Bloodfist Greaves
	[25023] = { "-ARMOR", "XMOG" }, --Warlord's Sabatons
	[36396] = { "-ARMOR", "XMOG" }, --Necropolis Sabatons
	[24983] = { "-ARMOR", "XMOG" }, --Boulderfist Greaves
	[24967] = { "-ARMOR", "XMOG" }, --Talonguard Greaves
	[106561] = { "-ARMOR", "XMOG" }, --Stonebreaker Sabatons
	[106429] = { "-ARMOR", "XMOG" }, --Rimeplate Sabatons
	[12426] = { "-ARMOR", "XMOG" }, --Imperial Plate Boots
	[23487] = { "-ARMOR", "XMOG" }, --Fel Iron Plate Boots
	[10131] = { "-ARMOR", "XMOG" }, --Revenant Boots
	[25015] = { "-ARMOR", "XMOG" }, --Shattered Hand Sabatons
	[13070] = { "-ARMOR", "XMOG" }, --Sapphiron's Scale Boots
	[25007] = { "-ARMOR", "XMOG" }, --Conqueror's Greaves
	[106495] = { "-ARMOR", "XMOG" }, --Shardback Sabatons
	[36292] = { "-ARMOR", "XMOG" }, --Westguard Greaves
	[55855] = { "-ARMOR", "XMOG" }, --Darksky Treads
	[106693] = { "-ARMOR", "XMOG" }, --Ironfist Sabatons
	[36308] = { "-ARMOR", "XMOG" }, --Baleheim Greaves
	[31125] = { "-ARMOR", "XMOG" }, --Boots of the Decimator
	[82073] = { "-ARMOR", "XMOG" }, --Brick Sabatons
	[82293] = { "-ARMOR", "XMOG" }, --Temple Sabatons
	[36372] = { "-ARMOR", "XMOG" }, --Kraken Greaves
	[36380] = { "-ARMOR", "XMOG" }, --Golem Sabatons
	[36364] = { "-ARMOR", "XMOG" }, --Magnataur Sabatons
	[36348] = { "-ARMOR", "XMOG" }, --Jormungar Sabatons
	[31276] = { "-ARMOR", "XMOG" }, --Boots of Zealotry
	[55508] = { "-ARMOR", "XMOG" }, --Jasperlode Sabatons
	[16724] = { "-ARMOR", "XMOG" }, --Lightforge Gauntlets
	[14926] = { "-ARMOR", "XMOG" }, --Lofty Gauntlets
	[14846] = { "-ARMOR", "XMOG" }, --Sunscale Gauntlets
	[14959] = { "-ARMOR", "XMOG" }, --High Chief's Gauntlets
	[113632] = { "-ARMOR", "XMOG" }, --Gauntlets of the Heavy Hand
	[69938] = { "-ARMOR", "XMOG" }, --Holy Flame Gauntlets
	[69936] = { "-ARMOR", "XMOG" }, --Fists of Fury
	[23520] = { "-ARMOR", "XMOG" }, --Ragesteel Gloves
	[14855] = { "-ARMOR", "XMOG" }, --Vanguard Gauntlets
	[14833] = { "-ARMOR", "XMOG" }, --Tyrant's Gauntlets
	[114237] = { "-ARMOR", "XMOG" }, --Truesteel Gauntlets
	[14967] = { "-ARMOR", "XMOG" }, --Glorious Gauntlets
	[14933] = { "-ARMOR", "XMOG" }, --Heroic Gauntlets
	[9967] = { "-ARMOR", "XMOG" }, --Embossed Plate Gauntlets
	[14942] = { "-ARMOR", "XMOG" }, --Warbringer's Gauntlets
	[8158] = { "-ARMOR", "XMOG" }, --Jouster's Gauntlets
	[25001] = { "-ARMOR", "XMOG" }, --Bloodfist Gloves
	[98785] = { "-ARMOR", "XMOG" }, --Crafted Malevolent Gladiator's Dreadplate Gauntlets
	[14826] = { "-ARMOR", "XMOG" }, --Symbolic Gauntlets
	[8276] = { "-ARMOR", "XMOG" }, --Valorous Gauntlets
	[10386] = { "-ARMOR", "XMOG" }, --Hyperion Gauntlets
	[8314] = { "-ARMOR", "XMOG" }, --Alabaster Plate Gauntlets
	[14949] = { "-ARMOR", "XMOG" }, --Bloodforged Gauntlets
	[98927] = { "-ARMOR", "XMOG" }, --Crafted Malevolent Gladiator's Plate Gauntlets
	[14905] = { "-ARMOR", "XMOG" }, --Brutish Gauntlets
	[10242] = { "-ARMOR", "XMOG" }, --Heavy Lamellar Gauntlets
	[9287] = { "-ARMOR", "XMOG" }, --Field Plate Gauntlets
	[10380] = { "-ARMOR", "XMOG" }, --Commander's Gauntlets
	[24921] = { "-ARMOR", "XMOG" }, --Grimscale Gauntlets
	[14863] = { "-ARMOR", "XMOG" }, --Warleader's Gauntlets
	[41356] = { "-ARMOR", "XMOG" }, --Righteous Gauntlets
	[94032] = { "-ARMOR", "XMOG" }, --Primordial Bloodsoaked Gauntlets
	[106457] = { "-ARMOR", "XMOG" }, --Rockspine Gauntlets
	[94038] = { "-ARMOR", "XMOG" }, --Forgotten Peacekeeper Gauntlets
	[67109] = { "-ARMOR", "XMOG" }, --Gauntlets of Chattering Valves
	[10369] = { "-ARMOR", "XMOG" }, --Imbued Plate Gauntlets
	[25009] = { "-ARMOR", "XMOG" }, --Conqueror's Gauntlets
	[24945] = { "-ARMOR", "XMOG" }, --Bloodscale Gauntlets
	[55026] = { "-ARMOR", "XMOG" }, --Redsteel Gauntlets
	[8139] = { "-ARMOR", "XMOG" }, --Chromite Gauntlets
	[55034] = { "-ARMOR", "XMOG" }, --Stormforged Gauntlets
	[10277] = { "-ARMOR", "XMOG" }, --Emerald Gauntlets
	[66989] = { "-ARMOR", "XMOG" }, --Endwyn's Flickering Gauntlets
	[54852] = { "-ARMOR", "XMOG" }, --Hardened Obsidium Gauntlets
	[10087] = { "-ARMOR", "XMOG" }, --Gothic Plate Gauntlets
	[24969] = { "-ARMOR", "XMOG" }, --Talonguard Gloves
	[24937] = { "-ARMOR", "XMOG" }, --Darkcrest Gauntlets
	[94089] = { "-ARMOR", "XMOG" }, --Tarnished Fanatic's Deathgrips
	[13071] = { "-ARMOR", "XMOG" }, --Plated Fist of Hakoo
	[106688] = { "-ARMOR", "XMOG" }, --Ironfist Gauntlets
	[40952] = { "-ARMOR", "XMOG" }, --Spiked Cobalt Gauntlets
	[7919] = { "-ARMOR", "XMOG" }, --Heavy Mithril Gauntlet
	[41975] = { "-ARMOR", "XMOG" }, --Cobalt Gauntlets
	[37789] = { "-ARMOR", "XMOG" }, --Gauntlets of Disembowelment
	[67057] = { "-ARMOR", "XMOG" }, --Oath-Bound Gauntlets
	[24953] = { "-ARMOR", "XMOG" }, --Bogslayer Gauntlets
	[36390] = { "-ARMOR", "XMOG" }, --Revenant Gauntlets
	[25025] = { "-ARMOR", "XMOG" }, --Warlord's Iron-Gauntlets
	[40347] = { "-ARMOR", "XMOG" }, --Zeliek's Gauntlets
	[36334] = { "-ARMOR", "XMOG" }, --Grizzlemaw Gauntlets
	[82068] = { "-ARMOR", "XMOG" }, --Brick Gauntlets
	[36374] = { "-ARMOR", "XMOG" }, --Kraken Gauntlets
	[106721] = { "-ARMOR", "XMOG" }, --Stonecrag Gauntlets
	[23482] = { "-ARMOR", "XMOG" }, --Fel Iron Plate Gloves
	[106556] = { "-ARMOR", "XMOG" }, --Stonebreaker Gauntlets
	[10129] = { "-ARMOR", "XMOG" }, --Revenant Gauntlets
	[106556] = { "-ARMOR", "XMOG" }, --Stonebreaker Gauntlets
	[24929] = { "-ARMOR", "XMOG" }, --Ango'rosh Gauntlets
	[87449] = { "-ARMOR", "XMOG" }, --Errick's Woundbinder Gauntlets
	[36382] = { "-ARMOR", "XMOG" }, --Golem Gauntlets
	[87445] = { "-ARMOR", "XMOG" }, --Gauntlets of Blurring Fingers
	[87446] = { "-ARMOR", "XMOG" }, --Gauntlets of the Solemn Charge
	[25017] = { "-ARMOR", "XMOG" }, --Shattered Hand Gauntlets
	[37782] = { "-ARMOR", "XMOG" }, --Gauntlets of the Cheerful Hearth
	[31180] = { "-ARMOR", "XMOG" }, --Gauntlets of the Skullsplitter
	[13072] = { "-ARMOR", "XMOG" }, --Stonegrip Gauntlets
	[106424] = { "-ARMOR", "XMOG" }, --Rimeplate Gauntlets
	[24977] = { "-ARMOR", "XMOG" }, --Reaver Gloves
	[36398] = { "-ARMOR", "XMOG" }, --Necropolis Gloves
	[55521] = { "-ARMOR", "XMOG" }, --Stonewrought Gauntlets
	[82288] = { "-ARMOR", "XMOG" }, --Temple Gauntlets
	[36294] = { "-ARMOR", "XMOG" }, --Westguard Gloves
	[36350] = { "-ARMOR", "XMOG" }, --Jormungar Gauntlets
	[37795] = { "-ARMOR", "XMOG" }, --Grips of the Valiant Champion
	[31137] = { "-ARMOR", "XMOG" }, --Gauntlets of Purification
	[14969] = { "-ARMOR", "XMOG" }, --Glorious Headdress
	[41388] = { "-ARMOR", "XMOG" }, --Brilliant Titansteel Helm
	[78322] = { "-ARMOR", "XMOG" }, --Replica Helm of Valor
	[19148] = { "-ARMOR", "XMOG" }, --Dark Iron Helm
	[41386] = { "-ARMOR", "XMOG" }, --Spiked Titansteel Helm
	[14919] = { "-ARMOR", "XMOG" }, --Jade Circlet
	[41387] = { "-ARMOR", "XMOG" }, --Tempered Titansteel Helm
	[14858] = { "-ARMOR", "XMOG" }, --Vanguard Headdress
	[14899] = { "-ARMOR", "XMOG" }, --Saltstone Helm
	[14849] = { "-ARMOR", "XMOG" }, --Sunscale Helmet
	[98786] = { "-ARMOR", "XMOG" }, --Crafted Malevolent Gladiator's Dreadplate Helm
	[98928] = { "-ARMOR", "XMOG" }, --Crafted Malevolent Gladiator's Plate Helm
	[14866] = { "-ARMOR", "XMOG" }, --Warleader's Crown
	[114230] = { "-ARMOR", "XMOG" }, --Truesteel Helm
	[14961] = { "-ARMOR", "XMOG" }, --High Chief's Crown
	[14952] = { "-ARMOR", "XMOG" }, --Bloodforged Helmet
	[14831] = { "-ARMOR", "XMOG" }, --Symbolic Crown
	[87453] = { "-ARMOR", "XMOG" }, --Endwyn's Toothy Visage
	[14979] = { "-ARMOR", "XMOG" }, --Exalted Helmet
	[109174] = { "-ARMOR", "XMOG" }, --Razorguard Mechshades
	[106624] = { "-ARMOR", "XMOG" }, --Ravenskar Helm
	[55023] = { "-ARMOR", "XMOG" }, --Hardened Obsidium Helm
	[8279] = { "-ARMOR", "XMOG" }, --Valorous Helm
	[42728] = { "-ARMOR", "XMOG" }, --Ornate Saronite Skullshield
	[14944] = { "-ARMOR", "XMOG" }, --Warbringer's Crown
	[98856] = { "-ARMOR", "XMOG" }, --Crafted Malevolent Gladiator's Ornamented Headcover
	[24962] = { "-ARMOR", "XMOG" }, --Khan'aish Helmet
	[7922] = { "-ARMOR", "XMOG" }, --Steel Plate Helm
	[8161] = { "-ARMOR", "XMOG" }, --Jouster's Visor
	[24922] = { "-ARMOR", "XMOG" }, --Grimscale Helm
	[10207] = { "-ARMOR", "XMOG" }, --Overlord's Crown
	[9290] = { "-ARMOR", "XMOG" }, --Field Plate Helmet
	[45107] = { "-ARMOR", "XMOG" }, --Iron Riveted War Helm
	[106723] = { "-ARMOR", "XMOG" }, --Stonecrag Helm
	[10372] = { "-ARMOR", "XMOG" }, --Imbued Plate Helmet
	[66983] = { "-ARMOR", "XMOG" }, --Helm of Fatal Vision
	[10241] = { "-ARMOR", "XMOG" }, --Heavy Lamellar Helm
	[10279] = { "-ARMOR", "XMOG" }, --Emerald Helm
	[14935] = { "-ARMOR", "XMOG" }, --Heroic Skullcap
	[94211] = { "-ARMOR", "XMOG" }, --Tarnished Fanatic's Headcover
	[36375] = { "-ARMOR", "XMOG" }, --Kraken Helm
	[24986] = { "-ARMOR", "XMOG" }, --Boulderfist Helm
	[7934] = { "-ARMOR", "XMOG" }, --Heavy Mithril Helm
	[10379] = { "-ARMOR", "XMOG" }, --Commander's Helm
	[87455] = { "-ARMOR", "XMOG" }, --Davidian's All-Seeing Eyes
	[106525] = { "-ARMOR", "XMOG" }, --Gul'rok Helm
	[106426] = { "-ARMOR", "XMOG" }, --Rimeplate Helm
	[37793] = { "-ARMOR", "XMOG" }, --Skullcage of Eternal Terror
	[24938] = { "-ARMOR", "XMOG" }, --Darkcrest Helm
	[37787] = { "-ARMOR", "XMOG" }, --Greathelm of the Unyielding Bull
	[25026] = { "-ARMOR", "XMOG" }, --Warlord's Iron-Helm
	[10132] = { "-ARMOR", "XMOG" }, --Revenant Helmet
	[55039] = { "-ARMOR", "XMOG" }, --Stormforged Helm
	[116426] = { "-ARMOR", "XMOG" }, --Smoldering Helm
	[106492] = { "-ARMOR", "XMOG" }, --Shardback Helm
	[24946] = { "-ARMOR", "XMOG" }, --Bloodscale Helm
	[106690] = { "-ARMOR", "XMOG" }, --Ironfist Helm
	[25010] = { "-ARMOR", "XMOG" }, --Conqueror's Helmet
	[10090] = { "-ARMOR", "XMOG" }, --Gothic Plate Helmet
	[36311] = { "-ARMOR", "XMOG" }, --Baleheim Helmet
	[12427] = { "-ARMOR", "XMOG" }, --Imperial Plate Helm
	[36383] = { "-ARMOR", "XMOG" }, --Golem Helmet
	[67050] = { "-ARMOR", "XMOG" }, --Ben-Son's Royal Crown
	[67122] = { "-ARMOR", "XMOG" }, --Helm of Holy Visions
	[36391] = { "-ARMOR", "XMOG" }, --Revenant Helmet
	[87454] = { "-ARMOR", "XMOG" }, --Light-Sealed Casque
	[24930] = { "-ARMOR", "XMOG" }, --Ango'rosh Helm
	[12410] = { "-ARMOR", "XMOG" }, --Thorium Helm
	[82290] = { "-ARMOR", "XMOG" }, --Temple Helm
	[36295] = { "-ARMOR", "XMOG" }, --Westguard Helm
	[36399] = { "-ARMOR", "XMOG" }, --Necropolis Helm
	[55531] = { "-ARMOR", "XMOG" }, --Crystalvein Helm
	[36327] = { "-ARMOR", "XMOG" }, --Halgrind Helmet
	[13073] = { "-ARMOR", "XMOG" }, --Mugthol's Helm
	[82903] = { "-ARMOR", "XMOG" }, --Ghost-Forged Helm
	[14970] = { "-ARMOR", "XMOG" }, --Glorious Legplates
	[71983] = { "-ARMOR", "XMOG" }, --Unstoppable Destroyer's Legplates
	[10633] = { "-ARMOR", "XMOG" }, --Silvershell Leggings
	[14859] = { "-ARMOR", "XMOG" }, --Vanguard Legplates
	[71982] = { "-ARMOR", "XMOG" }, --Pyrium Legplates of Purified Evil
	[71984] = { "-ARMOR", "XMOG" }, --Foundations of Courage
	[14850] = { "-ARMOR", "XMOG" }, --Sunscale Legplates
	[14554] = { "-ARMOR", "XMOG" }, --Cloudkeeper Legplates
	[49902] = { "-ARMOR", "XMOG" }, --Puresteel Legplates
	[14900] = { "-ARMOR", "XMOG" }, --Saltstone Legplates
	[14840] = { "-ARMOR", "XMOG" }, --Tyrant's Legplates
	[14928] = { "-ARMOR", "XMOG" }, --Lofty Legguards
	[114234] = { "-ARMOR", "XMOG" }, --Truesteel Greaves
	[98606] = { "-ARMOR", "XMOG" }, --Protector's Trillium Legguards
	[49904] = { "-ARMOR", "XMOG" }, --Pillars of Might
	[93456] = { "-ARMOR", "XMOG" }, --Crafted Dreadful Gladiator's Dreadplate Legguards
	[98607] = { "-ARMOR", "XMOG" }, --Avenger's Trillium Legplates
	[12614] = { "-ARMOR", "XMOG" }, --Runic Plate Leggings
	[98787] = { "-ARMOR", "XMOG" }, --Crafted Malevolent Gladiator's Dreadplate Legguards
	[14980] = { "-ARMOR", "XMOG" }, --Exalted Legplates
	[14908] = { "-ARMOR", "XMOG" }, --Brutish Legguards
	[10133] = { "-ARMOR", "XMOG" }, --Revenant Leggings
	[10389] = { "-ARMOR", "XMOG" }, --Hyperion Legplates
	[10373] = { "-ARMOR", "XMOG" }, --Imbued Plate Leggings
	[41347] = { "-ARMOR", "XMOG" }, --Savage Saronite Legplates
	[13075] = { "-ARMOR", "XMOG" }, --Direwing Legguards
	[10382] = { "-ARMOR", "XMOG" }, --Commander's Leggings
	[14962] = { "-ARMOR", "XMOG" }, --High Chief's Legguards
	[10169] = { "-ARMOR", "XMOG" }, --Templar Legplates
	[14945] = { "-ARMOR", "XMOG" }, --Warbringer's Legguards
	[41346] = { "-ARMOR", "XMOG" }, --Righteous Greaves
	[14867] = { "-ARMOR", "XMOG" }, --Warleader's Leggings
	[67141] = { "-ARMOR", "XMOG" }, --Corefire Legplates
	[10208] = { "-ARMOR", "XMOG" }, --Overlord's Legplates
	[8143] = { "-ARMOR", "XMOG" }, --Chromite Legplates
	[90717] = { "-ARMOR", "XMOG" }, --Qu'nas' Apocryphal Legplates
	[9291] = { "-ARMOR", "XMOG" }, --Field Plate Leggings
	[8162] = { "-ARMOR", "XMOG" }, --Jouster's Legplates
	[24931] = { "-ARMOR", "XMOG" }, --Ango'rosh Legguards
	[90718] = { "-ARMOR", "XMOG" }, --Torik-Ethis' Bloodied Legguards
	[24955] = { "-ARMOR", "XMOG" }, --Bogslayer Legplates
	[94088] = { "-ARMOR", "XMOG" }, --Tarnished Fanatic's Wargreaves
	[8318] = { "-ARMOR", "XMOG" }, --Alabaster Plate Leggings
	[24987] = { "-ARMOR", "XMOG" }, --Boulderfist Legplates
	[9970] = { "-ARMOR", "XMOG" }, --Embossed Plate Leggings
	[87461] = { "-ARMOR", "XMOG" }, --Greatheart Pants
	[90722] = { "-ARMOR", "XMOG" }, --Torik-Ethis' Gilded Legplates
	[87460] = { "-ARMOR", "XMOG" }, --Legplates of the Wandering Warrior
	[10280] = { "-ARMOR", "XMOG" }, --Emerald Legplates
	[106625] = { "-ARMOR", "XMOG" }, --Ravenskar Legplates
	[94030] = { "-ARMOR", "XMOG" }, --Primordial Bloodsoaked Legplates
	[106559] = { "-ARMOR", "XMOG" }, --Stonebreaker Legplates
	[14936] = { "-ARMOR", "XMOG" }, --Heroic Legplates
	[12414] = { "-ARMOR", "XMOG" }, --Thorium Leggings
	[8280] = { "-ARMOR", "XMOG" }, --Valorous Legguards
	[55038] = { "-ARMOR", "XMOG" }, --Stormforged Legguards
	[25011] = { "-ARMOR", "XMOG" }, --Conqueror's Legplates
	[10091] = { "-ARMOR", "XMOG" }, --Gothic Plate Leggings
	[106592] = { "-ARMOR", "XMOG" }, --Sharptusk Legplates
	[36376] = { "-ARMOR", "XMOG" }, --Kraken Legplates
	[24971] = { "-ARMOR", "XMOG" }, --Talonguard Legplates
	[66982] = { "-ARMOR", "XMOG" }, --Greaves of the Outcast Knight
	[67043] = { "-ARMOR", "XMOG" }, --Greaves of Sullen Earth
	[25027] = { "-ARMOR", "XMOG" }, --Warlord's Iron-Legplates
	[10244] = { "-ARMOR", "XMOG" }, --Heavy Lamellar Leggings
	[106493] = { "-ARMOR", "XMOG" }, --Shardback Legplates
	[81992] = { "-ARMOR", "XMOG" }, --Wall Legplates
	[24979] = { "-ARMOR", "XMOG" }, --Reaver Legplates
	[82291] = { "-ARMOR", "XMOG" }, --Temple Legplates
	[94036] = { "-ARMOR", "XMOG" }, --Forgotten Peacekeeper Leggings
	[106691] = { "-ARMOR", "XMOG" }, --Ironfist Legplates
	[106427] = { "-ARMOR", "XMOG" }, --Rimeplate Legplates
	[37743] = { "-ARMOR", "XMOG" }, --Legguards of Brutalization
	[24923] = { "-ARMOR", "XMOG" }, --Grimscale Legguards
	[36400] = { "-ARMOR", "XMOG" }, --Necropolis Legplates
	[36312] = { "-ARMOR", "XMOG" }, --Baleheim Legguards
	[12429] = { "-ARMOR", "XMOG" }, --Imperial Plate Leggings
	[55538] = { "-ARMOR", "XMOG" }, --Ravencrest Legplates
	[25003] = { "-ARMOR", "XMOG" }, --Bloodfist Legplates
	[36384] = { "-ARMOR", "XMOG" }, --Golem Legplates
	[36296] = { "-ARMOR", "XMOG" }, --Westguard Legplates
	[31298] = { "-ARMOR", "XMOG" }, --Legguards of the Shattered Hand
	[36328] = { "-ARMOR", "XMOG" }, --Halgrind Legplates
	[37786] = { "-ARMOR", "XMOG" }, --Legguards of the Forlorn Seas
	[25019] = { "-ARMOR", "XMOG" }, --Shattered Hand Legplates
	[36392] = { "-ARMOR", "XMOG" }, --Revenant Legguards
	[78325] = { "-ARMOR", "XMOG" }, --Replica Spaulders of Valor
	[50020] = { "-ARMOR", "XMOG" }, --Raging Behemoth's Shoulderplates
	[14971] = { "-ARMOR", "XMOG" }, --Glorious Shoulder Pads
	[14901] = { "-ARMOR", "XMOG" }, --Saltstone Shoulder Pads
	[14851] = { "-ARMOR", "XMOG" }, --Sunscale Spaulders
	[14860] = { "-ARMOR", "XMOG" }, --Vanguard Pauldrons
	[33173] = { "-ARMOR", "XMOG" }, --Ragesteel Shoulders
	[14830] = { "-ARMOR", "XMOG" }, --Symbolic Pauldrons
	[54876] = { "-ARMOR", "XMOG" }, --Hardened Obsidium Shoulders
	[14929] = { "-ARMOR", "XMOG" }, --Lofty Shoulder Pads
	[14946] = { "-ARMOR", "XMOG" }, --Warbringer's Spaulders
	[14963] = { "-ARMOR", "XMOG" }, --High Chief's Pauldrons
	[114231] = { "-ARMOR", "XMOG" }, --Truesteel Pauldrons
	[14955] = { "-ARMOR", "XMOG" }, --Bloodforged Shoulder Pads
	[98788] = { "-ARMOR", "XMOG" }, --Crafted Malevolent Gladiator's Dreadplate Shoulders
	[8319] = { "-ARMOR", "XMOG" }, --Alabaster Plate Pauldrons
	[14981] = { "-ARMOR", "XMOG" }, --Exalted Epaulets
	[8281] = { "-ARMOR", "XMOG" }, --Valorous Pauldrons
	[10390] = { "-ARMOR", "XMOG" }, --Hyperion Pauldrons
	[10374] = { "-ARMOR", "XMOG" }, --Imbued Plate Pauldrons
	[14841] = { "-ARMOR", "XMOG" }, --Tyrant's Epaulets
	[9292] = { "-ARMOR", "XMOG" }, --Field Plate Pauldrons
	[98930] = { "-ARMOR", "XMOG" }, --Crafted Malevolent Gladiator's Plate Shoulders
	[10281] = { "-ARMOR", "XMOG" }, --Emerald Pauldrons
	[24996] = { "-ARMOR", "XMOG" }, --Warmaul Epaulets
	[41351] = { "-ARMOR", "XMOG" }, --Savage Saronite Pauldrons
	[10383] = { "-ARMOR", "XMOG" }, --Commander's Pauldrons
	[14937] = { "-ARMOR", "XMOG" }, --Heroic Pauldrons
	[42727] = { "-ARMOR", "XMOG" }, --Ornate Saronite Pauldrons
	[82944] = { "-ARMOR", "XMOG" }, --Contender's Revenant Shoulders
	[21805] = { "-ARMOR", "XMOG" }, --Polished Obsidian Pauldrons
	[14909] = { "-ARMOR", "XMOG" }, --Brutish Shoulders
	[8144] = { "-ARMOR", "XMOG" }, --Chromite Pauldrons
	[24932] = { "-ARMOR", "XMOG" }, --Ango'rosh Pauldrons
	[14868] = { "-ARMOR", "XMOG" }, --Warleader's Shoulders
	[9971] = { "-ARMOR", "XMOG" }, --Embossed Plate Pauldrons
	[10209] = { "-ARMOR", "XMOG" }, --Overlord's Spaulders
	[90576] = { "-ARMOR", "XMOG" }, --Spaulders of the Scorned
	[36337] = { "-ARMOR", "XMOG" }, --Grizzlemaw Epaulets
	[10245] = { "-ARMOR", "XMOG" }, --Heavy Lamellar Pauldrons
	[40675] = { "-ARMOR", "XMOG" }, --Tempered Saronite Shoulders
	[94091] = { "-ARMOR", "XMOG" }, --Tarnished Fanatic's Pauldrons
	[59901] = { "-ARMOR", "XMOG" }, --Heaving Plates of Protection
	[10092] = { "-ARMOR", "XMOG" }, --Gothic Plate Spaulders
	[10170] = { "-ARMOR", "XMOG" }, --Templar Pauldrons
	[24940] = { "-ARMOR", "XMOG" }, --Darkcrest Pauldrons
	[25020] = { "-ARMOR", "XMOG" }, --Shattered Hand Epaulets
	[14552] = { "-ARMOR", "XMOG" }, --Stockade Pauldrons
	[44312] = { "-ARMOR", "XMOG" }, --Wapach's Spaulders of Solidarity
	[24924] = { "-ARMOR", "XMOG" }, --Grimscale Pauldrons
	[13066] = { "-ARMOR", "XMOG" }, --Wyrmslayer Spaulders
	[94031] = { "-ARMOR", "XMOG" }, --Primordial Bloodsoaked Pauldrons
	[87494] = { "-ARMOR", "XMOG" }, --Shoulderguards of Honest Labor
	[82127] = { "-ARMOR", "XMOG" }, --Miner Pauldrons
	[7918] = { "-ARMOR", "XMOG" }, --Heavy Mithril Shoulder
	[25028] = { "-ARMOR", "XMOG" }, --Warlord's Iron-Epaulets
	[12428] = { "-ARMOR", "XMOG" }, --Imperial Plate Shoulders
	[66977] = { "-ARMOR", "XMOG" }, --Pauldrons of Toil
	[106428] = { "-ARMOR", "XMOG" }, --Rimeplate Pauldrons
	[36401] = { "-ARMOR", "XMOG" }, --Necropolis Epaulets
	[25012] = { "-ARMOR", "XMOG" }, --Conqueror's Epaulets
	[36297] = { "-ARMOR", "XMOG" }, --Westguard Epaulets
	[106461] = { "-ARMOR", "XMOG" }, --Rockspine Pauldrons
	[106626] = { "-ARMOR", "XMOG" }, --Ravenskar Pauldrons
	[106527] = { "-ARMOR", "XMOG" }, --Gul'rok Pauldrons
	[106659] = { "-ARMOR", "XMOG" }, --Talon Guard Pauldrons
	[36385] = { "-ARMOR", "XMOG" }, --Golem Pauldrons
	[106725] = { "-ARMOR", "XMOG" }, --Stonecrag Pauldrons
	[37783] = { "-ARMOR", "XMOG" }, --Blood-Tempered Spaulders
	[55546] = { "-ARMOR", "XMOG" }, --Fargodeep Pauldrons
	[94042] = { "-ARMOR", "XMOG" }, --Forgotten Peacekeeper Shoulders
	[24956] = { "-ARMOR", "XMOG" }, --Bogslayer Pauldrons
	[82182] = { "-ARMOR", "XMOG" }, --Snowy Pauldrons
	[24972] = { "-ARMOR", "XMOG" }, --Talonguard Epaulets
	[36377] = { "-ARMOR", "XMOG" }, --Kraken Epaulets
	[36369] = { "-ARMOR", "XMOG" }, --Magnataur Pauldrons
	[119337] = { "-ARMOR", "XMOG" }, --Ripswallow Plate Belt
	[118888] = { "-ARMOR", "XMOG" }, --Ashelia's Adorned Waistguard
	[16723] = { "-ARMOR", "XMOG" }, --Lightforge Belt
	[45552] = { "-ARMOR", "XMOG" }, --Plate Girdle of Righteousness
	[45551] = { "-ARMOR", "XMOG" }, --Indestructible Plate Girdle
	[16736] = { "-ARMOR", "XMOG" }, --Belt of Valor
	[14968] = { "-ARMOR", "XMOG" }, --Glorious Belt
	[30034] = { "-ARMOR", "XMOG" }, --Belt of the Guardian
	[14927] = { "-ARMOR", "XMOG" }, --Lofty Belt
	[14864] = { "-ARMOR", "XMOG" }, --Warleader's Belt
	[14827] = { "-ARMOR", "XMOG" }, --Symbolic Belt
	[98616] = { "-ARMOR", "XMOG" }, --Avenger's Trillium Waistplate
	[14856] = { "-ARMOR", "XMOG" }, --Vanguard Girdle
	[14934] = { "-ARMOR", "XMOG" }, --Heroic Girdle
	[98615] = { "-ARMOR", "XMOG" }, --Protector's Trillium Waistguard
	[114233] = { "-ARMOR", "XMOG" }, --Truesteel Waistguard
	[10387] = { "-ARMOR", "XMOG" }, --Hyperion Girdle
	[43587] = { "-ARMOR", "XMOG" }, --Icebane Girdle
	[14847] = { "-ARMOR", "XMOG" }, --Sunscale Belt
	[55081] = { "-ARMOR", "XMOG" }, --Ornate Pyrium Belt
	[10130] = { "-ARMOR", "XMOG" }, --Revenant Girdle
	[31227] = { "-ARMOR", "XMOG" }, --Feathered Girdle
	[16864] = { "-ARMOR", "XMOG" }, --Belt of Might
	[14943] = { "-ARMOR", "XMOG" }, --Warbringer's Belt
	[8159] = { "-ARMOR", "XMOG" }, --Jouster's Girdle
	[14950] = { "-ARMOR", "XMOG" }, --Bloodforged Belt
	[9968] = { "-ARMOR", "XMOG" }, --Embossed Plate Girdle
	[98859] = { "-ARMOR", "XMOG" }, --Crafted Malevolent Gladiator's Girdle of Accuracy
	[45975] = { "-ARMOR", "XMOG" }, --Cable of the Metrognome
	[19051] = { "-ARMOR", "XMOG" }, --Girdle of the Dawn
	[13145] = { "-ARMOR", "XMOG" }, --Enormous Ogre Belt
	[78889] = { "-ARMOR", "XMOG" }, --Waistplate of the Desecrated Future
	[14960] = { "-ARMOR", "XMOG" }, --High Chief's Belt
	[98848] = { "-ARMOR", "XMOG" }, --Crafted Malevolent Gladiator's Clasp of Cruelty
	[55027] = { "-ARMOR", "XMOG" }, --Redsteel Belt
	[106623] = { "-ARMOR", "XMOG" }, --Ravenskar Girdle
	[36331] = { "-ARMOR", "XMOG" }, --Grizzlemaw Belt
	[41352] = { "-ARMOR", "XMOG" }, --Savage Saronite Waistguard
	[14918] = { "-ARMOR", "XMOG" }, --Jade Belt
	[14977] = { "-ARMOR", "XMOG" }, --Exalted Girdle
	[118853] = { "-ARMOR", "XMOG" }, --Iron Beltguard of Fuufuu
	[10088] = { "-ARMOR", "XMOG" }, --Gothic Plate Girdle
	[94087] = { "-ARMOR", "XMOG" }, --Tarnished Fanatic's Girdle
	[9288] = { "-ARMOR", "XMOG" }, --Field Plate Girdle
	[10278] = { "-ARMOR", "XMOG" }, --Emerald Girdle
	[36323] = { "-ARMOR", "XMOG" }, --Halgrind Belt
	[12424] = { "-ARMOR", "XMOG" }, --Imperial Plate Belt
	[50451] = { "-ARMOR", "XMOG" }, --Belt of the Lonely Noble
	[25022] = { "-ARMOR", "XMOG" }, --Warlord's Iron-Girdle
	[24966] = { "-ARMOR", "XMOG" }, --Talonguard Girdle
	[14906] = { "-ARMOR", "XMOG" }, --Brutish Belt
	[37801] = { "-ARMOR", "XMOG" }, --Waistguard of the Risen Knight
	[106524] = { "-ARMOR", "XMOG" }, --Gul'rok Girdle
	[24942] = { "-ARMOR", "XMOG" }, --Bloodscale Belt
	[106689] = { "-ARMOR", "XMOG" }, --Ironfist Girdle
	[78888] = { "-ARMOR", "XMOG" }, --Waistguard of Bleeding Bone
	[10370] = { "-ARMOR", "XMOG" }, --Imbued Plate Girdle
	[13077] = { "-ARMOR", "XMOG" }, --Girdle of Uther
	[25006] = { "-ARMOR", "XMOG" }, --Conqueror's Girdle
	[8140] = { "-ARMOR", "XMOG" }, --Chromite Girdle
	[36395] = { "-ARMOR", "XMOG" }, --Necropolis Girdle
	[8315] = { "-ARMOR", "XMOG" }, --Alabaster Plate Girdle
	[24998] = { "-ARMOR", "XMOG" }, --Bloodfist Girdle
	[24926] = { "-ARMOR", "XMOG" }, --Ango'rosh Belt
	[24982] = { "-ARMOR", "XMOG" }, --Boulderfist Belt
	[8277] = { "-ARMOR", "XMOG" }, --Valorous Girdle
	[67067] = { "-ARMOR", "XMOG" }, --Belt of Guardianship
	[10243] = { "-ARMOR", "XMOG" }, --Heavy Lamellar Girdle
	[78887] = { "-ARMOR", "XMOG" }, --Girdle of Soulful Mending
	[87501] = { "-ARMOR", "XMOG" }, --Unbreakable Waistplate
	[106392] = { "-ARMOR", "XMOG" }, --Bladespire Girdle
	[25014] = { "-ARMOR", "XMOG" }, --Shattered Hand Belt
	[12406] = { "-ARMOR", "XMOG" }, --Thorium Belt
	[36371] = { "-ARMOR", "XMOG" }, --Kraken Girdle
	[87504] = { "-ARMOR", "XMOG" }, --Waistguard of Flaming Words
	[24950] = { "-ARMOR", "XMOG" }, --Bogslayer Belt
	[28498] = { "-ARMOR", "XMOG" }, --Ravenguard's Baldric
	[66980] = { "-ARMOR", "XMOG" }, --Girdle of Heated Deeds
	[106458] = { "-ARMOR", "XMOG" }, --Rockspine Girdle
	[36387] = { "-ARMOR", "XMOG" }, --Revenant Belt
	[87506] = { "-ARMOR", "XMOG" }, --Cheng's Irrepressible Girdle
	[37785] = { "-ARMOR", "XMOG" }, --Girdle of the Howling Berserker
	[24918] = { "-ARMOR", "XMOG" }, --Grimscale Belt
	[36379] = { "-ARMOR", "XMOG" }, --Golem Girdle
	[55555] = { "-ARMOR", "XMOG" }, --Fargodeep Girdle
	[82289] = { "-ARMOR", "XMOG" }, --Temple Girdle
	[67099] = { "-ARMOR", "XMOG" }, --Waistguard of New Days
	[82069] = { "-ARMOR", "XMOG" }, --Brick Girdle
	[94040] = { "-ARMOR", "XMOG" }, --Forgotten Peacekeeper Belt
	[24974] = { "-ARMOR", "XMOG" }, --Reaver Girdle
	[36291] = { "-ARMOR", "XMOG" }, --Westguard Belt
	[37790] = { "-ARMOR", "XMOG" }, --Belt of Crystalline Tears
	[31151] = { "-ARMOR", "XMOG" }, --Girdle of Siege
	[14914] = { "-ARMOR", "XMOG" }, --Jade Bracers
	[8137] = { "-ARMOR", "XMOG" }, --Chromite Bracers
	[14923] = { "-ARMOR", "XMOG" }, --Lofty Armguards
	[119331] = { "-ARMOR", "XMOG" }, --Bracers of Visceral Force
	[14869] = { "-ARMOR", "XMOG" }, --Warleader's Bracers
	[71993] = { "-ARMOR", "XMOG" }, --Titanguard Wristplates
	[14834] = { "-ARMOR", "XMOG" }, --Tyrant's Armguards
	[14983] = { "-ARMOR", "XMOG" }, --Exalted Armsplints
	[24925] = { "-ARMOR", "XMOG" }, --Grimscale Vambraces
	[114236] = { "-ARMOR", "XMOG" }, --Truesteel Armguards
	[14853] = { "-ARMOR", "XMOG" }, --Sunscale Wristguards
	[9285] = { "-ARMOR", "XMOG" }, --Field Plate Vambraces
	[10171] = { "-ARMOR", "XMOG" }, --Templar Bracers
	[10375] = { "-ARMOR", "XMOG" }, --Imbued Plate Vambraces
	[8273] = { "-ARMOR", "XMOG" }, --Valorous Wristguards
	[16861] = { "-ARMOR", "XMOG" }, --Bracers of Might
	[36977] = { "-ARMOR", "XMOG" }, --Bindings of the Construct
	[8156] = { "-ARMOR", "XMOG" }, --Jouster's Wristguards
	[14956] = { "-ARMOR", "XMOG" }, --Bloodforged Bindings
	[14941] = { "-ARMOR", "XMOG" }, --Warbringer's Armsplints
	[14965] = { "-ARMOR", "XMOG" }, --High Chief's Bindings
	[87521] = { "-ARMOR", "XMOG" }, --Zoid's Scorched Bracers
	[8311] = { "-ARMOR", "XMOG" }, --Alabaster Plate Vambraces
	[13076] = { "-ARMOR", "XMOG" }, --Giantslayer Bracers
	[10239] = { "-ARMOR", "XMOG" }, --Heavy Lamellar Vambraces
	[14910] = { "-ARMOR", "XMOG" }, --Brutish Armguards
	[24949] = { "-ARMOR", "XMOG" }, --Bloodscale Bracers
	[45680] = { "-ARMOR", "XMOG" }, --Armbands of the Construct
	[14903] = { "-ARMOR", "XMOG" }, --Saltstone Armsplints
	[76156] = { "-ARMOR", "XMOG" }, --Bindings of the End Times
	[106629] = { "-ARMOR", "XMOG" }, --Ravenskar Vambraces
	[106530] = { "-ARMOR", "XMOG" }, --Gul'rok Vambraces
	[50175] = { "-ARMOR", "XMOG" }, --Crypt Keeper's Bracers
	[106497] = { "-ARMOR", "XMOG" }, --Shardback Vambraces
	[106695] = { "-ARMOR", "XMOG" }, --Ironfist Vambraces
	[10127] = { "-ARMOR", "XMOG" }, --Revenant Bracers
	[66979] = { "-ARMOR", "XMOG" }, --Bracers of Bloody Business
	[94043] = { "-ARMOR", "XMOG" }, --Primordial Bloodsoaked Vambraces
	[25005] = { "-ARMOR", "XMOG" }, --Bloodfist Vambraces
	[24965] = { "-ARMOR", "XMOG" }, --Khan'aish Bracers
	[10094] = { "-ARMOR", "XMOG" }, --Gothic Plate Vambraces
	[94041] = { "-ARMOR", "XMOG" }, --Forgotten Peacekeeper Armguards
	[24981] = { "-ARMOR", "XMOG" }, --Reaver Bracers
	[36386] = { "-ARMOR", "XMOG" }, --Golem Vambraces
	[16857] = { "-ARMOR", "XMOG" }, --Lawbringer Bracers
	[106596] = { "-ARMOR", "XMOG" }, --Sharptusk Vambraces
	[25013] = { "-ARMOR", "XMOG" }, --Conqueror's Vambraces
	[67115] = { "-ARMOR", "XMOG" }, --Soulheart Bindings
	[36314] = { "-ARMOR", "XMOG" }, --Baleheim Vambraces
	[36394] = { "-ARMOR", "XMOG" }, --Revenant Bracers
	[82075] = { "-ARMOR", "XMOG" }, --Brick Vambraces
	[82240] = { "-ARMOR", "XMOG" }, --Highpeak Vambraces
	[12408] = { "-ARMOR", "XMOG" }, --Thorium Bracers
	[36306] = { "-ARMOR", "XMOG" }, --Coldrock Bracers
	[24957] = { "-ARMOR", "XMOG" }, --Bogslayer Bracers
	[55492] = { "-ARMOR", "XMOG" }, --Fargodeep Vambraces
	[87518] = { "-ARMOR", "XMOG" }, --Bracers of the Neux Dawn
	[106431] = { "-ARMOR", "XMOG" }, --Rimeplate Vambraces
	[36402] = { "-ARMOR", "XMOG" }, --Necropolis Vambraces
	[12425] = { "-ARMOR", "XMOG" }, --Imperial Plate Bracers
	[36378] = { "-ARMOR", "XMOG" }, --Kraken Vambraces
	[24973] = { "-ARMOR", "XMOG" }, --Talonguard Bracers
	[36298] = { "-ARMOR", "XMOG" }, --Westguard Bracers
	[10282] = { "-ARMOR", "XMOG" }, --Emerald Vambraces
	[24941] = { "-ARMOR", "XMOG" }, --Darkcrest Bracers
	[25029] = { "-ARMOR", "XMOG" }, --Warlord's Iron-Vambraces
	[24933] = { "-ARMOR", "XMOG" }, --Ango'rosh Vambraces
	[10328] = { "-ARMOR", "XMOG" }, --Scarlet Chestpiece
	[14744] = { "-ARMOR", "XMOG" }, --Hulking Chestguard
	[15640] = { "-ARMOR", "XMOG" }, --Ironhide Breastplate
	[15650] = { "-ARMOR", "XMOG" }, --Merciless Surcoat
	[6411] = { "-ARMOR", "XMOG" }, --Chief Brigadier Armor
	[29514] = { "-ARMOR", "XMOG" }, --Thick Netherscale Breastplate
	[14798] = { "-ARMOR", "XMOG" }, --Bloodlust Breastplate
	[25696] = { "-ARMOR", "XMOG" }, --Felstalker Breastplate
	[15524] = { "-ARMOR", "XMOG" }, --Sentry's Surcoat
	[15680] = { "-ARMOR", "XMOG" }, --Triumphant Chestpiece
	[15518] = { "-ARMOR", "XMOG" }, --Spiked Chain Breastplate
	[15514] = { "-ARMOR", "XMOG" }, --Grunt's Chestpiece
	[15622] = { "-ARMOR", "XMOG" }, --Gryphon Mail Breastplate
	[14789] = { "-ARMOR", "XMOG" }, --Protector Breastplate
	[20478] = { "-ARMOR", "XMOG" }, --Sandstalker Breastplate
	[15591] = { "-ARMOR", "XMOG" }, --Steadfast Breastplate
	[9765] = { "-ARMOR", "XMOG" }, --Cadet Vest
	[15669] = { "-ARMOR", "XMOG" }, --Magnificent Breastplate
	[15487] = { "-ARMOR", "XMOG" }, --War Torn Tunic
	[8265] = { "-ARMOR", "XMOG" }, --Ebonhold Armor
	[14751] = { "-ARMOR", "XMOG" }, --Slayer's Surcoat
	[85787] = { "-ARMOR", "XMOG" }, --Chestguard of Earthen Harmony
	[24864] = { "-ARMOR", "XMOG" }, --Blood Knight Breastplate
	[15631] = { "-ARMOR", "XMOG" }, --Formidable Chestpiece
	[8303] = { "-ARMOR", "XMOG" }, --Hero's Breastplate
	[15609] = { "-ARMOR", "XMOG" }, --Bonelink Armor
	[4074] = { "-ARMOR", "XMOG" }, --Mail Combat Armor
	[15578] = { "-ARMOR", "XMOG" }, --Sparkleshell Breastplate
	[15567] = { "-ARMOR", "XMOG" }, --Marauder's Tunic
	[15660] = { "-ARMOR", "XMOG" }, --Impenetrable Breastplate
	[14730] = { "-ARMOR", "XMOG" }, --War Paint Chestpiece
	[15500] = { "-ARMOR", "XMOG" }, --Outrunner's Chestguard
	[14811] = { "-ARMOR", "XMOG" }, --Warstrike Chestguard
	[85840] = { "-ARMOR", "XMOG" }, --Stormbreaker Chestguard
	[10230] = { "-ARMOR", "XMOG" }, --Engraved Breastplate
	[2965] = { "-ARMOR", "XMOG" }, --Warrior's Tunic
	[15546] = { "-ARMOR", "XMOG" }, --Thick Scale Breastplate
	[4071] = { "-ARMOR", "XMOG" }, --Glimmering Mail Breastplate
	[14779] = { "-ARMOR", "XMOG" }, --Khan's Chestpiece
	[9928] = { "-ARMOR", "XMOG" }, --Brigade Breastplate
	[3053] = { "-ARMOR", "XMOG" }, --Humbert's Chestpiece
	[15557] = { "-ARMOR", "XMOG" }, --Pillager's Chestguard
	[15536] = { "-ARMOR", "XMOG" }, --Wicked Chain Chestpiece
	[6180] = { "-ARMOR", "XMOG" }, --Slarkskin
	[14768] = { "-ARMOR", "XMOG" }, --Ravager's Armor
	[9866] = { "-ARMOR", "XMOG" }, --Renegade Chestguard
	[7538] = { "-ARMOR", "XMOG" }, --Champion's Armor
	[14760] = { "-ARMOR", "XMOG" }, --Enduring Breastplate
	[39507] = { "-ARMOR", "XMOG" }, --Darkmoon Chain Shirt
	[15601] = { "-ARMOR", "XMOG" }, --Ancient Chestpiece
	[7486] = { "-ARMOR", "XMOG" }, --Captain's Breastplate
	[3049] = { "-ARMOR", "XMOG" }, --Lambent Scale Breastplate
	[98899] = { "-ARMOR", "XMOG" }, --Crafted Malevolent Gladiator's Linked Armor
	[10077] = { "-ARMOR", "XMOG" }, --Lord's Breastplate
	[3306] = { "-ARMOR", "XMOG" }, --Brackwater Vest
	[116168] = { "-ARMOR", "XMOG" }, --Traveling Tunic
	[4448] = { "-ARMOR", "XMOG" }, --Husk of Naraxis
	[85844] = { "-ARMOR", "XMOG" }, --Stormscale Chestguard
	[106620] = { "-ARMOR", "XMOG" }, --Varashi Vest
	[24880] = { "-ARMOR", "XMOG" }, --Der'izu Chestpiece
	[10266] = { "-ARMOR", "XMOG" }, --Masterwork Breastplate
	[31256] = { "-ARMOR", "XMOG" }, --Silvermoon Armor
	[54784] = { "-ARMOR", "XMOG" }, --Burnished Tunic
	[50038] = { "-ARMOR", "XMOG" }, --Carapace of Forgotten Kings
	[106521] = { "-ARMOR", "XMOG" }, --Highland Vest
	[15479] = { "-ARMOR", "XMOG" }, --Charger's Armor
	[2273] = { "-ARMOR", "XMOG" }, --Guerrilla Armor
	[37780] = { "-ARMOR", "XMOG" }, --Condor-Bone Chestguard
	[10118] = { "-ARMOR", "XMOG" }, --Ornate Breastplate
	[94081] = { "-ARMOR", "XMOG" }, --Brittle Flamereaver Hauberk
	[9836] = { "-ARMOR", "XMOG" }, --Banded Armor
	[9818] = { "-ARMOR", "XMOG" }, --Fortified Chain
	[1715] = { "-ARMOR", "XMOG" }, --Polished Jazeraint Armor
	[24816] = { "-ARMOR", "XMOG" }, --Felstone Chain Vest
	[7418] = { "-ARMOR", "XMOG" }, --Phalanx Breastplate
	[10193] = { "-ARMOR", "XMOG" }, --Crusader's Armor
	[23490] = { "-ARMOR", "XMOG" }, --Fel Iron Chain Tunic
	[24840] = { "-ARMOR", "XMOG" }, --Wrathfin Armor
	[6580] = { "-ARMOR", "XMOG" }, --Defender Tunic
	[7454] = { "-ARMOR", "XMOG" }, --Knight's Breastplate
	[6195] = { "-ARMOR", "XMOG" }, --Wax-Polished Armor
	[106587] = { "-ARMOR", "XMOG" }, --Deathweb Vest
	[8126] = { "-ARMOR", "XMOG" }, --Myrmidon's Breastplate
	[24872] = { "-ARMOR", "XMOG" }, --Ironspine Chain Vest
	[94052] = { "-ARMOR", "XMOG" }, --Battered Saurscale Chestpiece
	[82248] = { "-ARMOR", "XMOG" }, --Yak Vest
	[9957] = { "-ARMOR", "XMOG" }, --Warmonger's Chestpiece
	[24808] = { "-ARMOR", "XMOG" }, --Unyielding Chain Vest
	[36189] = { "-ARMOR", "XMOG" }, --Njord Chain Vest
	[36181] = { "-ARMOR", "XMOG" }, --Garmaul Chestpiece
	[106455] = { "-ARMOR", "XMOG" }, --Gronnling Vest
	[3471] = { "-ARMOR", "XMOG" }, --Copper Chain Vest
	[81988] = { "-ARMOR", "XMOG" }, --Saurok Vest
	[24848] = { "-ARMOR", "XMOG" }, --Fenclaw Armor
	[36261] = { "-ARMOR", "XMOG" }, --Cormorant Chain Vest
	[55572] = { "-ARMOR", "XMOG" }, --Bramblescar Vest
	[24888] = { "-ARMOR", "XMOG" }, --Skettis Chestpiece
	[6336] = { "-ARMOR", "XMOG" }, --Infantry Tunic
	[120950] = { "-ARMOR", "XMOG" }, --Battle Chain Vest
	[5755] = { "-ARMOR", "XMOG" }, --Onyx Shredder Plate
	[24856] = { "-ARMOR", "XMOG" }, --Marshcreeper Fen-Vest
	[94261] = { "-ARMOR", "XMOG" }, --Deathbog Hauberk
	[13123] = { "-ARMOR", "XMOG" }, --Dreamwalker Armor
	[24904] = { "-ARMOR", "XMOG" }, --Talhide Chestpiece
	[24896] = { "-ARMOR", "XMOG" }, --Sundered Chestpiece
	[31127] = { "-ARMOR", "XMOG" }, --Hauberk of Totemic Rage
	[2977] = { "-ARMOR", "XMOG" }, --Veteran Armor
	[6545] = { "-ARMOR", "XMOG" }, --Soldier's Armor
	[31286] = { "-ARMOR", "XMOG" }, --Breastplate of Rapid Striking
	[119339] = { "-ARMOR", "XMOG" }, --Treads of the Veteran Smith
	[15525] = { "-ARMOR", "XMOG" }, --Sentry's Slippers
	[116193] = { "-ARMOR", "XMOG" }, --Wayfaring Boots
	[15544] = { "-ARMOR", "XMOG" }, --Thick Scale Sabatons
	[14794] = { "-ARMOR", "XMOG" }, --Protector Ankleguards
	[15658] = { "-ARMOR", "XMOG" }, --Impenetrable Sabatons
	[45562] = { "-ARMOR", "XMOG" }, --Boots of Living Scale
	[15516] = { "-ARMOR", "XMOG" }, --Spiked Chain Slippers
	[8269] = { "-ARMOR", "XMOG" }, --Ebonhold Boots
	[7490] = { "-ARMOR", "XMOG" }, --Captain's Boots
	[15589] = { "-ARMOR", "XMOG" }, --Steadfast Stompers
	[4076] = { "-ARMOR", "XMOG" }, --Mail Combat Boots
	[45563] = { "-ARMOR", "XMOG" }, --Lightning Grounded Boots
	[87695] = { "-ARMOR", "XMOG" }, --Treads of Edward the Odd
	[15694] = { "-ARMOR", "XMOG" }, --Merciless Greaves
	[15678] = { "-ARMOR", "XMOG" }, --Triumphant Sabatons
	[15576] = { "-ARMOR", "XMOG" }, --Sparkleshell Sabatons
	[15555] = { "-ARMOR", "XMOG" }, --Pillager's Boots
	[15506] = { "-ARMOR", "XMOG" }, --Grunt's Ankle Wraps
	[15498] = { "-ARMOR", "XMOG" }, --Outrunner's Slippers
	[6412] = { "-ARMOR", "XMOG" }, --Chief Brigadier Boots
	[14769] = { "-ARMOR", "XMOG" }, --Ravager's Sandals
	[14809] = { "-ARMOR", "XMOG" }, --Warstrike Sabatons
	[15630] = { "-ARMOR", "XMOG" }, --Formidable Sabatons
	[15674] = { "-ARMOR", "XMOG" }, --Magnificent Greaves
	[10155] = { "-ARMOR", "XMOG" }, --Mercurial Greaves
	[68761] = { "-ARMOR", "XMOG" }, --Imbued Infantry Boots
	[37744] = { "-ARMOR", "XMOG" }, --Horrorblood Treads
	[9864] = { "-ARMOR", "XMOG" }, --Renegade Boots
	[14742] = { "-ARMOR", "XMOG" }, --Hulking Boots
	[14722] = { "-ARMOR", "XMOG" }, --War Paint Anklewraps
	[118834] = { "-ARMOR", "XMOG" }, --Spiffy Chainmail Boots
	[9926] = { "-ARMOR", "XMOG" }, --Brigade Boots
	[15626] = { "-ARMOR", "XMOG" }, --Gryphon Mail Greaves
	[9962] = { "-ARMOR", "XMOG" }, --Warmonger's Greaves
	[15599] = { "-ARMOR", "XMOG" }, --Ancient Greaves
	[12982] = { "-ARMOR", "XMOG" }, --Silver-Linked Footguards
	[24839] = { "-ARMOR", "XMOG" }, --Wrathfin Greaves
	[14762] = { "-ARMOR", "XMOG" }, --Enduring Boots
	[7417] = { "-ARMOR", "XMOG" }, --Phalanx Boots
	[94078] = { "-ARMOR", "XMOG" }, --Brittle Flamereaver Treads
	[8307] = { "-ARMOR", "XMOG" }, --Hero's Boots
	[2991] = { "-ARMOR", "XMOG" }, --Burnished Boots
	[71027] = { "-ARMOR", "XMOG" }, --Treads of Implicit Obedience
	[4073] = { "-ARMOR", "XMOG" }, --Glimmering Mail Greaves
	[10192] = { "-ARMOR", "XMOG" }, --Crusader's Boots
	[85842] = { "-ARMOR", "XMOG" }, --Stormscale Boots
	[15489] = { "-ARMOR", "XMOG" }, --Bloodspattered Sabatons
	[6573] = { "-ARMOR", "XMOG" }, --Defender Boots
	[10234] = { "-ARMOR", "XMOG" }, --Engraved Boots
	[106616] = { "-ARMOR", "XMOG" }, --Varashi Greaves
	[7542] = { "-ARMOR", "XMOG" }, --Champion's Greaves
	[94216] = { "-ARMOR", "XMOG" }, --Lifestep Treads
	[7458] = { "-ARMOR", "XMOG" }, --Knight's Boots
	[13125] = { "-ARMOR", "XMOG" }, --Elven Chain Boots
	[15565] = { "-ARMOR", "XMOG" }, --Marauder's Boots
	[8130] = { "-ARMOR", "XMOG" }, --Myrmidon's Greaves
	[24807] = { "-ARMOR", "XMOG" }, --Unyielding Footwraps
	[24863] = { "-ARMOR", "XMOG" }, --Blood Knight Boots
	[24823] = { "-ARMOR", "XMOG" }, --Netherstalker Greaves
	[106550] = { "-ARMOR", "XMOG" }, --Warpscale Greaves
	[24903] = { "-ARMOR", "XMOG" }, --Talhide Lined-Boots
	[36196] = { "-ARMOR", "XMOG" }, --Skom Greaves
	[4464] = { "-ARMOR", "XMOG" }, --Trouncing Boots
	[94057] = { "-ARMOR", "XMOG" }, --Battered Saurscale Boots
	[12419] = { "-ARMOR", "XMOG" }, --Radiant Boots
	[106715] = { "-ARMOR", "XMOG" }, --Sunspring Greaves
	[9784] = { "-ARMOR", "XMOG" }, --Raider's Boots
	[24911] = { "-ARMOR", "XMOG" }, --Netherstorm Greaves
	[106649] = { "-ARMOR", "XMOG" }, --Spirestrider Greaves
	[9810] = { "-ARMOR", "XMOG" }, --Fortified Boots
	[81987] = { "-ARMOR", "XMOG" }, --Saurok Greaves
	[24879] = { "-ARMOR", "XMOG" }, --Der'izu Greaves
	[106484] = { "-ARMOR", "XMOG" }, --Tangleheart Greaves
	[6551] = { "-ARMOR", "XMOG" }, --Soldier's Boots
	[66963] = { "-ARMOR", "XMOG" }, --Treads of the Wyrmhunter
	[31187] = { "-ARMOR", "XMOG" }, --Boots of the Pathfinder
	[82244] = { "-ARMOR", "XMOG" }, --Yak Greaves
	[24815] = { "-ARMOR", "XMOG" }, --Felstone Greaves
	[31173] = { "-ARMOR", "XMOG" }, --Boots of Savagery
	[6350] = { "-ARMOR", "XMOG" }, --Rough Bronze Boots
	[24895] = { "-ARMOR", "XMOG" }, --Sundered Footwraps
	[55584] = { "-ARMOR", "XMOG" }, --Thornsnarl Greaves
	[36204] = { "-ARMOR", "XMOG" }, --Nifflevar Boots
	[36284] = { "-ARMOR", "XMOG" }, --Spectral Greaves
	[25659] = { "-ARMOR", "XMOG" }, --Scaled Draenic Boots
	[10082] = { "-ARMOR", "XMOG" }, --Lord's Boots
	[24847] = { "-ARMOR", "XMOG" }, --Fenclaw Footwraps
	[24871] = { "-ARMOR", "XMOG" }, --Ironspine Greaves
	[113593] = { "-ARMOR", "XMOG" }, --Grips of Vicious Mauling
	[16672] = { "-ARMOR", "XMOG" }, --Gauntlets of Elements
	[23531] = { "-ARMOR", "XMOG" }, --Felfury Gauntlets
	[14792] = { "-ARMOR", "XMOG" }, --Protector Gauntlets
	[7917] = { "-ARMOR", "XMOG" }, --Barbaric Iron Gloves
	[20296] = { "-ARMOR", "XMOG" }, --Green Dragonscale Gauntlets
	[1448] = { "-ARMOR", "XMOG" }, --Blackrock Gauntlets
	[116190] = { "-ARMOR", "XMOG" }, --Wayfaring Gloves
	[15595] = { "-ARMOR", "XMOG" }, --Steadfast Gloves
	[14802] = { "-ARMOR", "XMOG" }, --Bloodlust Gauntlets
	[15548] = { "-ARMOR", "XMOG" }, --Thick Scale Gauntlets
	[15581] = { "-ARMOR", "XMOG" }, --Sparkleshell Gauntlets
	[20480] = { "-ARMOR", "XMOG" }, --Spitfire Gauntlets
	[85821] = { "-ARMOR", "XMOG" }, --Fists of Lightning
	[10121] = { "-ARMOR", "XMOG" }, --Ornate Gauntlets
	[12418] = { "-ARMOR", "XMOG" }, --Radiant Gloves
	[85822] = { "-ARMOR", "XMOG" }, --Gloves of Earthen Harmony
	[15570] = { "-ARMOR", "XMOG" }, --Marauder's Gauntlets
	[10268] = { "-ARMOR", "XMOG" }, --Masterwork Gauntlets
	[7541] = { "-ARMOR", "XMOG" }, --Champion's Gauntlets
	[15682] = { "-ARMOR", "XMOG" }, --Triumphant Gauntlets
	[1988] = { "-ARMOR", "XMOG" }, --Chief Brigadier Gauntlets
	[8267] = { "-ARMOR", "XMOG" }, --Ebonhold Gauntlets
	[12994] = { "-ARMOR", "XMOG" }, --Thorbia's Gauntlets
	[4072] = { "-ARMOR", "XMOG" }, --Glimmering Mail Gauntlets
	[15605] = { "-ARMOR", "XMOG" }, --Ancient Gauntlets
	[15612] = { "-ARMOR", "XMOG" }, --Bonelink Gauntlets
	[14747] = { "-ARMOR", "XMOG" }, --Hulking Gauntlets
	[15625] = { "-ARMOR", "XMOG" }, --Gryphon Mail Gauntlets
	[93585] = { "-ARMOR", "XMOG" }, --Crafted Dreadful Gladiator's Linked Gauntlets
	[8305] = { "-ARMOR", "XMOG" }, --Hero's Gauntlets
	[15509] = { "-ARMOR", "XMOG" }, --Grunt's Handwraps
	[9960] = { "-ARMOR", "XMOG" }, --Warmonger's Gauntlets
	[14726] = { "-ARMOR", "XMOG" }, --War Paint Gloves
	[3341] = { "-ARMOR", "XMOG" }, --Gauntlets of Ogre Strength
	[4075] = { "-ARMOR", "XMOG" }, --Mail Combat Gauntlets
	[9930] = { "-ARMOR", "XMOG" }, --Brigade Gauntlets
	[7489] = { "-ARMOR", "XMOG" }, --Captain's Gauntlets
	[15491] = { "-ARMOR", "XMOG" }, --Bloodspattered Gloves
	[7421] = { "-ARMOR", "XMOG" }, --Phalanx Gauntlets
	[2980] = { "-ARMOR", "XMOG" }, --Veteran Gloves
	[31280] = { "-ARMOR", "XMOG" }, --Thundercaller's Gauntlets
	[15672] = { "-ARMOR", "XMOG" }, --Magnificent Gauntlets
	[2992] = { "-ARMOR", "XMOG" }, --Burnished Gloves
	[15635] = { "-ARMOR", "XMOG" }, --Formidable Gauntlets
	[85845] = { "-ARMOR", "XMOG" }, --Stormscale Gloves
	[14551] = { "-ARMOR", "XMOG" }, --Edgemaster's Handguards
	[10161] = { "-ARMOR", "XMOG" }, --Mercurial Gauntlets
	[15538] = { "-ARMOR", "XMOG" }, --Wicked Chain Gauntlets
	[14772] = { "-ARMOR", "XMOG" }, --Ravager's Handwraps
	[10331] = { "-ARMOR", "XMOG" }, --Scarlet Gauntlets
	[118835] = { "-ARMOR", "XMOG" }, --Kiraser's Gloves of Precision
	[24833] = { "-ARMOR", "XMOG" }, --Nexus-Strider Gloves
	[39194] = { "-ARMOR", "XMOG" }, --Rusted-Link Spiked Gauntlets
	[15502] = { "-ARMOR", "XMOG" }, --Outrunner's Gloves
	[6577] = { "-ARMOR", "XMOG" }, --Defender Gauntlets
	[24873] = { "-ARMOR", "XMOG" }, --Ironspine Gloves
	[24809] = { "-ARMOR", "XMOG" }, --Unyielding Fists
	[94083] = { "-ARMOR", "XMOG" }, --Brittle Flamereaver Gloves
	[24897] = { "-ARMOR", "XMOG" }, --Sundered Gauntlets
	[3047] = { "-ARMOR", "XMOG" }, --Lambent Scale Gloves
	[10080] = { "-ARMOR", "XMOG" }, --Lord's Gauntlets
	[7457] = { "-ARMOR", "XMOG" }, --Knight's Gauntlets
	[6547] = { "-ARMOR", "XMOG" }, --Soldier's Gauntlets
	[24841] = { "-ARMOR", "XMOG" }, --Wrathfin Gloves
	[40302] = { "-ARMOR", "XMOG" }, --Benefactor's Gauntlets
	[4465] = { "-ARMOR", "XMOG" }, --Felstrom's Gauntlets
	[67105] = { "-ARMOR", "XMOG" }, --Elementbinder Grips
	[17007] = { "-ARMOR", "XMOG" }, --Stonerender Gauntlets
	[87448] = { "-ARMOR", "XMOG" }, --Toremu's Crackling Grips
	[9900] = { "-ARMOR", "XMOG" }, --Jazeraint Gauntlets
	[3472] = { "-ARMOR", "XMOG" }, --Runed Copper Gauntlets
	[6595] = { "-ARMOR", "XMOG" }, --Battleforge Gauntlets
	[94054] = { "-ARMOR", "XMOG" }, --Battered Saurscale Gloves
	[106681] = { "-ARMOR", "XMOG" }, --Snarlthorn Gauntlets
	[106483] = { "-ARMOR", "XMOG" }, --Tangleheart Gauntlets
	[81986] = { "-ARMOR", "XMOG" }, --Saurok Gauntlets
	[36198] = { "-ARMOR", "XMOG" }, --Skom Gloves
	[106648] = { "-ARMOR", "XMOG" }, --Spirestrider Gauntlets
	[106615] = { "-ARMOR", "XMOG" }, --Varashi Gauntlets
	[9435] = { "-ARMOR", "XMOG" }, --Reticulated Bone Gauntlets
	[106582] = { "-ARMOR", "XMOG" }, --Deathweb Gauntlets
	[55587] = { "-ARMOR", "XMOG" }, --Nazferiti Gauntlets
	[36270] = { "-ARMOR", "XMOG" }, --Ulduar Gauntlets
	[82243] = { "-ARMOR", "XMOG" }, --Yak Gauntlets
	[24905] = { "-ARMOR", "XMOG" }, --Talhide Lined-Gloves
	[36190] = { "-ARMOR", "XMOG" }, --Njord Gauntlets
	[24889] = { "-ARMOR", "XMOG" }, --Skettis Gauntlets
	[10232] = { "-ARMOR", "XMOG" }, --Engraved Gauntlets
	[37781] = { "-ARMOR", "XMOG" }, --Grips of the Warming Heart
	[9787] = { "-ARMOR", "XMOG" }, --Raider's Gauntlets
	[25683] = { "-ARMOR", "XMOG" }, --Stylin' Crimson Hat
	[118895] = { "-ARMOR", "XMOG" }, --Plume Adorned Headdress
	[116188] = { "-ARMOR", "XMOG" }, --Wayfaring Helm
	[14804] = { "-ARMOR", "XMOG" }, --Bloodlust Helm
	[14774] = { "-ARMOR", "XMOG" }, --Ravager's Crown
	[15623] = { "-ARMOR", "XMOG" }, --Gryphon Mail Crown
	[15558] = { "-ARMOR", "XMOG" }, --Pillager's Crown
	[14753] = { "-ARMOR", "XMOG" }, --Slayer's Skullcap
	[15645] = { "-ARMOR", "XMOG" }, --Ironhide Helmet
	[15593] = { "-ARMOR", "XMOG" }, --Steadfast Coronet
	[8270] = { "-ARMOR", "XMOG" }, --Ebonhold Helmet
	[109173] = { "-ARMOR", "XMOG" }, --Cybergenetic Mechshades
	[14765] = { "-ARMOR", "XMOG" }, --Enduring Circlet
	[9963] = { "-ARMOR", "XMOG" }, --Warmonger's Circlet
	[6389] = { "-ARMOR", "XMOG" }, --Glimmering Mail Coif
	[14814] = { "-ARMOR", "XMOG" }, --Warstrike Helmet
	[106551] = { "-ARMOR", "XMOG" }, --Warpscale Helm
	[10272] = { "-ARMOR", "XMOG" }, --Masterwork Circlet
	[10408] = { "-ARMOR", "XMOG" }, --Banded Helm
	[15664] = { "-ARMOR", "XMOG" }, --Impenetrable Helmet
	[85846] = { "-ARMOR", "XMOG" }, --Stormscale Helm
	[24858] = { "-ARMOR", "XMOG" }, --Marshcreeper Helm
	[106749] = { "-ARMOR", "XMOG" }, --Packrunner Helm
	[10160] = { "-ARMOR", "XMOG" }, --Mercurial Circlet
	[4077] = { "-ARMOR", "XMOG" }, --Mail Combat Headguard
	[15670] = { "-ARMOR", "XMOG" }, --Magnificent Helmet
	[98901] = { "-ARMOR", "XMOG" }, --Crafted Malevolent Gladiator's Linked Helm
	[21804] = { "-ARMOR", "XMOG" }, --Coif of Elemental Fury
	[93592] = { "-ARMOR", "XMOG" }, --Crafted Dreadful Gladiator's Mail Helm
	[7420] = { "-ARMOR", "XMOG" }, --Phalanx Headguard
	[10235] = { "-ARMOR", "XMOG" }, --Engraved Helm
	[10198] = { "-ARMOR", "XMOG" }, --Crusader's Helm
	[9932] = { "-ARMOR", "XMOG" }, --Brigade Circlet
	[94077] = { "-ARMOR", "XMOG" }, --Brittle Flamereaver Mask
	[15602] = { "-ARMOR", "XMOG" }, --Ancient Crown
	[24874] = { "-ARMOR", "XMOG" }, --Ironspine Helm
	[7488] = { "-ARMOR", "XMOG" }, --Captain's Circlet
	[8308] = { "-ARMOR", "XMOG" }, --Hero's Band
	[10123] = { "-ARMOR", "XMOG" }, --Ornate Circlet
	[24818] = { "-ARMOR", "XMOG" }, --Felstone Helm
	[106650] = { "-ARMOR", "XMOG" }, --Spirestrider Helm
	[9902] = { "-ARMOR", "XMOG" }, --Jazeraint Helm
	[31222] = { "-ARMOR", "XMOG" }, --Headdress of Inner Rage
	[8131] = { "-ARMOR", "XMOG" }, --Myrmidon's Helm
	[24882] = { "-ARMOR", "XMOG" }, --Der'izu Helm
	[2245] = { "-ARMOR", "XMOG" }, --Helm of Narv
	[116167] = { "-ARMOR", "XMOG" }, --Traveling Helm
	[24826] = { "-ARMOR", "XMOG" }, --Netherstalker Helmet
	[24866] = { "-ARMOR", "XMOG" }, --Blood Knight Helm
	[37857] = { "-ARMOR", "XMOG" }, --Helm of the Lightning Halls
	[8208] = { "-ARMOR", "XMOG" }, --Tough Scorpid Helm
	[13127] = { "-ARMOR", "XMOG" }, --Frostreaver Crown
	[36239] = { "-ARMOR", "XMOG" }, --Shoveltusk Helmet
	[13128] = { "-ARMOR", "XMOG" }, --High Bergg Helm
	[31330] = { "-ARMOR", "XMOG" }, --Lightning Crown
	[10083] = { "-ARMOR", "XMOG" }, --Lord's Crown
	[106716] = { "-ARMOR", "XMOG" }, --Sunspring Helm
	[24898] = { "-ARMOR", "XMOG" }, --Sundered Helmet
	[87456] = { "-ARMOR", "XMOG" }, --Hexu's Amplifying Helm
	[7456] = { "-ARMOR", "XMOG" }, --Knight's Headguard
	[66955] = { "-ARMOR", "XMOG" }, --Scentsniffer Hood
	[7540] = { "-ARMOR", "XMOG" }, --Champion's Helmet
	[106485] = { "-ARMOR", "XMOG" }, --Tangleheart Helm
	[24810] = { "-ARMOR", "XMOG" }, --Unyielding Helm
	[24906] = { "-ARMOR", "XMOG" }, --Talhide Helmet
	[55604] = { "-ARMOR", "XMOG" }, --Frayfeather Helm
	[82245] = { "-ARMOR", "XMOG" }, --Yak Helm
	[14785] = { "-ARMOR", "XMOG" }, --Khan's Helmet
	[81985] = { "-ARMOR", "XMOG" }, --Saurok Helm
	[67123] = { "-ARMOR", "XMOG" }, --Sinman's Helm of Succor
	[37775] = { "-ARMOR", "XMOG" }, --Helm of the Broken Ram
	[36271] = { "-ARMOR", "XMOG" }, --Ulduar Helm
	[36183] = { "-ARMOR", "XMOG" }, --Garmaul Helmet
	[7931] = { "-ARMOR", "XMOG" }, --Mithril Coif
	[15655] = { "-ARMOR", "XMOG" }, --Merciless Legguards
	[14805] = { "-ARMOR", "XMOG" }, --Bloodlust Britches
	[15596] = { "-ARMOR", "XMOG" }, --Steadfast Legplates
	[15646] = { "-ARMOR", "XMOG" }, --Ironhide Legguards
	[15521] = { "-ARMOR", "XMOG" }, --Spiked Chain Leggings
	[3282] = { "-ARMOR", "XMOG" }, --Battle Chain Pants
	[116189] = { "-ARMOR", "XMOG" }, --Wayfaring Leggings
	[15627] = { "-ARMOR", "XMOG" }, --Gryphon Mail Legguards
	[14748] = { "-ARMOR", "XMOG" }, --Hulking Leggings
	[24851] = { "-ARMOR", "XMOG" }, --Fenclaw Legguards
	[15665] = { "-ARMOR", "XMOG" }, --Impenetrable Legguards
	[6402] = { "-ARMOR", "XMOG" }, --Mail Combat Leggings
	[15637] = { "-ARMOR", "XMOG" }, --Formidable Legguards
	[4079] = { "-ARMOR", "XMOG" }, --Chief Brigadier Leggings
	[12420] = { "-ARMOR", "XMOG" }, --Radiant Leggings
	[14757] = { "-ARMOR", "XMOG" }, --Slayer's Pants
	[15511] = { "-ARMOR", "XMOG" }, --Grunt's Legguards
	[93497] = { "-ARMOR", "XMOG" }, --Crafted Dreadful Gladiator's Chain Leggings
	[15582] = { "-ARMOR", "XMOG" }, --Sparkleshell Legguards
	[15503] = { "-ARMOR", "XMOG" }, --Outrunner's Legguards
	[6386] = { "-ARMOR", "XMOG" }, --Glimmering Mail Legguards
	[13129] = { "-ARMOR", "XMOG" }, --Firemane Leggings
	[3048] = { "-ARMOR", "XMOG" }, --Lambent Scale Legguards
	[14775] = { "-ARMOR", "XMOG" }, --Ravager's Woolies
	[15616] = { "-ARMOR", "XMOG" }, --Bonelink Legplates
	[9396] = { "-ARMOR", "XMOG" }, --Legguards of the Vault
	[10162] = { "-ARMOR", "XMOG" }, --Mercurial Legguards
	[7487] = { "-ARMOR", "XMOG" }, --Captain's Leggings
	[15493] = { "-ARMOR", "XMOG" }, --Bloodspattered Loincloth
	[7539] = { "-ARMOR", "XMOG" }, --Champion's Leggings
	[7423] = { "-ARMOR", "XMOG" }, --Phalanx Leggings
	[94082] = { "-ARMOR", "XMOG" }, --Brittle Flamereaver Leggings
	[24835] = { "-ARMOR", "XMOG" }, --Nexus-Strider Legwraps
	[24867] = { "-ARMOR", "XMOG" }, --Blood Knight Greaves
	[15685] = { "-ARMOR", "XMOG" }, --Triumphant Legplates
	[6596] = { "-ARMOR", "XMOG" }, --Battleforge Legguards
	[14727] = { "-ARMOR", "XMOG" }, --War Paint Legguards
	[85847] = { "-ARMOR", "XMOG" }, --Stormscale Leggings
	[15551] = { "-ARMOR", "XMOG" }, --Thick Scale Legguards
	[98902] = { "-ARMOR", "XMOG" }, --Crafted Malevolent Gladiator's Linked Leggings
	[15573] = { "-ARMOR", "XMOG" }, --Marauder's Leggings
	[7455] = { "-ARMOR", "XMOG" }, --Knight's Legguards
	[45504] = { "-ARMOR", "XMOG" }, --Darkcore Leggings
	[14786] = { "-ARMOR", "XMOG" }, --Khan's Legguards
	[118837] = { "-ARMOR", "XMOG" }, --Puu'sey's Pantaloons
	[15607] = { "-ARMOR", "XMOG" }, --Ancient Legguards
	[15676] = { "-ARMOR", "XMOG" }, --Magnificent Leggings
	[8132] = { "-ARMOR", "XMOG" }, --Myrmidon's Leggings
	[10124] = { "-ARMOR", "XMOG" }, --Ornate Legguards
	[10273] = { "-ARMOR", "XMOG" }, --Masterwork Legplates
	[15561] = { "-ARMOR", "XMOG" }, --Pillager's Leggings
	[14816] = { "-ARMOR", "XMOG" }, --Warstrike Legguards
	[67150] = { "-ARMOR", "XMOG" }, --Arrowsinger Legguards
	[31572] = { "-ARMOR", "XMOG" }, --Mistshroud Pants
	[94053] = { "-ARMOR", "XMOG" }, --Battered Saurscale Leggings
	[31328] = { "-ARMOR", "XMOG" }, --Leggings of Beast Mastery
	[3842] = { "-ARMOR", "XMOG" }, --Green Iron Leggings
	[10084] = { "-ARMOR", "XMOG" }, --Lord's Legguards
	[24875] = { "-ARMOR", "XMOG" }, --Ironspine Legguards
	[106519] = { "-ARMOR", "XMOG" }, --Highland Legguards
	[10236] = { "-ARMOR", "XMOG" }, --Engraved Leggings
	[3305] = { "-ARMOR", "XMOG" }, --Brackwater Leggings
	[24827] = { "-ARMOR", "XMOG" }, --Netherstalker Legguards
	[4478] = { "-ARMOR", "XMOG" }, --Iridescent Scale Leggings
	[24883] = { "-ARMOR", "XMOG" }, --Der'izu Legguards
	[10199] = { "-ARMOR", "XMOG" }, --Crusader's Leggings
	[6578] = { "-ARMOR", "XMOG" }, --Defender Leggings
	[24843] = { "-ARMOR", "XMOG" }, --Wrathfin Legguards
	[24907] = { "-ARMOR", "XMOG" }, --Talhide Lined-Leggings
	[87459] = { "-ARMOR", "XMOG" }, --Dills' Primal Leggings
	[56508] = { "-ARMOR", "XMOG" }, --Tsunami Leggings
	[24891] = { "-ARMOR", "XMOG" }, --Skettis Legguards
	[14766] = { "-ARMOR", "XMOG" }, --Enduring Breeches
	[50450] = { "-ARMOR", "XMOG" }, --Leggings of Dubious Charms
	[9841] = { "-ARMOR", "XMOG" }, --Banded Leggings
	[3473] = { "-ARMOR", "XMOG" }, --Runed Copper Pants
	[9964] = { "-ARMOR", "XMOG" }, --Warmonger's Leggings
	[60201] = { "-ARMOR", "XMOG" }, --Phase-Twister Leggings
	[87464] = { "-ARMOR", "XMOG" }, --Leggings of the Scorched Man
	[2990] = { "-ARMOR", "XMOG" }, --Burnished Leggings
	[8206] = { "-ARMOR", "XMOG" }, --Tough Scorpid Leggings
	[13010] = { "-ARMOR", "XMOG" }, --Dreamsinger Legguards
	[106717] = { "-ARMOR", "XMOG" }, --Sunspring Legguards
	[82081] = { "-ARMOR", "XMOG" }, --Snake Legguards
	[67102] = { "-ARMOR", "XMOG" }, --Kilt of Elemental Mending
	[15477] = { "-ARMOR", "XMOG" }, --Charger's Pants
	[6337] = { "-ARMOR", "XMOG" }, --Infantry Leggings
	[82246] = { "-ARMOR", "XMOG" }, --Yak Legguards
	[9815] = { "-ARMOR", "XMOG" }, --Fortified Leggings
	[15485] = { "-ARMOR", "XMOG" }, --War Torn Pants
	[36240] = { "-ARMOR", "XMOG" }, --Shoveltusk Legguards
	[7920] = { "-ARMOR", "XMOG" }, --Mithril Scale Pants
	[37774] = { "-ARMOR", "XMOG" }, --Leggings of Aqueous Dissolution
	[24819] = { "-ARMOR", "XMOG" }, --Felstone Leggings
	[13130] = { "-ARMOR", "XMOG" }, --Windrunner Legguards
	[55610] = { "-ARMOR", "XMOG" }, --Highperch Legguards
	[9789] = { "-ARMOR", "XMOG" }, --Raider's Legguards
	[66971] = { "-ARMOR", "XMOG" }, --Highland Padded Leggings
	[36272] = { "-ARMOR", "XMOG" }, --Ulduar Legguards
	[24899] = { "-ARMOR", "XMOG" }, --Sundered Legguards
	[36200] = { "-ARMOR", "XMOG" }, --Skom Leggings
	[9763] = { "-ARMOR", "XMOG" }, --Cadet Leggings
	[31240] = { "-ARMOR", "XMOG" }, --Scales of the Beast
	[24811] = { "-ARMOR", "XMOG" }, --Unyielding Leggings
	[15647] = { "-ARMOR", "XMOG" }, --Ironhide Pauldrons
	[15597] = { "-ARMOR", "XMOG" }, --Steadfast Shoulders
	[15513] = { "-ARMOR", "XMOG" }, --Grunt's Pauldrons
	[14797] = { "-ARMOR", "XMOG" }, --Protector Pads
	[116187] = { "-ARMOR", "XMOG" }, --Wayfaring Shoulderguards
	[6404] = { "-ARMOR", "XMOG" }, --Mail Combat Spaulders
	[15666] = { "-ARMOR", "XMOG" }, --Impenetrable Pauldrons
	[15638] = { "-ARMOR", "XMOG" }, --Formidable Shoulder Pads
	[15628] = { "-ARMOR", "XMOG" }, --Gryphon Mail Pauldrons
	[15583] = { "-ARMOR", "XMOG" }, --Sparkleshell Shoulder Pads
	[3841] = { "-ARMOR", "XMOG" }, --Golden Scale Shoulders
	[14767] = { "-ARMOR", "XMOG" }, --Enduring Pauldrons
	[7491] = { "-ARMOR", "XMOG" }, --Captain's Shoulderguards
	[15656] = { "-ARMOR", "XMOG" }, --Merciless Epaulets
	[15686] = { "-ARMOR", "XMOG" }, --Triumphant Shoulder Pads
	[4725] = { "-ARMOR", "XMOG" }, --Chief Brigadier Pauldrons
	[3231] = { "-ARMOR", "XMOG" }, --Cutthroat Pauldrons
	[6388] = { "-ARMOR", "XMOG" }, --Glimmering Mail Pauldrons
	[9904] = { "-ARMOR", "XMOG" }, --Jazeraint Pauldrons
	[4733] = { "-ARMOR", "XMOG" }, --Blackforge Pauldrons
	[7459] = { "-ARMOR", "XMOG" }, --Knight's Pauldrons
	[15677] = { "-ARMOR", "XMOG" }, --Magnificent Shoulders
	[13132] = { "-ARMOR", "XMOG" }, --Skeletal Shoulders
	[9872] = { "-ARMOR", "XMOG" }, --Renegade Pauldrons
	[9817] = { "-ARMOR", "XMOG" }, --Fortified Spaulders
	[24836] = { "-ARMOR", "XMOG" }, --Nexus-Strider Mantle
	[24860] = { "-ARMOR", "XMOG" }, --Marshcreeper Mantle
	[4705] = { "-ARMOR", "XMOG" }, --Lambent Scale Pauldrons
	[94080] = { "-ARMOR", "XMOG" }, --Brittle Flamereaver Pauldrons
	[15553] = { "-ARMOR", "XMOG" }, --Thick Scale Shoulder Pads
	[14817] = { "-ARMOR", "XMOG" }, --Warstrike Shoulder Pads
	[106652] = { "-ARMOR", "XMOG" }, --Spirestrider Spaulders
	[24868] = { "-ARMOR", "XMOG" }, --Blood Knight Pauldrons
	[7543] = { "-ARMOR", "XMOG" }, --Champion's Pauldrons
	[8272] = { "-ARMOR", "XMOG" }, --Ebonhold Shoulderpads
	[106751] = { "-ARMOR", "XMOG" }, --Packrunner Spaulders
	[118838] = { "-ARMOR", "XMOG" }, --J'kaey's Shining Spaulders
	[13133] = { "-ARMOR", "XMOG" }, --Drakesfire Epaulets
	[10125] = { "-ARMOR", "XMOG" }, --Ornate Pauldrons
	[10163] = { "-ARMOR", "XMOG" }, --Mercurial Pauldrons
	[87489] = { "-ARMOR", "XMOG" }, --Fletcher's Sharpening Shoulders
	[9965] = { "-ARMOR", "XMOG" }, --Warmonger's Pauldrons
	[8310] = { "-ARMOR", "XMOG" }, --Hero's Pauldrons
	[15608] = { "-ARMOR", "XMOG" }, --Ancient Pauldrons
	[106553] = { "-ARMOR", "XMOG" }, --Warpscale Spaulders
	[13131] = { "-ARMOR", "XMOG" }, --Sparkleshell Mantle
	[24812] = { "-ARMOR", "XMOG" }, --Unyielding Spaulders
	[10200] = { "-ARMOR", "XMOG" }, --Crusader's Pauldrons
	[6597] = { "-ARMOR", "XMOG" }, --Battleforge Shoulderguards
	[38417] = { "-ARMOR", "XMOG" }, --Nerubian Shoulders
	[24900] = { "-ARMOR", "XMOG" }, --Sundered Spaulders
	[66976] = { "-ARMOR", "XMOG" }, --Spaulders of the Savage Beast
	[24828] = { "-ARMOR", "XMOG" }, --Netherstalker Mantle
	[8207] = { "-ARMOR", "XMOG" }, --Tough Scorpid Shoulders
	[82027] = { "-ARMOR", "XMOG" }, --Steppe Spaulders
	[106718] = { "-ARMOR", "XMOG" }, --Sunspring Spaulders
	[82247] = { "-ARMOR", "XMOG" }, --Yak Spaulders
	[10237] = { "-ARMOR", "XMOG" }, --Engraved Pauldrons
	[106487] = { "-ARMOR", "XMOG" }, --Tangleheart Spaulders
	[24844] = { "-ARMOR", "XMOG" }, --Wrathfin Mantle
	[36209] = { "-ARMOR", "XMOG" }, --Nifflevar Shoulderguards
	[10085] = { "-ARMOR", "XMOG" }, --Lord's Pauldrons
	[24876] = { "-ARMOR", "XMOG" }, --Ironspine Shoulderguards
	[35616] = { "-ARMOR", "XMOG" }, --Spored Tendrils Spaulders
	[8133] = { "-ARMOR", "XMOG" }, --Myrmidon's Pauldrons
	[55616] = { "-ARMOR", "XMOG" }, --Sundown Spaulders
	[24892] = { "-ARMOR", "XMOG" }, --Skettis Spaulders
	[36281] = { "-ARMOR", "XMOG" }, --Spiderlord Spaulders
	[24884] = { "-ARMOR", "XMOG" }, --Der'izu Spaulders
	[37779] = { "-ARMOR", "XMOG" }, --Nixod's Chain-Threshed Spaulders
	[31294] = { "-ARMOR", "XMOG" }, --Pauldrons of Surging Mana
	[37772] = { "-ARMOR", "XMOG" }, --Wub's Electrospike Spaulders
	[36217] = { "-ARMOR", "XMOG" }, --Orca Spaulders
	[24908] = { "-ARMOR", "XMOG" }, --Talhide Shoulderguards
	[119338] = { "-ARMOR", "XMOG" }, --Belt of Inebriated Sorrows
	[15641] = { "-ARMOR", "XMOG" }, --Ironhide Belt
	[15673] = { "-ARMOR", "XMOG" }, --Magnificent Belt
	[15528] = { "-ARMOR", "XMOG" }, --Sentry's Sash
	[6200] = { "-ARMOR", "XMOG" }, --Garneg's War Belt
	[116194] = { "-ARMOR", "XMOG" }, --Wayfaring Belt
	[98614] = { "-ARMOR", "XMOG" }, --Gorge Stalker Belt
	[15613] = { "-ARMOR", "XMOG" }, --Bonelink Belt
	[8268] = { "-ARMOR", "XMOG" }, --Ebonhold Girdle
	[45553] = { "-ARMOR", "XMOG" }, --Belt of Dragons
	[14803] = { "-ARMOR", "XMOG" }, --Bloodlust Belt
	[4717] = { "-ARMOR", "XMOG" }, --Mail Combat Belt
	[15598] = { "-ARMOR", "XMOG" }, --Steadfast Girdle
	[14793] = { "-ARMOR", "XMOG" }, --Protector Waistband
	[10122] = { "-ARMOR", "XMOG" }, --Ornate Girdle
	[15636] = { "-ARMOR", "XMOG" }, --Formidable Belt
	[14808] = { "-ARMOR", "XMOG" }, --Warstrike Belt
	[24814] = { "-ARMOR", "XMOG" }, --Felstone Waistband
	[8306] = { "-ARMOR", "XMOG" }, --Hero's Belt
	[15575] = { "-ARMOR", "XMOG" }, --Sparkleshell Belt
	[10269] = { "-ARMOR", "XMOG" }, --Masterwork Girdle
	[15654] = { "-ARMOR", "XMOG" }, --Merciless Belt
	[15606] = { "-ARMOR", "XMOG" }, --Ancient Belt
	[10081] = { "-ARMOR", "XMOG" }, --Lord's Girdle
	[68752] = { "-ARMOR", "XMOG" }, --Imbued Infantry Belt
	[4727] = { "-ARMOR", "XMOG" }, --Chief Brigadier Girdle
	[15683] = { "-ARMOR", "XMOG" }, --Triumphant Girdle
	[118833] = { "-ARMOR", "XMOG" }, --Chain Links of Pea'dexx
	[24806] = { "-ARMOR", "XMOG" }, --Unyielding Waistband
	[16838] = { "-ARMOR", "XMOG" }, --Earthfury Belt
	[28497] = { "-ARMOR", "XMOG" }, --Dreadhawk's Girdle
	[7546] = { "-ARMOR", "XMOG" }, --Champion's Girdle
	[15515] = { "-ARMOR", "XMOG" }, --Spiked Chain Belt
	[12978] = { "-ARMOR", "XMOG" }, --Stormbringer Belt
	[24878] = { "-ARMOR", "XMOG" }, --Der'izu Belt
	[50015] = { "-ARMOR", "XMOG" }, --Belt of the Blood Nova
	[4712] = { "-ARMOR", "XMOG" }, --Glimmering Mail Girdle
	[7462] = { "-ARMOR", "XMOG" }, --Knight's Girdle
	[9931] = { "-ARMOR", "XMOG" }, --Brigade Girdle
	[9961] = { "-ARMOR", "XMOG" }, --Warmonger's Belt
	[9869] = { "-ARMOR", "XMOG" }, --Renegade Belt
	[14773] = { "-ARMOR", "XMOG" }, --Ravager's Cord
	[78886] = { "-ARMOR", "XMOG" }, --Belt of Ghostly Graces
	[4707] = { "-ARMOR", "XMOG" }, --Lambent Scale Girdle
	[85841] = { "-ARMOR", "XMOG" }, --Stormscale Belt
	[94079] = { "-ARMOR", "XMOG" }, --Brittle Flamereaver Belt
	[24846] = { "-ARMOR", "XMOG" }, --Fenclaw Waistband
	[9405] = { "-ARMOR", "XMOG" }, --Girdle of Golem Strength
	[10329] = { "-ARMOR", "XMOG" }, --Scarlet Belt
	[24862] = { "-ARMOR", "XMOG" }, --Blood Knight Girdle
	[9840] = { "-ARMOR", "XMOG" }, --Banded Girdle
	[24870] = { "-ARMOR", "XMOG" }, --Ironspine Belt
	[15510] = { "-ARMOR", "XMOG" }, --Grunt's Belt
	[832] = { "-ARMOR", "XMOG" }, --Silver Defias Belt
	[78885] = { "-ARMOR", "XMOG" }, --Dragoncarver Belt
	[9788] = { "-ARMOR", "XMOG" }, --Raider's Belt
	[14783] = { "-ARMOR", "XMOG" }, --Khan's Belt
	[31293] = { "-ARMOR", "XMOG" }, --Girdle of Gale Force
	[6576] = { "-ARMOR", "XMOG" }, --Defender Girdle
	[10154] = { "-ARMOR", "XMOG" }, --Mercurial Girdle
	[16851] = { "-ARMOR", "XMOG" }, --Giantstalker's Belt
	[10197] = { "-ARMOR", "XMOG" }, --Crusader's Belt
	[36179] = { "-ARMOR", "XMOG" }, --Garmaul Waistband
	[15082] = { "-ARMOR", "XMOG" }, --Heavy Scorpid Belt
	[24830] = { "-ARMOR", "XMOG" }, --Nexus-Strider Belt
	[106613] = { "-ARMOR", "XMOG" }, --Varashi Belt
	[39762] = { "-ARMOR", "XMOG" }, --Torn Web Wrapping
	[106646] = { "-ARMOR", "XMOG" }, --Spirestrider Belt
	[106679] = { "-ARMOR", "XMOG" }, --Snarlthorn Belt
	[67114] = { "-ARMOR", "XMOG" }, --Girdle of Chained Thunder
	[106580] = { "-ARMOR", "XMOG" }, --Deathweb Belt
	[24838] = { "-ARMOR", "XMOG" }, --Wrathfin Waistband
	[8129] = { "-ARMOR", "XMOG" }, --Myrmidon's Girdle
	[15492] = { "-ARMOR", "XMOG" }, --Bloodspattered Sash
	[36219] = { "-ARMOR", "XMOG" }, --Amberpine Girdle
	[9814] = { "-ARMOR", "XMOG" }, --Fortified Belt
	[82131] = { "-ARMOR", "XMOG" }, --Willow Belt
	[4697] = { "-ARMOR", "XMOG" }, --Burnished Girdle
	[87505] = { "-ARMOR", "XMOG" }, --Spirit-Speaking Belt
	[66966] = { "-ARMOR", "XMOG" }, --Elekk-Horn Waistguard
	[106514] = { "-ARMOR", "XMOG" }, --Highland Belt
	[13134] = { "-ARMOR", "XMOG" }, --Belt of the Gladiator
	[82021] = { "-ARMOR", "XMOG" }, --Steppe Belt
	[15497] = { "-ARMOR", "XMOG" }, --Outrunner's Cord
	[55626] = { "-ARMOR", "XMOG" }, --Bramblescar Belt
	[87503] = { "-ARMOR", "XMOG" }, --Repin's Ammo-Laden Belt
	[37778] = { "-ARMOR", "XMOG" }, --Girdle of Unerring Flight
	[24886] = { "-ARMOR", "XMOG" }, --Skettis Belt
	[37773] = { "-ARMOR", "XMOG" }, --Shock-Inducing Girdle
	[36259] = { "-ARMOR", "XMOG" }, --Cormorant Waistband
	[31138] = { "-ARMOR", "XMOG" }, --Storm Lord's Girdle
	[2857] = { "-ARMOR", "XMOG" }, --Runed Copper Belt
	[36243] = { "-ARMOR", "XMOG" }, --Mammoth Girdle
	[7494] = { "-ARMOR", "XMOG" }, --Captain's Waistguard
	[24902] = { "-ARMOR", "XMOG" }, --Talhide Stitched-Belt
	[4438] = { "-ARMOR", "XMOG" }, --Pugilist Bracers
	[119334] = { "-ARMOR", "XMOG" }, --Bracers of Callous Disregard
	[15639] = { "-ARMOR", "XMOG" }, --Ironhide Bracers
	[15668] = { "-ARMOR", "XMOG" }, --Magnificent Bracers
	[16671] = { "-ARMOR", "XMOG" }, --Bindings of Elements
	[14723] = { "-ARMOR", "XMOG" }, --War Paint Bindings
	[15610] = { "-ARMOR", "XMOG" }, --Bonelink Bracers
	[15620] = { "-ARMOR", "XMOG" }, --Gryphon Mail Bracelets
	[116192] = { "-ARMOR", "XMOG" }, --Wayfaring Bracers
	[14788] = { "-ARMOR", "XMOG" }, --Protector Armguards
	[8264] = { "-ARMOR", "XMOG" }, --Ebonhold Wristguards
	[90482] = { "-ARMOR", "XMOG" }, --Stormscale Bracers
	[15577] = { "-ARMOR", "XMOG" }, --Sparkleshell Bracers
	[15649] = { "-ARMOR", "XMOG" }, --Merciless Bracers
	[15499] = { "-ARMOR", "XMOG" }, --Outrunner's Cuffs
	[24837] = { "-ARMOR", "XMOG" }, --Nexus-Strider Bracer
	[24901] = { "-ARMOR", "XMOG" }, --Tortured Bracer
	[6403] = { "-ARMOR", "XMOG" }, --Mail Combat Armguards
	[7416] = { "-ARMOR", "XMOG" }, --Phalanx Bracers
	[10076] = { "-ARMOR", "XMOG" }, --Lord's Armguards
	[93578] = { "-ARMOR", "XMOG" }, --Crafted Dreadful Gladiator's Armbands of Meditation
	[77319] = { "-ARMOR", "XMOG" }, --Bracers of the Spectral Wolf
	[8302] = { "-ARMOR", "XMOG" }, --Hero's Bracers
	[10265] = { "-ARMOR", "XMOG" }, --Masterwork Bracers
	[6426] = { "-ARMOR", "XMOG" }, --Blackforge Bracers
	[15600] = { "-ARMOR", "XMOG" }, --Ancient Vambraces
	[24861] = { "-ARMOR", "XMOG" }, --Marshcreeper Bracelets
	[15659] = { "-ARMOR", "XMOG" }, --Impenetrable Bindings
	[14810] = { "-ARMOR", "XMOG" }, --Warstrike Armsplints
	[9865] = { "-ARMOR", "XMOG" }, --Renegade Bracers
	[8125] = { "-ARMOR", "XMOG" }, --Myrmidon's Bracers
	[93492] = { "-ARMOR", "XMOG" }, --Crafted Dreadful Gladiator's Wristguards of Alacrity
	[118839] = { "-ARMOR", "XMOG" }, --Bonechain Bracers
	[15590] = { "-ARMOR", "XMOG" }, --Steadfast Bracelets
	[10333] = { "-ARMOR", "XMOG" }, --Scarlet Wristguards
	[15679] = { "-ARMOR", "XMOG" }, --Triumphant Bracers
	[15517] = { "-ARMOR", "XMOG" }, --Spiked Chain Wristbands
	[76159] = { "-ARMOR", "XMOG" }, --Legion Bindings
	[7545] = { "-ARMOR", "XMOG" }, --Champion's Bracers
	[7493] = { "-ARMOR", "XMOG" }, --Captain's Bracers
	[6413] = { "-ARMOR", "XMOG" }, --Chief Brigadier Bracers
	[9956] = { "-ARMOR", "XMOG" }, --Warmonger's Bracers
	[15532] = { "-ARMOR", "XMOG" }, --Sentry's Armsplints
	[24813] = { "-ARMOR", "XMOG" }, --Unyielding Bindings
	[7461] = { "-ARMOR", "XMOG" }, --Knight's Bracers
	[15507] = { "-ARMOR", "XMOG" }, --Grunt's Bracers
	[6387] = { "-ARMOR", "XMOG" }, --Glimmering Mail Bracers
	[87519] = { "-ARMOR", "XMOG" }, --Misty Morning Wristguards
	[9927] = { "-ARMOR", "XMOG" }, --Brigade Bracers
	[14778] = { "-ARMOR", "XMOG" }, --Khan's Bindings
	[36242] = { "-ARMOR", "XMOG" }, --Shoveltusk Bindings
	[16840] = { "-ARMOR", "XMOG" }, --Earthfury Bracers
	[10126] = { "-ARMOR", "XMOG" }, --Ornate Bracers
	[14743] = { "-ARMOR", "XMOG" }, --Hulking Bands
	[10229] = { "-ARMOR", "XMOG" }, --Engraved Bracers
	[13012] = { "-ARMOR", "XMOG" }, --Yorgen Bracers
	[24853] = { "-ARMOR", "XMOG" }, --Fenclaw Bindings
	[106614] = { "-ARMOR", "XMOG" }, --Varashi Bracers
	[106581] = { "-ARMOR", "XMOG" }, --Deathweb Bracers
	[82022] = { "-ARMOR", "XMOG" }, --Steppe Bracers
	[106482] = { "-ARMOR", "XMOG" }, --Tangleheart Bracers
	[7924] = { "-ARMOR", "XMOG" }, --Mithril Scale Bracers
	[82242] = { "-ARMOR", "XMOG" }, --Yak Bracers
	[24829] = { "-ARMOR", "XMOG" }, --Netherstalker Bracer
	[106713] = { "-ARMOR", "XMOG" }, --Sunspring Bracers
	[37776] = { "-ARMOR", "XMOG" }, --Bracers of Accurate Fire
	[94055] = { "-ARMOR", "XMOG" }, --Battered Saurscale Bracers
	[13199] = { "-ARMOR", "XMOG" }, --Crushridge Bindings
	[3835] = { "-ARMOR", "XMOG" }, --Green Iron Bracers
	[55566] = { "-ARMOR", "XMOG" }, --Thornsnarl Bracers
	[24869] = { "-ARMOR", "XMOG" }, --Blood Knight Bracers
	[66958] = { "-ARMOR", "XMOG" }, --Bracers of Razor Fletching
	[3212] = { "-ARMOR", "XMOG" }, --Lambent Scale Bracers
	[24821] = { "-ARMOR", "XMOG" }, --Felstone Bindings
	[37777] = { "-ARMOR", "XMOG" }, --Bracers of Sizzling Heat
	[24845] = { "-ARMOR", "XMOG" }, --Wrathfin Bindings
	[71365] = { "-ARMOR", "XMOG" }, --Hide-Bound Chains
	[13135] = { "-ARMOR", "XMOG" }, --Lordly Armguards
	[3211] = { "-ARMOR", "XMOG" }, --Burnished Bracers
	[35615] = { "-ARMOR", "XMOG" }, --Glowworm Cavern Bindings
	[36186] = { "-ARMOR", "XMOG" }, --Garmaul Bracers
	[15566] = { "-ARMOR", "XMOG" }, --Marauder's Bracers
	[24917] = { "-ARMOR", "XMOG" }, --Netherstorm Bracer
	[9896] = { "-ARMOR", "XMOG" }, --Jazeraint Bracers
	[6550] = { "-ARMOR", "XMOG" }, --Soldier's Wristguards
	[36266] = { "-ARMOR", "XMOG" }, --Cormorant Bracelets
	[2854] = { "-ARMOR", "XMOG" }, --Runed Copper Bracers
	[2868] = { "-ARMOR", "XMOG" }, --Patterned Bronze Bracers
	[6040] = { "-ARMOR", "XMOG" }, --Golden Scale Bracers
	[85850] = { "-ARMOR", "XMOG" }, --Wildblood Vest
	[31562] = { "-ARMOR", "XMOG" }, --Skystalker's Tunic
	[25689] = { "-ARMOR", "XMOG" }, --Heavy Clefthoof Vest
	[15064] = { "-ARMOR", "XMOG" }, --Warbear Harness
	[56562] = { "-ARMOR", "XMOG" }, --Assassin's Chestplate
	[15442] = { "-ARMOR", "XMOG" }, --Supreme Breastplate
	[4256] = { "-ARMOR", "XMOG" }, --Guardian Armor
	[75103] = { "-ARMOR", "XMOG" }, --Vicious Leather Chest
	[15159] = { "-ARMOR", "XMOG" }, --Nocturnal Tunic
	[9835] = { "-ARMOR", "XMOG" }, --Scaled Leather Tunic
	[116180] = { "-ARMOR", "XMOG" }, --Supple Vest
	[31263] = { "-ARMOR", "XMOG" }, --Silvermoon Tunic
	[44666] = { "-ARMOR", "XMOG" }, --Fumblub's Seat Cushion
	[15359] = { "-ARMOR", "XMOG" }, --Trickster's Vest
	[44441] = { "-ARMOR", "XMOG" }, --Dark Iceborne Chestguard
	[15390] = { "-ARMOR", "XMOG" }, --Jadefire Chestguard
	[14655] = { "-ARMOR", "XMOG" }, --Scorpashi Breastplate
	[15304] = { "-ARMOR", "XMOG" }, --Grizzly Jerkin
	[9782] = { "-ARMOR", "XMOG" }, --Bandit Jerkin
	[24759] = { "-ARMOR", "XMOG" }, --Umbrafen Tunic
	[14562] = { "-ARMOR", "XMOG" }, --Prospector's Chestpiece
	[10220] = { "-ARMOR", "XMOG" }, --Nightshade Tunic
	[10105] = { "-ARMOR", "XMOG" }, --Wanderer's Armor
	[15311] = { "-ARMOR", "XMOG" }, --Feral Harness
	[1211] = { "-ARMOR", "XMOG" }, --Gnoll War Harness
	[98842] = { "-ARMOR", "XMOG" }, --Crafted Malevolent Gladiator's Copperskin Tunic
	[15085] = { "-ARMOR", "XMOG" }, --Wicked Leather Armor
	[15195] = { "-ARMOR", "XMOG" }, --Grand Breastplate
	[15164] = { "-ARMOR", "XMOG" }, --Imposing Vest
	[3000] = { "-ARMOR", "XMOG" }, --Brood Mother Carapace
	[15356] = { "-ARMOR", "XMOG" }, --Headhunter's Armor
	[14581] = { "-ARMOR", "XMOG" }, --Dokebi Chestguard
	[3313] = { "-ARMOR", "XMOG" }, --Ceremonial Leather Harness
	[15018] = { "-ARMOR", "XMOG" }, --Lupine Vest
	[14664] = { "-ARMOR", "XMOG" }, --Keeper's Armor
	[13110] = { "-ARMOR", "XMOG" }, --Wolffear Harness
	[4861] = { "-ARMOR", "XMOG" }, --Sleek Feathered Tunic
	[4057] = { "-ARMOR", "XMOG" }, --Insignia Chestguard
	[8296] = { "-ARMOR", "XMOG" }, --Traveler's Jerkin
	[6584] = { "-ARMOR", "XMOG" }, --Scouting Tunic
	[4058] = { "-ARMOR", "XMOG" }, --Glyphed Breastplate
	[10151] = { "-ARMOR", "XMOG" }, --Mighty Tunic
	[7439] = { "-ARMOR", "XMOG" }, --Sentinel Breastplate
	[6430] = { "-ARMOR", "XMOG" }, --Imperial Leather Breastplate
	[15433] = { "-ARMOR", "XMOG" }, --Peerless Armor
	[15075] = { "-ARMOR", "XMOG" }, --Chimeric Vest
	[94072] = { "-ARMOR", "XMOG" }, --Timeworn Shadowtooth Cuirass
	[24695] = { "-ARMOR", "XMOG" }, --Bonechewer Chestpiece
	[6396] = { "-ARMOR", "XMOG" }, --Emblazoned Chestpiece
	[6197] = { "-ARMOR", "XMOG" }, --Loch Croc Hide Vest
	[10070] = { "-ARMOR", "XMOG" }, --Righteous Armor
	[2973] = { "-ARMOR", "XMOG" }, --Hunting Tunic
	[821] = { "-ARMOR", "XMOG" }, --Riverpaw Leather Vest
	[7477] = { "-ARMOR", "XMOG" }, --Ranger Tunic
	[2087] = { "-ARMOR", "XMOG" }, --Hard Crawler Carapace
	[6603] = { "-ARMOR", "XMOG" }, --Dervish Tunic
	[10182] = { "-ARMOR", "XMOG" }, --Swashbuckler's Breastplate
	[50001] = { "-ARMOR", "XMOG" }, --Ikfirus' Sack of Wonder
	[106602] = { "-ARMOR", "XMOG" }, --Ripfang Jerkin
	[8119] = { "-ARMOR", "XMOG" }, --Heraldic Breastplate
	[9887] = { "-ARMOR", "XMOG" }, --Huntsman's Armor
	[9854] = { "-ARMOR", "XMOG" }, --Archer's Jerkin
	[25676] = { "-ARMOR", "XMOG" }, --Wild Draenish Vest
	[9809] = { "-ARMOR", "XMOG" }, --Superior Tunic
	[67135] = { "-ARMOR", "XMOG" }, --Morrie's Waywalker Wrap
	[24727] = { "-ARMOR", "XMOG" }, --Dementia Vest
	[12988] = { "-ARMOR", "XMOG" }, --Starsight Tunic
	[17922] = { "-ARMOR", "XMOG" }, --Lionfur Armor
	[8258] = { "-ARMOR", "XMOG" }, --Serpentskin Armor
	[106635] = { "-ARMOR", "XMOG" }, --Shadeback Jerkin
	[24767] = { "-ARMOR", "XMOG" }, --Clefthoof Hidemantle
	[67121] = { "-ARMOR", "XMOG" }, --Chestguard of the Caring Ursine
	[24784] = { "-ARMOR", "XMOG" }, --Murkblood Chestpiece
	[24743] = { "-ARMOR", "XMOG" }, --Ranger Jerkin
	[24719] = { "-ARMOR", "XMOG" }, --Dreghood Chestpiece
	[87425] = { "-ARMOR", "XMOG" }, --Chestguard of the Solicitious Pandaren
	[24775] = { "-ARMOR", "XMOG" }, --Boneshredder JerkinGeist Tunic
	[36173] = { "-ARMOR", "XMOG" }, --Geist Tunic
	[56509] = { "-ARMOR", "XMOG" }, --Darkbrand Chestguard
	[81980] = { "-ARMOR", "XMOG" }, --Silent Jerkin
	[9924] = { "-ARMOR", "XMOG" }, --Tracker's Tunic
	[24735] = { "-ARMOR", "XMOG" }, --Sunroc Chestpiece
	[94050] = { "-ARMOR", "XMOG" }, --Discarded Swampstalker Tunic
	[106503] = { "-ARMOR", "XMOG" }, --Steamscar Jerkin
	[106569] = { "-ARMOR", "XMOG" }, --Teroclaw Jerkin
	[6552] = { "-ARMOR", "XMOG" }, --Bard's Tunic
	[3055] = { "-ARMOR", "XMOG" }, --Forest Leather Chestpiece
	[2314] = { "-ARMOR", "XMOG" }, --Toughened Leather Armor
	[6709] = { "-ARMOR", "XMOG" }, --Moonglow Vest
	[9757] = { "-ARMOR", "XMOG" }, --Gypsy Tunic
	[106701] = { "-ARMOR", "XMOG" }, --Sabermaw Jerkin
	[31285] = { "-ARMOR", "XMOG" }, --Chestguard of the Talon
	[36149] = { "-ARMOR", "XMOG" }, --Pygmy Tunic
	[36093] = { "-ARMOR", "XMOG" }, --Wildevar Tunic
	[82207] = { "-ARMOR", "XMOG" }, --Thresher Jerkin
	[2961] = { "-ARMOR", "XMOG" }, --Burnt Leather Vest
	[9950] = { "-ARMOR", "XMOG" }, --Chieftain's Breastplate
	[2985] = { "-ARMOR", "XMOG" }, --Inscribed Leather Breastplate
	[106437] = { "-ARMOR", "XMOG" }, --Voidcaller Jerkin
	[36069] = { "-ARMOR", "XMOG" }, --Daggercap Jerkin
	[36085] = { "-ARMOR", "XMOG" }, --Riplash Jerkin
	[6268] = { "-ARMOR", "XMOG" }, --Pioneer Tunic
	[3288] = { "-ARMOR", "XMOG" }, --Tribal Vest
	[37770] = { "-ARMOR", "XMOG" }, --Bulge-Concealing Breastplate
	[25671] = { "-ARMOR", "XMOG" }, --Thick Draenic Vest
	[7527] = { "-ARMOR", "XMOG" }, --Cabalist Chestpiece
	[36133] = { "-ARMOR", "XMOG" }, --Wolverine Jerkin
	[55646] = { "-ARMOR", "XMOG" }, --Dandred Jerkin
	[24800] = { "-ARMOR", "XMOG" }, --Dragonhawk Tunic
	[36125] = { "-ARMOR", "XMOG" }, --Muradin Chestpiece
	[36165] = { "-ARMOR", "XMOG" }, --Webspinner Vest
	[13009] = { "-ARMOR", "XMOG" }, --Cow King's Hide
	[37745] = { "-ARMOR", "XMOG" }, --Greenhealer's Garb
	[24703] = { "-ARMOR", "XMOG" }, --Haal'eshi Jerkin
	[43256] = { "-ARMOR", "XMOG" }, --Jormscale Footpads
	[15389] = { "-ARMOR", "XMOG" }, --Jadefire Sabatons
	[15426] = { "-ARMOR", "XMOG" }, --Peerless Boots
	[14579] = { "-ARMOR", "XMOG" }, --Dokebi Boots
	[119340] = { "-ARMOR", "XMOG" }, --Iron-Flecked Sandals
	[9828] = { "-ARMOR", "XMOG" }, --Scaled Leather Boots
	[116182] = { "-ARMOR", "XMOG" }, --Supple Boots
	[1121] = { "-ARMOR", "XMOG" }, --Feet of the Lynx
	[20658] = { "-ARMOR", "XMOG" }, --Abyssal Leather Boots
	[94269] = { "-ARMOR", "XMOG" }, --Quilen Hide Boots
	[94273] = { "-ARMOR", "XMOG" }, --Spirit Keeper Footguards
	[45564] = { "-ARMOR", "XMOG" }, --Footpads of Silence
	[45565] = { "-ARMOR", "XMOG" }, --Boots of Wintry Endurance
	[15142] = { "-ARMOR", "XMOG" }, --Ghostwalker Boots
	[9382] = { "-ARMOR", "XMOG" }, --Tromping Miner's Boots
	[6420] = { "-ARMOR", "XMOG" }, --Glyphed Boots
	[15435] = { "-ARMOR", "XMOG" }, --Supreme Shoes
	[106466] = { "-ARMOR", "XMOG" }, --Tailthrasher Boots
	[118826] = { "-ARMOR", "XMOG" }, --Cadi's Grass Stained Slippers
	[15350] = { "-ARMOR", "XMOG" }, --Headhunter's Slippers
	[8256] = { "-ARMOR", "XMOG" }, --Serpentskin Boots
	[9776] = { "-ARMOR", "XMOG" }, --Bandit Boots
	[6431] = { "-ARMOR", "XMOG" }, --Imperial Leather Boots
	[15152] = { "-ARMOR", "XMOG" }, --Nocturnal Shoes
	[24774] = { "-ARMOR", "XMOG" }, --Boneshredder Boots
	[7444] = { "-ARMOR", "XMOG" }, --Sentinel Boots
	[24766] = { "-ARMOR", "XMOG" }, --Clefthoof Wanderboots
	[14589] = { "-ARMOR", "XMOG" }, --Hawkeye's Shoes
	[2276] = { "-ARMOR", "XMOG" }, --Swampwalker Boots
	[8117] = { "-ARMOR", "XMOG" }, --Heraldic Boots
	[7481] = { "-ARMOR", "XMOG" }, --Ranger Boots
	[6582] = { "-ARMOR", "XMOG" }, --Scouting Boots
	[14560] = { "-ARMOR", "XMOG" }, --Prospector's Boots
	[15362] = { "-ARMOR", "XMOG" }, --Trickster's Boots
	[38590] = { "-ARMOR", "XMOG" }, --Black Chitinguard Boots
	[87432] = { "-ARMOR", "XMOG" }, --Tesslah's Ticking Treads
	[24750] = { "-ARMOR", "XMOG" }, --Daggerfen Boots
	[7531] = { "-ARMOR", "XMOG" }, --Cabalist Boots
	[4055] = { "-ARMOR", "XMOG" }, --Insignia Boots
	[3057] = { "-ARMOR", "XMOG" }, --Forest Leather Boots
	[94070] = { "-ARMOR", "XMOG" }, --Timeworn Shadowtooth Boots
	[40270] = { "-ARMOR", "XMOG" }, --Boots of Septic Wounds
	[10146] = { "-ARMOR", "XMOG" }, --Mighty Boots
	[15370] = { "-ARMOR", "XMOG" }, --Wolf Rider's Boots
	[15305] = { "-ARMOR", "XMOG" }, --Feral Shoes
	[24742] = { "-ARMOR", "XMOG" }, --Ranger Boots
	[10068] = { "-ARMOR", "XMOG" }, --Righteous Boots
	[106598] = { "-ARMOR", "XMOG" }, --Ripfang Boots
	[36132] = { "-ARMOR", "XMOG" }, --Wolverine Boots
	[36108] = { "-ARMOR", "XMOG" }, --Vileprey Boots
	[36148] = { "-ARMOR", "XMOG" }, --Pygmy Boots
	[15073] = { "-ARMOR", "XMOG" }, --Chimeric Boots
	[9917] = { "-ARMOR", "XMOG" }, --Tracker's Boots
	[9885] = { "-ARMOR", "XMOG" }, --Huntsman's Boots
	[9948] = { "-ARMOR", "XMOG" }, --Chieftain's Boots
	[24710] = { "-ARMOR", "XMOG" }, --Vengeance Boots
	[106565] = { "-ARMOR", "XMOG" }, --Teroclaw Boots
	[8294] = { "-ARMOR", "XMOG" }, --Traveler's Boots
	[24694] = { "-ARMOR", "XMOG" }, --Bonechewer Shredboots
	[24758] = { "-ARMOR", "XMOG" }, --Umbrafen Boots
	[44442] = { "-ARMOR", "XMOG" }, --Bugsquashers
	[10222] = { "-ARMOR", "XMOG" }, --Nightshade Boots
	[106697] = { "-ARMOR", "XMOG" }, --Sabermaw Boots
	[36172] = { "-ARMOR", "XMOG" }, --Geist Boots
	[24702] = { "-ARMOR", "XMOG" }, --Haal'eshi Boots
	[38404] = { "-ARMOR", "XMOG" }, --Arctic Boots
	[10106] = { "-ARMOR", "XMOG" }, --Wanderer's Boots
	[24726] = { "-ARMOR", "XMOG" }, --Dementia Boots
	[10183] = { "-ARMOR", "XMOG" }, --Swashbuckler's Boots
	[82148] = { "-ARMOR", "XMOG" }, --Swamp Boots
	[106631] = { "-ARMOR", "XMOG" }, --Shadeback Boots
	[36116] = { "-ARMOR", "XMOG" }, --Taunka Boots
	[55657] = { "-ARMOR", "XMOG" }, --Ravenholdt Boots
	[25668] = { "-ARMOR", "XMOG" }, --Thick Draenic Boots
	[106433] = { "-ARMOR", "XMOG" }, --Voidcaller Boots
	[37763] = { "-ARMOR", "XMOG" }, --Treads of the Purifier
	[24799] = { "-ARMOR", "XMOG" }, --Dragonhawk Boots
	[66967] = { "-ARMOR", "XMOG" }, --Camelhide Treads
	[94049] = { "-ARMOR", "XMOG" }, --Discarded Swampstalker Boots
	[2307] = { "-ARMOR", "XMOG" }, --Fine Leather Boots
	[36084] = { "-ARMOR", "XMOG" }, --Riplash Boots
	[36156] = { "-ARMOR", "XMOG" }, --Wendigo Boots
	[56491] = { "-ARMOR", "XMOG" }, --Darkbrand Boots
	[31288] = { "-ARMOR", "XMOG" }, --The Master's Treads
	[24783] = { "-ARMOR", "XMOG" }, --Murkblood Boots
	[81979] = { "-ARMOR", "XMOG" }, --Silent Boots
	[2987] = { "-ARMOR", "XMOG" }, --Inscribed Leather Boots
	[25673] = { "-ARMOR", "XMOG" }, --Wild Draenish Boots
	[36068] = { "-ARMOR", "XMOG" }, --Daggercap Boots
	[12547] = { "-ARMOR", "XMOG" }, --Mar Alom's Grip
	[40362] = { "-ARMOR", "XMOG" }, --Gloves of Fast Reactions
	[113602] = { "-ARMOR", "XMOG" }, --Throat-Ripper Gauntlets
	[15429] = { "-ARMOR", "XMOG" }, --Peerless Gloves
	[1978] = { "-ARMOR", "XMOG" }, --Wolfclaw Gloves
	[17721] = { "-ARMOR", "XMOG" }, --Gloves of the Greatfather
	[14564] = { "-ARMOR", "XMOG" }, --Prospector's Mitts
	[18344] = { "-ARMOR", "XMOG" }, --Stonebark Gauntlets
	[1314] = { "-ARMOR", "XMOG" }, --Ghoul Fingers
	[14583] = { "-ARMOR", "XMOG" }, --Dokebi Gloves
	[10072] = { "-ARMOR", "XMOG" }, --Righteous Gloves
	[2564] = { "-ARMOR", "XMOG" }, --Elven Spirit Claws
	[9832] = { "-ARMOR", "XMOG" }, --Scaled Leather Gloves
	[15438] = { "-ARMOR", "XMOG" }, --Supreme Gloves
	[15149] = { "-ARMOR", "XMOG" }, --Ghostwalker Gloves
	[24728] = { "-ARMOR", "XMOG" }, --Dementia Gloves
	[116179] = { "-ARMOR", "XMOG" }, --Supple Gloves
	[93507] = { "-ARMOR", "XMOG" }, --Crafted Dreadful Gladiator's Ironskin Gloves
	[98838] = { "-ARMOR", "XMOG" }, --Crafted Malevolent Gladiator's Copperskin Gloves
	[6554] = { "-ARMOR", "XMOG" }, --Bard's Gloves
	[8298] = { "-ARMOR", "XMOG" }, --Traveler's Gloves
	[15115] = { "-ARMOR", "XMOG" }, --Rigid Gloves
	[867] = { "-ARMOR", "XMOG" }, --Gloves of Holy Might
	[3314] = { "-ARMOR", "XMOG" }, --Ceremonial Leather Gloves
	[4063] = { "-ARMOR", "XMOG" }, --Imperial Leather Gloves
	[3058] = { "-ARMOR", "XMOG" }, --Forest Leather Gloves
	[8121] = { "-ARMOR", "XMOG" }, --Heraldic Gloves
	[15365] = { "-ARMOR", "XMOG" }, --Trickster's Handwraps
	[24696] = { "-ARMOR", "XMOG" }, --Bonechewer Spikegloves
	[15372] = { "-ARMOR", "XMOG" }, --Wolf Rider's Gloves
	[15155] = { "-ARMOR", "XMOG" }, --Nocturnal Gloves
	[6397] = { "-ARMOR", "XMOG" }, --Emblazoned Gloves
	[20661] = { "-ARMOR", "XMOG" }, --Abyssal Leather Gloves
	[2976] = { "-ARMOR", "XMOG" }, --Hunting Gloves
	[720] = { "-ARMOR", "XMOG" }, --Brawler Gloves
	[93466] = { "-ARMOR", "XMOG" }, --Crafted Dreadful Gladiator's Kodohide Gloves
	[24720] = { "-ARMOR", "XMOG" }, --Dreghood Gloves
	[24760] = { "-ARMOR", "XMOG" }, --Umbrafen Gloves
	[15192] = { "-ARMOR", "XMOG" }, --Grand Gauntlets
	[56484] = { "-ARMOR", "XMOG" }, --Darkbrand Gloves
	[14606] = { "-ARMOR", "XMOG" }, --Warden's Gloves
	[9861] = { "-ARMOR", "XMOG" }, --Archer's Gloves
	[9892] = { "-ARMOR", "XMOG" }, --Huntsman's Gloves
	[87443] = { "-ARMOR", "XMOG" }, --Syrio's Gloves of Tutelage
	[93570] = { "-ARMOR", "XMOG" }, --Crafted Dreadful Gladiator's Leather Gloves
	[15343] = { "-ARMOR", "XMOG" }, --Pathfinder Gloves
	[14594] = { "-ARMOR", "XMOG" }, --Hawkeye's Gloves
	[94044] = { "-ARMOR", "XMOG" }, --Discarded Swampstalker Gloves
	[7285] = { "-ARMOR", "XMOG" }, --Nimble Leather Gloves
	[10149] = { "-ARMOR", "XMOG" }, --Mighty Gauntlets
	[10110] = { "-ARMOR", "XMOG" }, --Wanderer's Gloves
	[6586] = { "-ARMOR", "XMOG" }, --Scouting Gloves
	[24776] = { "-ARMOR", "XMOG" }, --Boneshredder Gloves
	[9780] = { "-ARMOR", "XMOG" }, --Bandit Gloves
	[10186] = { "-ARMOR", "XMOG" }, --Swashbuckler's Gloves
	[15083] = { "-ARMOR", "XMOG" }, --Wicked Leather Gauntlets
	[10260] = { "-ARMOR", "XMOG" }, --Adventurer's Gloves
	[106435] = { "-ARMOR", "XMOG" }, --Voidcaller Gloves
	[9952] = { "-ARMOR", "XMOG" }, --Chieftain's Gloves
	[6467] = { "-ARMOR", "XMOG" }, --Deviate Scale Gloves
	[118828] = { "-ARMOR", "XMOG" }, --Amienne's Velvety Touch
	[7480] = { "-ARMOR", "XMOG" }, --Ranger Gloves
	[14666] = { "-ARMOR", "XMOG" }, --Keeper's Gloves
	[2988] = { "-ARMOR", "XMOG" }, --Inscribed Leather Gloves
	[7348] = { "-ARMOR", "XMOG" }, --Fletcher's Gloves
	[8346] = { "-ARMOR", "XMOG" }, --Gauntlets of the Sea
	[36150] = { "-ARMOR", "XMOG" }, --Pygmy Gloves
	[106567] = { "-ARMOR", "XMOG" }, --Teroclaw Gloves
	[24712] = { "-ARMOR", "XMOG" }, --Vengeance Gloves
	[14685] = { "-ARMOR", "XMOG" }, --Indomitable Gauntlets
	[82260] = { "-ARMOR", "XMOG" }, --Vine Gloves
	[6408] = { "-ARMOR", "XMOG" }, --Insignia Gloves
	[36102] = { "-ARMOR", "XMOG" }, --Caribou Gloves
	[7530] = { "-ARMOR", "XMOG" }, --Cabalist Gloves
	[66970] = { "-ARMOR", "XMOG" }, --Safecracker's Gloves
	[106699] = { "-ARMOR", "XMOG" }, --Sabermaw Gloves
	[55665] = { "-ARMOR", "XMOG" }, --Haldarr Gloves
	[36134] = { "-ARMOR", "XMOG" }, --Wolverine Gloves
	[36118] = { "-ARMOR", "XMOG" }, --Taunka Gloves
	[106600] = { "-ARMOR", "XMOG" }, --Ripfang Gloves
	[106633] = { "-ARMOR", "XMOG" }, --Shadeback Gloves
	[31126] = { "-ARMOR", "XMOG" }, --Gloves of Ferocity
	[36086] = { "-ARMOR", "XMOG" }, --Riplash Gloves
	[24768] = { "-ARMOR", "XMOG" }, --Clefthoof Gloves
	[36158] = { "-ARMOR", "XMOG" }, --Wendigo Gloves
	[9920] = { "-ARMOR", "XMOG" }, --Tracker's Gloves
	[81978] = { "-ARMOR", "XMOG" }, --Silent Gloves
	[24785] = { "-ARMOR", "XMOG" }, --Murkblood Gloves
	[24736] = { "-ARMOR", "XMOG" }, --Sunroc Gloves
	[36110] = { "-ARMOR", "XMOG" }, --Vileprey Gloves
	[24793] = { "-ARMOR", "XMOG" }, --Expedition Gloves
	[4239] = { "-ARMOR", "XMOG" }, --Embossed Leather Gloves
	[24704] = { "-ARMOR", "XMOG" }, --Haal'eshi Gloves
	[15091] = { "-ARMOR", "XMOG" }, --Runic Leather Gauntlets
	[25680] = { "-ARMOR", "XMOG" }, --Stylin' Purple Hat
	[9420] = { "-ARMOR", "XMOG" }, --Adventurer's Pith Helmet
	[118894] = { "-ARMOR", "XMOG" }, --Toria's Perseverance
	[36087] = { "-ARMOR", "XMOG" }, --Riplash Cover
	[43261] = { "-ARMOR", "XMOG" }, --Overcast Headguard
	[31219] = { "-ARMOR", "XMOG" }, --Emerald Beholder Eye
	[9859] = { "-ARMOR", "XMOG" }, --Archer's Cap
	[31184] = { "-ARMOR", "XMOG" }, --Legion Headguard
	[10226] = { "-ARMOR", "XMOG" }, --Nightshade Helmet
	[15156] = { "-ARMOR", "XMOG" }, --Nocturnal Cap
	[6204] = { "-ARMOR", "XMOG" }, --Tribal Worg Helm
	[5753] = { "-ARMOR", "XMOG" }, --Ruffled Chaplet
	[1280] = { "-ARMOR", "XMOG" }, --Cloaked Hood
	[44732] = { "-ARMOR", "XMOG" }, --Azure Dragonleather Helm
	[4052] = { "-ARMOR", "XMOG" }, --Insignia Cap
	[109171] = { "-ARMOR", "XMOG" }, --Night-Vision Mechshades
	[116177] = { "-ARMOR", "XMOG" }, --Supple Helm
	[10187] = { "-ARMOR", "XMOG" }, --Swashbuckler's Eyepatch
	[93519] = { "-ARMOR", "XMOG" }, --Crafted Dreadful Gladiator's Copperskin Helm
	[15363] = { "-ARMOR", "XMOG" }, --Trickster's Headdress
	[15439] = { "-ARMOR", "XMOG" }, --Supreme Crown
	[15353] = { "-ARMOR", "XMOG" }, --Headhunter's Headdress
	[31333] = { "-ARMOR", "XMOG" }, --The Night Watchman
	[4048] = { "-ARMOR", "XMOG" }, --Emblazoned Hat
	[9889] = { "-ARMOR", "XMOG" }, --Huntsman's Cap
	[102348] = { "-ARMOR", "XMOG" }, --Timeworn Shadowtooth Faceguard
	[10261] = { "-ARMOR", "XMOG" }, --Adventurer's Bandana
	[118829] = { "-ARMOR", "XMOG" }, --Treasure Hunter's Bandana
	[15373] = { "-ARMOR", "XMOG" }, --Wolf Rider's Headgear
	[15430] = { "-ARMOR", "XMOG" }, --Peerless Headband
	[6433] = { "-ARMOR", "XMOG" }, --Imperial Leather Helm
	[93467] = { "-ARMOR", "XMOG" }, --Crafted Dreadful Gladiator's Kodohide Helm
	[8348] = { "-ARMOR", "XMOG" }, --Helm of Fire
	[9953] = { "-ARMOR", "XMOG" }, --Chieftain's Headdress
	[10406] = { "-ARMOR", "XMOG" }, --Scaled Leather Headband
	[15167] = { "-ARMOR", "XMOG" }, --Imposing Bandana
	[87452] = { "-ARMOR", "XMOG" }, --Zom's Misty Hood
	[106634] = { "-ARMOR", "XMOG" }, --Shadeback Hood
	[116164] = { "-ARMOR", "XMOG" }, --Journeying Helm
	[56505] = { "-ARMOR", "XMOG" }, --Darkbrand Helm
	[24745] = { "-ARMOR", "XMOG" }, --Ranger Hat
	[8201] = { "-ARMOR", "XMOG" }, --Big Voodoo Mask
	[15193] = { "-ARMOR", "XMOG" }, --Grand Crown
	[37767] = { "-ARMOR", "XMOG" }, --Ryft's Deathgaze
	[14604] = { "-ARMOR", "XMOG" }, --Warden's Wizard Hat
	[10150] = { "-ARMOR", "XMOG" }, --Mighty Helmet
	[6422] = { "-ARMOR", "XMOG" }, --Glyphed Helm
	[7441] = { "-ARMOR", "XMOG" }, --Sentinel Cap
	[24697] = { "-ARMOR", "XMOG" }, --Bonechewer Skincloak
	[106568] = { "-ARMOR", "XMOG" }, --Teroclaw Hood
	[10111] = { "-ARMOR", "XMOG" }, --Wanderer's Hat
	[36175] = { "-ARMOR", "XMOG" }, --Geist Hood
	[13112] = { "-ARMOR", "XMOG" }, --Winged Helm
	[106436] = { "-ARMOR", "XMOG" }, --Voidcaller Hood
	[106502] = { "-ARMOR", "XMOG" }, --Steamscar Hood
	[24705] = { "-ARMOR", "XMOG" }, --Haal'eshi Hat
	[36143] = { "-ARMOR", "XMOG" }, --Ghrino Cover
	[106601] = { "-ARMOR", "XMOG" }, --Ripfang Hood
	[3020] = { "-ARMOR", "XMOG" }, --Enduring Cap
	[36071] = { "-ARMOR", "XMOG" }, --Daggercap Cover
	[8299] = { "-ARMOR", "XMOG" }, --Traveler's Helm
	[24786] = { "-ARMOR", "XMOG" }, --Murkblood Cover
	[24713] = { "-ARMOR", "XMOG" }, --Vengeance Helm
	[82096] = { "-ARMOR", "XMOG" }, --Mushan Hide Hood
	[10073] = { "-ARMOR", "XMOG" }, --Righteous Helmet
	[106700] = { "-ARMOR", "XMOG" }, --Sabermaw Hood
	[55668] = { "-ARMOR", "XMOG" }, --Stagalbog Hood
	[24802] = { "-ARMOR", "XMOG" }, --Dragonhawk Hat
	[82206] = { "-ARMOR", "XMOG" }, --Thresher Hood
	[24721] = { "-ARMOR", "XMOG" }, --Dreghood Cowl
	[94046] = { "-ARMOR", "XMOG" }, --Discarded Swampstalker Headband
	[31281] = { "-ARMOR", "XMOG" }, --Mask of Veiled Death
	[36095] = { "-ARMOR", "XMOG" }, --Wildevar Cap
	[24777] = { "-ARMOR", "XMOG" }, --Boneshredder Skullcap
	[24794] = { "-ARMOR", "XMOG" }, --Expedition Hood
	[24721] = { "-ARMOR", "XMOG" }, --Dreghood Cowl
	[94046] = { "-ARMOR", "XMOG" }, --Discarded Swampstalker Headband
	[31281] = { "-ARMOR", "XMOG" }, --Mask of Veiled Death
	[36159] = { "-ARMOR", "XMOG" }, --Wendigo Hood
	[36119] = { "-ARMOR", "XMOG" }, --Taunka Hat
	[60202] = { "-ARMOR", "XMOG" }, --Tsanga's Helm
	[15094] = { "-ARMOR", "XMOG" }, --Runic Leather Headband
	[13113] = { "-ARMOR", "XMOG" }, --Feathermoon Headdress
	[24769] = { "-ARMOR", "XMOG" }, --Clefthoof Cover
	[24729] = { "-ARMOR", "XMOG" }, --Dementia Hood
	[15086] = { "-ARMOR", "XMOG" }, --Wicked Leather Headband
	[36151] = { "-ARMOR", "XMOG" }, --Pygmy Helmet
	[9509] = { "-ARMOR", "XMOG" }, --Petrolspill Leggings
	[14668] = { "-ARMOR", "XMOG" }, --Keeper's Woolies
	[43495] = { "-ARMOR", "XMOG" }, --Earthgiving Legguards
	[3022] = { "-ARMOR", "XMOG" }, --Bluegill Breeches
	[10400] = { "-ARMOR", "XMOG" }, --Blackened Defias Leggings
	[3315] = { "-ARMOR", "XMOG" }, --Ceremonial Leather Loincloth
	[6587] = { "-ARMOR", "XMOG" }, --Scouting Trousers
	[15168] = { "-ARMOR", "XMOG" }, --Imposing Pants
	[15126] = { "-ARMOR", "XMOG" }, --Robust Leggings
	[116178] = { "-ARMOR", "XMOG" }, --Supple Leggings
	[4060] = { "-ARMOR", "XMOG" }, --Glyphed Leggings
	[2233] = { "-ARMOR", "XMOG" }, --Shadow Weaver Leggings
	[14585] = { "-ARMOR", "XMOG" }, --Dokebi Leggings
	[14565] = { "-ARMOR", "XMOG" }, --Prospector's Woolies
	[90724] = { "-ARMOR", "XMOG" }, --Spriggin's Sproggin' Leggin'
	[10262] = { "-ARMOR", "XMOG" }, --Adventurer's Legguards
	[44440] = { "-ARMOR", "XMOG" }, --Dark Iceborne Leggings
	[90720] = { "-ARMOR", "XMOG" }, --Silent Leggings of the Ghostpaw
	[15344] = { "-ARMOR", "XMOG" }, --Pathfinder Pants
	[8300] = { "-ARMOR", "XMOG" }, --Traveler's Leggings
	[94074] = { "-ARMOR", "XMOG" }, --Timeworn Shadowtooth Trousers
	[10227] = { "-ARMOR", "XMOG" }, --Nightshade Leggings
	[38513] = { "-ARMOR", "XMOG" }, --Boarhide Leggings
	[3056] = { "-ARMOR", "XMOG" }, --Forest Leather Pants
	[24730] = { "-ARMOR", "XMOG" }, --Dementia Trousers
	[15009] = { "-ARMOR", "XMOG" }, --Primal Leggings
	[3287] = { "-ARMOR", "XMOG" }, --Tribal Pants
	[18298] = { "-ARMOR", "XMOG" }, --Unbridled Leggings
	[4054] = { "-ARMOR", "XMOG" }, --Insignia Leggings
	[15394] = { "-ARMOR", "XMOG" }, --Jadefire Pants
	[9862] = { "-ARMOR", "XMOG" }, --Archer's Trousers
	[9922] = { "-ARMOR", "XMOG" }, --Tracker's Leggings
	[4062] = { "-ARMOR", "XMOG" }, --Imperial Leather Pants
	[7478] = { "-ARMOR", "XMOG" }, --Ranger Leggings
	[15358] = { "-ARMOR", "XMOG" }, --Headhunter's Woolies
	[45141] = { "-ARMOR", "XMOG" }, --Proto-Hide Leggings
	[24770] = { "-ARMOR", "XMOG" }, --Clefthoof Britches
	[10188] = { "-ARMOR", "XMOG" }, --Swashbuckler's Leggings
	[24698] = { "-ARMOR", "XMOG" }, --Bonechewer Ripleggings
	[106632] = { "-ARMOR", "XMOG" }, --Shadeback Britches
	[24762] = { "-ARMOR", "XMOG" }, --Umbrafen Britches
	[10112] = { "-ARMOR", "XMOG" }, --Wanderer's Leggings
	[118830] = { "-ARMOR", "XMOG" }, --Fur-Padded Driftwaders
	[82149] = { "-ARMOR", "XMOG" }, --Swamp Britches
	[9781] = { "-ARMOR", "XMOG" }, --Bandit Pants
	[9756] = { "-ARMOR", "XMOG" }, --Gypsy Trousers
	[10074] = { "-ARMOR", "XMOG" }, --Righteous Leggings
	[7440] = { "-ARMOR", "XMOG" }, --Sentinel Trousers
	[24714] = { "-ARMOR", "XMOG" }, --Vengeance Legguards
	[8262] = { "-ARMOR", "XMOG" }, --Serpentskin Leggings
	[7528] = { "-ARMOR", "XMOG" }, --Cabalist Leggings
	[24778] = { "-ARMOR", "XMOG" }, --Boneshredder Britches
	[24722] = { "-ARMOR", "XMOG" }, --Dreghood Trousers
	[15194] = { "-ARMOR", "XMOG" }, --Grand Legguards
	[36088] = { "-ARMOR", "XMOG" }, --Riplash Leggings
	[87462] = { "-ARMOR", "XMOG" }, --Leggings of Perfect Balance
	[15312] = { "-ARMOR", "XMOG" }, --Feral Leggings
	[106533] = { "-ARMOR", "XMOG" }, --Daggerjaw Britches
	[106731] = { "-ARMOR", "XMOG" }, --Meadowstomper Britches
	[36104] = { "-ARMOR", "XMOG" }, --Caribou Britches
	[82039] = { "-ARMOR", "XMOG" }, --Whisper Britches
	[56513] = { "-ARMOR", "XMOG" }, --Darkbrand Leggings
	[24706] = { "-ARMOR", "XMOG" }, --Haal'eshi Leggings
	[2986] = { "-ARMOR", "XMOG" }, --Inscribed Leather Pants
	[8123] = { "-ARMOR", "XMOG" }, --Heraldic Leggings
	[10152] = { "-ARMOR", "XMOG" }, --Mighty Leggings
	[106500] = { "-ARMOR", "XMOG" }, --Steamscar Britches
	[24738] = { "-ARMOR", "XMOG" }, --Sunroc Pants
	[106698] = { "-ARMOR", "XMOG" }, --Sabermaw Britches
	[94047] = { "-ARMOR", "XMOG" }, --Discarded Swampstalker Leggings
	[31226] = { "-ARMOR", "XMOG" }, --Leggings of the Sly
	[36152] = { "-ARMOR", "XMOG" }, --Pygmy Pants
	[24795] = { "-ARMOR", "XMOG" }, --Expedition Pants
	[66962] = { "-ARMOR", "XMOG" }, --Shadowskulk Leggings
	[6553] = { "-ARMOR", "XMOG" }, --Bard's Trousers
	[36112] = { "-ARMOR", "XMOG" }, --Vileprey Leggings
	[15303] = { "-ARMOR", "XMOG" }, --Grizzly Pants
	[106434] = { "-ARMOR", "XMOG" }, --Voidcaller Britches
	[36144] = { "-ARMOR", "XMOG" }, --Ghrino Britches
	[37765] = { "-ARMOR", "XMOG" }, --Leggings of the Water Moccasin
	[31335] = { "-ARMOR", "XMOG" }, --Kilt of Living Growth
	[9893] = { "-ARMOR", "XMOG" }, --Huntsman's Leggings
	[9402] = { "-ARMOR", "XMOG" }, --Earthborn Kilt
	[55679] = { "-ARMOR", "XMOG" }, --Yojamba Britches
	[15072] = { "-ARMOR", "XMOG" }, --Chimeric Leggings
	[37768] = { "-ARMOR", "XMOG" }, --Leggings of Violent Exsanguination
	[36072] = { "-ARMOR", "XMOG" }, --Daggercap Trousers
	[24787] = { "-ARMOR", "XMOG" }, --Murkblood Pants
	[36160] = { "-ARMOR", "XMOG" }, --Wendigo Legguards
	[31237] = { "-ARMOR", "XMOG" }, --Elekk Hide Leggings
	[2962] = { "-ARMOR", "XMOG" }, --Burnt Leather Breeches
	[15087] = { "-ARMOR", "XMOG" }, --Wicked Leather Pants
	[6607] = { "-ARMOR", "XMOG" }, --Dervish Leggings
	[116165] = { "-ARMOR", "XMOG" }, --Journeying Robes
	[37587] = { "-ARMOR", "XMOG" }, --Ymirjar Physician's Robe
	[8200] = { "-ARMOR", "XMOG" }, --Big Voodoo Robe
	[93478] = { "-ARMOR", "XMOG" }, --Crafted Dreadful Gladiator's Wyrmhide Robes
	[15432] = { "-ARMOR", "XMOG" }, --Peerless Shoulders
	[118890] = { "-ARMOR", "XMOG" }, --Studded Frostboar Leather Spaulders
	[14566] = { "-ARMOR", "XMOG" }, --Prospector's Pads
	[75099] = { "-ARMOR", "XMOG" }, --Vicious Wyrmhide Shoulders
	[59467] = { "-ARMOR", "XMOG" }, --Hide of Chromaggus
	[15338] = { "-ARMOR", "XMOG" }, --Wrangler's Mantle
	[116176] = { "-ARMOR", "XMOG" }, --Supple Shoulderguards
	[15693] = { "-ARMOR", "XMOG" }, --Grand Shoulders
	[24715] = { "-ARMOR", "XMOG" }, --Vengeance Pauldrons
	[4721] = { "-ARMOR", "XMOG" }, --Insignia Mantle
	[93573] = { "-ARMOR", "XMOG" }, --Crafted Dreadful Gladiator's Leather Spaulders
	[15140] = { "-ARMOR", "XMOG" }, --Cutthroat's Mantle
	[9955] = { "-ARMOR", "XMOG" }, --Chieftain's Shoulders
	[93479] = { "-ARMOR", "XMOG" }, --Crafted Dreadful Gladiator's Wyrmhide Spaulders
	[93523] = { "-ARMOR", "XMOG" }, --Crafted Dreadful Gladiator's Copperskin Spaulders
	[15187] = { "-ARMOR", "XMOG" }, --Praetorian Pauldrons
	[14669] = { "-ARMOR", "XMOG" }, --Keeper's Mantle
	[98841] = { "-ARMOR", "XMOG" }, --Crafted Malevolent Gladiator's Copperskin Spaulders
	[8124] = { "-ARMOR", "XMOG" }, --Heraldic Spaulders
	[15357] = { "-ARMOR", "XMOG" }, --Headhunter's Spaulders
	[15055] = { "-ARMOR", "XMOG" }, --Volcanic Shoulders
	[10153] = { "-ARMOR", "XMOG" }, --Mighty Spaulders
	[15169] = { "-ARMOR", "XMOG" }, --Imposing Shoulders
	[15158] = { "-ARMOR", "XMOG" }, --Nocturnal Shoulder Pads
	[15441] = { "-ARMOR", "XMOG" }, --Supreme Shoulders
	[10075] = { "-ARMOR", "XMOG" }, --Righteous Spaulders
	[7532] = { "-ARMOR", "XMOG" }, --Cabalist Spaulders
	[106438] = { "-ARMOR", "XMOG" }, --Voidcaller Shoulders
	[40305] = { "-ARMOR", "XMOG" }, --Spaulders of Egotism
	[94076] = { "-ARMOR", "XMOG" }, --Timeworn Shadowtooth Shoulderpads
	[44672] = { "-ARMOR", "XMOG" }, --Seal-Fur Spaulders
	[15150] = { "-ARMOR", "XMOG" }, --Ghostwalker Pads
	[14660] = { "-ARMOR", "XMOG" }, --Scorpashi Shoulder Pads
	[94213] = { "-ARMOR", "XMOG" }, --Bloodtusk Shoulderpads
	[4810] = { "-ARMOR", "XMOG" }, --Boulder Pads
	[8301] = { "-ARMOR", "XMOG" }, --Traveler's Spaulders
	[24699] = { "-ARMOR", "XMOG" }, --Bonechewer Shoulderguards
	[10228] = { "-ARMOR", "XMOG" }, --Nightshade Spaulders
	[15368] = { "-ARMOR", "XMOG" }, --Trickster's Pauldrons
	[4737] = { "-ARMOR", "XMOG" }, --Imperial Leather Spaulders
	[24707] = { "-ARMOR", "XMOG" }, --Haal'eshi Pauldrons
	[94048] = { "-ARMOR", "XMOG" }, --Discarded Swampstalker Shoulders
	[40439] = { "-ARMOR", "XMOG" }, --Mantle of the Eternal Sentinel
	[71025] = { "-ARMOR", "XMOG" }, --Flickering Shoulderpads
	[10113] = { "-ARMOR", "XMOG" }, --Wanderer's Shoulders
	[9863] = { "-ARMOR", "XMOG" }, --Archer's Shoulderpads
	[24763] = { "-ARMOR", "XMOG" }, --Umbrafen Shoulderguards
	[87492] = { "-ARMOR", "XMOG" }, --Mantle of Bestial Force
	[14688] = { "-ARMOR", "XMOG" }, --Indomitable Epaulets
	[4731] = { "-ARMOR", "XMOG" }, --Glyphed Epaulets
	[6399] = { "-ARMOR", "XMOG" }, --Emblazoned Shoulders
	[24739] = { "-ARMOR", "XMOG" }, --Sunroc Shoulderguards
	[82263] = { "-ARMOR", "XMOG" }, --Vine Shoulders
	[15177] = { "-ARMOR", "XMOG" }, --Potent Shoulders
	[13116] = { "-ARMOR", "XMOG" }, --Spaulders of the Unseen
	[36081] = { "-ARMOR", "XMOG" }, --Winterfin Shoulderguards
	[36089] = { "-ARMOR", "XMOG" }, --Riplash Pauldrons
	[36097] = { "-ARMOR", "XMOG" }, --Wildevar Shoulderguards
	[106504] = { "-ARMOR", "XMOG" }, --Steamscar Shoulders
	[106603] = { "-ARMOR", "XMOG" }, --Ripfang Shoulders
	[37764] = { "-ARMOR", "XMOG" }, --Corehound Fang Shoulderpads
	[36153] = { "-ARMOR", "XMOG" }, --Pygmy Shoulders
	[9923] = { "-ARMOR", "XMOG" }, --Tracker's Shoulderpads
	[106537] = { "-ARMOR", "XMOG" }, --Daggerjaw Shoulders
	[38411] = { "-ARMOR", "XMOG" }, --Iceborne Shoulderpads
	[66959] = { "-ARMOR", "XMOG" }, --Toraelian Spaulders
	[7482] = { "-ARMOR", "XMOG" }, --Ranger Shoulders
	[106702] = { "-ARMOR", "XMOG" }, --Sabermaw Shoulders
	[24755] = { "-ARMOR", "XMOG" }, --Daggerfen Pauldrons
	[37769] = { "-ARMOR", "XMOG" }, --Gnarled Shovelhorn Spaulders
	[9807] = { "-ARMOR", "XMOG" }, --Superior Shoulders
	[81975] = { "-ARMOR", "XMOG" }, --Silent Shoulders
	[7415] = { "-ARMOR", "XMOG" }, --Dervish Spaulders
	[67112] = { "-ARMOR", "XMOG" }, --Brittany's Ceremonial Spaulders
	[31148] = { "-ARMOR", "XMOG" }, --Demon Hide Spaulders
	[36145] = { "-ARMOR", "XMOG" }, --Ghrino Pauldrons
	[2278] = { "-ARMOR", "XMOG" }, --Forest Tracker Epaulets
	[55692] = { "-ARMOR", "XMOG" }, --Haldarr Shoulders
	[9834] = { "-ARMOR", "XMOG" }, --Scaled Leather Shoulders
	[24723] = { "-ARMOR", "XMOG" }, --Dreghood Pauldrons
	[36121] = { "-ARMOR", "XMOG" }, --Taunka Spaulders
	[10263] = { "-ARMOR", "XMOG" }, --Adventurer's Shoulders
	[36169] = { "-ARMOR", "XMOG" }, --Webspinner Shoulderguards
	[24796] = { "-ARMOR", "XMOG" }, --Expedition Shoulderguards
	[24788] = { "-ARMOR", "XMOG" }, --Murkblood Shoulderguards
	[24747] = { "-ARMOR", "XMOG" }, --Ranger Pauldrons
	[4251] = { "-ARMOR", "XMOG" }, --Hillman's Shoulders
	[5964] = { "-ARMOR", "XMOG" }, --Barbaric Shoulders
	[31190] = { "-ARMOR", "XMOG" }, --The Dreamer's Shoulderpads
	[56537] = { "-ARMOR", "XMOG" }, --Belt of Nefarious Whispers
	[10403] = { "-ARMOR", "XMOG" }, --Blackened Defias Belt
	[16716] = { "-ARMOR", "XMOG" }, --Wildheart Belt
	[78265] = { "-ARMOR", "XMOG" }, --Replica Darkmantle Belt
	[69877] = { "-ARMOR", "XMOG" }, --Belt of a Thousand Gaping Mouths
	[98609] = { "-ARMOR", "XMOG" }, --Pennyroyal Belt
	[15428] = { "-ARMOR", "XMOG" }, --Peerless Belt
	[15369] = { "-ARMOR", "XMOG" }, --Wolf Rider's Belt
	[116183] = { "-ARMOR", "XMOG" }, --Supple Waistguard
	[106406] = { "-ARMOR", "XMOG" }, --Coldsnout Waistband
	[45556] = { "-ARMOR", "XMOG" }, --Belt of Arctic Life
	[19163] = { "-ARMOR", "XMOG" }, --Molten Belt
	[37243] = { "-ARMOR", "XMOG" }, --Treasure Seeker's Belt
	[6468] = { "-ARMOR", "XMOG" }, --Deviate Scale Belt
	[15120] = { "-ARMOR", "XMOG" }, --Robust Girdle
	[15148] = { "-ARMOR", "XMOG" }, --Ghostwalker Belt
	[7485] = { "-ARMOR", "XMOG" }, --Ranger Cord
	[20667] = { "-ARMOR", "XMOG" }, --Abyssal Leather Belt
	[14559] = { "-ARMOR", "XMOG" }, --Prospector's Sash
	[93566] = { "-ARMOR", "XMOG" }, --Crafted Dreadful Gladiator's Waistband of Accuracy
	[5975] = { "-ARMOR", "XMOG" }, --Ruffian Belt
	[94075] = { "-ARMOR", "XMOG" }, --Timeworn Shadowtooth Belt
	[2899] = { "-ARMOR", "XMOG" }, --Wendigo Collar
	[24701] = { "-ARMOR", "XMOG" }, --Haal'eshi Cord
	[15349] = { "-ARMOR", "XMOG" }, --Headhunter's Belt
	[6382] = { "-ARMOR", "XMOG" }, --Forest Leather Belt
	[50069] = { "-ARMOR", "XMOG" }, --Professor's Bloodied Smock
	[10145] = { "-ARMOR", "XMOG" }, --Mighty Girdle
	[14652] = { "-ARMOR", "XMOG" }, --Scorpashi Sash
	[6421] = { "-ARMOR", "XMOG" }, --Glyphed Belt
	[45709] = { "-ARMOR", "XMOG" }, --Nimble Climber's Belt
	[106637] = { "-ARMOR", "XMOG" }, --Shadeback Waistband
	[15361] = { "-ARMOR", "XMOG" }, --Trickster's Sash
	[15178] = { "-ARMOR", "XMOG" }, --Potent Belt
	[9891] = { "-ARMOR", "XMOG" }, --Huntsman's Belt
	[10259] = { "-ARMOR", "XMOG" }, --Adventurer's Belt
	[24765] = { "-ARMOR", "XMOG" }, --Clefthoof Belt
	[8116] = { "-ARMOR", "XMOG" }, --Heraldic Belt
	[14661] = { "-ARMOR", "XMOG" }, --Keeper's Cord
	[118825] = { "-ARMOR", "XMOG" }, --Windswept Leather Waistguard
	[1215] = { "-ARMOR", "XMOG" }, --Support Girdle
	[4738] = { "-ARMOR", "XMOG" }, --Imperial Leather Belt
	[7448] = { "-ARMOR", "XMOG" }, --Sentinel Girdle
	[8293] = { "-ARMOR", "XMOG" }, --Traveler's Belt
	[4262] = { "-ARMOR", "XMOG" }, --Gem-Studded Leather Belt
	[24693] = { "-ARMOR", "XMOG" }, --Bonechewer Pelt-Girdle
	[36083] = { "-ARMOR", "XMOG" }, --Riplash Belt
	[10109] = { "-ARMOR", "XMOG" }, --Wanderer's Belt
	[13118] = { "-ARMOR", "XMOG" }, --Serpentine Sash
	[78884] = { "-ARMOR", "XMOG" }, --Girdle of Fungal Dreams
	[6409] = { "-ARMOR", "XMOG" }, --Insignia Belt
	[15434] = { "-ARMOR", "XMOG" }, --Supreme Sash
	[78882] = { "-ARMOR", "XMOG" }, --Nightblind Cinch
	[13011] = { "-ARMOR", "XMOG" }, --Silver-Lined Belt
	[14553] = { "-ARMOR", "XMOG" }, --Sash of Mercy
	[13117] = { "-ARMOR", "XMOG" }, --Ogron's Sash
	[36107] = { "-ARMOR", "XMOG" }, --Vileprey Cord
	[9801] = { "-ARMOR", "XMOG" }, --Superior Belt
	[10190] = { "-ARMOR", "XMOG" }, --Swashbuckler's Belt
	[10067] = { "-ARMOR", "XMOG" }, --Righteous Waistguard
	[6398] = { "-ARMOR", "XMOG" }, --Emblazoned Belt
	[24741] = { "-ARMOR", "XMOG" }, --Ranger Belt
	[5780] = { "-ARMOR", "XMOG" }, --Murloc Scale Belt
	[67103] = { "-ARMOR", "XMOG" }, --Belt of Redeemed Fate
	[7387] = { "-ARMOR", "XMOG" }, --Dusky Belt
	[36123] = { "-ARMOR", "XMOG" }, --Muradin Belt
	[31131] = { "-ARMOR", "XMOG" }, --Sash of Silent Blades
	[106703] = { "-ARMOR", "XMOG" }, --Sabermaw Waistband
	[9916] = { "-ARMOR", "XMOG" }, --Tracker's Belt
	[36099] = { "-ARMOR", "XMOG" }, --Caribou Waistband
	[24781] = { "-ARMOR", "XMOG" }, --Murkblood Belt
	[36147] = { "-ARMOR", "XMOG" }, --Pygmy Belt
	[10221] = { "-ARMOR", "XMOG" }, --Nightshade Girdle
	[14684] = { "-ARMOR", "XMOG" }, --Indomitable Belt
	[15154] = { "-ARMOR", "XMOG" }, --Nocturnal Sash
	[9775] = { "-ARMOR", "XMOG" }, --Bandit Cinch
	[15093] = { "-ARMOR", "XMOG" }, --Runic Leather Belt
	[37762] = { "-ARMOR", "XMOG" }, --Many-Pocketed Belt
	[24749] = { "-ARMOR", "XMOG" }, --Daggerfen Belt
	[87507] = { "-ARMOR", "XMOG" }, --Melador's Mercurial Wrap
	[106604] = { "-ARMOR", "XMOG" }, --Ripfang Waistband
	[24725] = { "-ARMOR", "XMOG" }, --Dementia Cord
	[15308] = { "-ARMOR", "XMOG" }, --Feral Cord
	[55702] = { "-ARMOR", "XMOG" }, --Ravenholdt Waistband
	[36171] = { "-ARMOR", "XMOG" }, --Geist Belt
	[24798] = { "-ARMOR", "XMOG" }, --Dragonhawk Belt
	[71640] = { "-ARMOR", "XMOG" }, --Riplimb's Lost Collar
	[16827] = { "-ARMOR", "XMOG" }, --Nightslayer Belt
	[106505] = { "-ARMOR", "XMOG" }, --Steamscar Waistband
	[82264] = { "-ARMOR", "XMOG" }, --Vine Waistband
	[36131] = { "-ARMOR", "XMOG" }, --Wolverine Girdle
	[6600] = { "-ARMOR", "XMOG" }, --Dervish Belt
	[4246] = { "-ARMOR", "XMOG" }, --Fine Leather Belt
	[4249] = { "-ARMOR", "XMOG" }, --Dark Leather Belt
	[82099] = { "-ARMOR", "XMOG" }, --Mushan Hide Waistband
	[94045] = { "-ARMOR", "XMOG" }, --Discarded Swampstalker Belt
	[24709] = { "-ARMOR", "XMOG" }, --Vengeance Belt
	[36163] = { "-ARMOR", "XMOG" }, --Webspinner Cord
	[7406] = { "-ARMOR", "XMOG" }, --Infiltrator Cord
	[4257] = { "-ARMOR", "XMOG" }, --Green Leather Belt
	[36075] = { "-ARMOR", "XMOG" }, --Winterfin Cord
	[15011] = { "-ARMOR", "XMOG" }, --Lupine Cord
	[6410] = { "-ARMOR", "XMOG" }, --Insignia Bracers
	[86187] = { "-ARMOR", "XMOG" }, --Pearlescent Butterfly Wristbands
	[119333] = { "-ARMOR", "XMOG" }, --racers of Shattered Limbs
	[16710] = { "-ARMOR", "XMOG" }, --Shadowcraft Bracers
	[86843] = { "-ARMOR", "XMOG" }, --Smooth Beetle Wristbands
	[16714] = { "-ARMOR", "XMOG" }, --Wildheart Bracers
	[6583] = { "-ARMOR", "XMOG" }, --Scouting Bracers
	[77320] = { "-ARMOR", "XMOG" }, --Luminescent Bracers
	[86845] = { "-ARMOR", "XMOG" }, --Pearlescent Butterfly Wristbands
	[43264] = { "-ARMOR", "XMOG" }, --Overcast Bracers
	[10147] = { "-ARMOR", "XMOG" }, --Mighty Armsplints
	[116181] = { "-ARMOR", "XMOG" }, --Supple Bracers
	[6198] = { "-ARMOR", "XMOG" }, --Jurassic Wristguards
	[15360] = { "-ARMOR", "XMOG" }, --Trickster's Bindings
	[93568] = { "-ARMOR", "XMOG" }, --Crafted Dreadful Gladiator's Armwraps of Alacrity
	[8257] = { "-ARMOR", "XMOG" }, --Serpentskin Bracers
	[93506] = { "-ARMOR", "XMOG" }, --Crafted Dreadful Gladiator's Armwraps of Accuracy
	[46009] = { "-ARMOR", "XMOG" }, --Bindings of the Depths
	[71130] = { "-ARMOR", "XMOG" }, --Flamebinder Bracers
	[118832] = { "-ARMOR", "XMOG" }, --Wodin's Weary Wristguards
	[75106] = { "-ARMOR", "XMOG" }, --Vicious Wyrmhide Bracers
	[14561] = { "-ARMOR", "XMOG" }, --Prospector's Cuffs
	[15163] = { "-ARMOR", "XMOG" }, --Imposing Bracers
	[897] = { "-ARMOR", "XMOG" }, --Madwolf Bracers
	[12999] = { "-ARMOR", "XMOG" }, --Drakewing Bands
	[15425] = { "-ARMOR", "XMOG" }, --Peerless Bracers
	[36098] = { "-ARMOR", "XMOG" }, --Wildevar Armguards
	[15188] = { "-ARMOR", "XMOG" }, --Grand Armguards
	[4061] = { "-ARMOR", "XMOG" }, --Imperial Leather Bracers
	[93474] = { "-ARMOR", "XMOG" }, --Crafted Dreadful Gladiator's Bindings of Prowess
	[2017] = { "-ARMOR", "XMOG" }, --Glowing Leather Bracers
	[6602] = { "-ARMOR", "XMOG" }, --Dervish Bracers
	[9886] = { "-ARMOR", "XMOG" }, --Huntsman's Bands
	[7447] = { "-ARMOR", "XMOG" }, --Sentinel Bracers
	[15436] = { "-ARMOR", "XMOG" }, --Supreme Bracers
	[87522] = { "-ARMOR", "XMOG" }, --Star-Carrier Bracers
	[6556] = { "-ARMOR", "XMOG" }, --Bard's Bracers
	[15172] = { "-ARMOR", "XMOG" }, --Potent Bands
	[24772] = { "-ARMOR", "XMOG" }, --Clefthoof Bracers
	[15387] = { "-ARMOR", "XMOG" }, --Jadefire Bracelets
	[24764] = { "-ARMOR", "XMOG" }, --Umbrafen Bindings
	[7410] = { "-ARMOR", "XMOG" }, --Infiltrator Bracers
	[9925] = { "-ARMOR", "XMOG" }, --Tracker's Wristguards
	[44696] = { "-ARMOR", "XMOG" }, --Giant's Toewrap
	[24724] = { "-ARMOR", "XMOG" }, --Dreghood Bands
	[7534] = { "-ARMOR", "XMOG" }, --Cabalist Bracers
	[10107] = { "-ARMOR", "XMOG" }, --Wanderer's Bracers
	[15160] = { "-ARMOR", "XMOG" }, --Nocturnal Wristbands
	[9949] = { "-ARMOR", "XMOG" }, --Chieftain's Bracers
	[10069] = { "-ARMOR", "XMOG" }, --Righteous Bracers
	[16830] = { "-ARMOR", "XMOG" }, --Cenarion Bracers
	[24716] = { "-ARMOR", "XMOG" }, --Vengeance Bands
	[38433] = { "-ARMOR", "XMOG" }, --Arctic Wristguards
	[106597] = { "-ARMOR", "XMOG" }, --Ripfang Bindings
	[37366] = { "-ARMOR", "XMOG" }, --Drake-Champion's Bracers
	[106465] = { "-ARMOR", "XMOG" }, --Tailthrasher Bindings
	[13119] = { "-ARMOR", "XMOG" }, --Enchanted Kodo Bracers
	[13120] = { "-ARMOR", "XMOG" }, --Deepfury Bracers
	[39283] = { "-ARMOR", "XMOG" }, --Putrescent Bands
	[36154] = { "-ARMOR", "XMOG" }, --Pygmy Bindings
	[36130] = { "-ARMOR", "XMOG" }, --Muradin Bindings
	[106696] = { "-ARMOR", "XMOG" }, --Sabermaw Bindings
	[24780] = { "-ARMOR", "XMOG" }, --Boneshredder Wristguards
	[4049] = { "-ARMOR", "XMOG" }, --Emblazoned Bracers
	[24748] = { "-ARMOR", "XMOG" }, --Ranger Armguards
	[7484] = { "-ARMOR", "XMOG" }, --Ranger Wristguards
	[36146] = { "-ARMOR", "XMOG" }, --Ghrino Bracers
	[87517] = { "-ARMOR", "XMOG" }, --Bracers of Rolling Fields
	[94051] = { "-ARMOR", "XMOG" }, --Discarded Swampstalker Wrists
	[71341] = { "-ARMOR", "XMOG" }, --Glowing Wing Bracers
	[106531] = { "-ARMOR", "XMOG" }, --Daggerjaw Bindings
	[24732] = { "-ARMOR", "XMOG" }, --Dementia Armguards
	[9829] = { "-ARMOR", "XMOG" }, --Scaled Leather Bracers
	[66954] = { "-ARMOR", "XMOG" }, --Knife-Concealing Bracers
	[37766] = { "-ARMOR", "XMOG" }, --Bracers of Unmitigated Larceny
	[36114] = { "-ARMOR", "XMOG" }, --Vileprey Bracers
	[82257] = { "-ARMOR", "XMOG" }, --Vine Bindings
	[8295] = { "-ARMOR", "XMOG" }, --Traveler's Bracers
	[10184] = { "-ARMOR", "XMOG" }, --Swashbuckler's Bracers
	[55637] = { "-ARMOR", "XMOG" }, --Dandred Bindings
	[35579] = { "-ARMOR", "XMOG" }, --Vrykul Shackles
	[31175] = { "-ARMOR", "XMOG" }, --Blade Dancer's Wristguards
	[10256] = { "-ARMOR", "XMOG" }, --Adventurer's Bracers
	[36090] = { "-ARMOR", "XMOG" }, --Riplash Wristguards
	[67127] = { "-ARMOR", "XMOG" }, --Bracers of Caustic Purification
	[82092] = { "-ARMOR", "XMOG" }, --Mushan Hide Bindings
	[24789] = { "-ARMOR", "XMOG" }, --Murkblood Bracers
	[24805] = { "-ARMOR", "XMOG" }, --Dragonhawk Bands
	[24700] = { "-ARMOR", "XMOG" }, --Bonechewer Bands
	[37000] = { "-ARMOR", "XMOG" }, --Storming Vortex Bracers
	[36170] = { "-ARMOR", "XMOG" }, --Webspinner Bindings
	[37771] = { "-ARMOR", "XMOG" }, --Wristguards of Verdant Recovery
	[36178] = { "-ARMOR", "XMOG" }, --Geist Wristguards
	[119346] = { "-ARMOR", "XMOG" }, --Kyu-Sy's Tarflame Doomcloak
	[119347] = { "-ARMOR", "XMOG" }, --Gill's Glorious Windcloak
	[118810] = { "-ARMOR", "XMOG" }, --Rinnila's Regal Cloak
	[119344] = { "-ARMOR", "XMOG" }, --Magic-Breaker Cape
	[118812] = { "-ARMOR", "XMOG" }, --Flamelicked Cloak of Kaufebyrd
	[119345] = { "-ARMOR", "XMOG" }, --Milenah's Intricate Cloak
	[43566] = { "-ARMOR", "XMOG" }, --Ice Striker's Cloak
	[116174] = { "-ARMOR", "XMOG" }, --Nimble Burnished Cloak
	[44687] = { "-ARMOR", "XMOG" }, --Loque'Nahak's Pelt
	[118814] = { "-ARMOR", "XMOG" }, --Berserker's Windwrap
	[45704] = { "-ARMOR", "XMOG" }, --Shawl of the Shattered Giant
	[24260] = { "-ARMOR", "XMOG" }, --Manaweave Cloak
	[114818] = { "-ARMOR", "XMOG" }, --Nimble Hexweave Cloak
	[9938] = { "-ARMOR", "XMOG" }, --Abjurer's Cloak
	[10108] = { "-ARMOR", "XMOG" }, --Wanderer's Cloak
	[12253] = { "-ARMOR", "XMOG" }, --Brilliant Red Cloak
	[45810] = { "-ARMOR", "XMOG" }, --Cloak of Crimson Snow
	[5181] = { "-ARMOR", "XMOG" }, --Vibrant Silk Cape
	[10185] = { "-ARMOR", "XMOG" }, --Swashbuckler's Cape
	[15333] = { "-ARMOR", "XMOG" }, --Wrangler's Cloak
	[15568] = { "-ARMOR", "XMOG" }, --Marauder's Cloak
	[68759] = { "-ARMOR", "XMOG" }, --Imbued Gypsy Cloak
	[9812] = { "-ARMOR", "XMOG" }, --Fortified Cloak
	[14261] = { "-ARMOR", "XMOG" }, --Bloodwoven Cloak
	[14593] = { "-ARMOR", "XMOG" }, --Hawkeye's Cloak
	[4798] = { "-ARMOR", "XMOG" }, --Heavy Runed Cloak
	[4799] = { "-ARMOR", "XMOG" }, --Antiquated Cloak
	[6432] = { "-ARMOR", "XMOG" }, --Imperial Cloak
	[9867] = { "-ARMOR", "XMOG" }, --Renegade Cloak
	[32541] = { "-ARMOR", "XMOG" }, --Terokk's Wisdom
	[4716] = { "-ARMOR", "XMOG" }, --Combat Cloak
	[87429] = { "-ARMOR", "XMOG" }, --Drape of Flowing Gauze
	[4735] = { "-ARMOR", "XMOG" }, --Mistscape Cloak
	[14459] = { "-ARMOR", "XMOG" }, --Elunarian Cloak
	[1930] = { "-ARMOR", "XMOG" }, --Stonemason Cloak
	[116723] = { "-ARMOR", "XMOG" }, --Oshu'gun Cloak
	[14745] = { "-ARMOR", "XMOG" }, --Hulking Cloak
	[14801] = { "-ARMOR", "XMOG" }, --Bloodlust Cape
	[56480] = { "-ARMOR", "XMOG" }, --Savage Cloak
	[87427] = { "-ARMOR", "XMOG" }, --Blade-Dulling Greatcloak
	[116708] = { "-ARMOR", "XMOG" }, --Soulkeeper Cloak
	[15643] = { "-ARMOR", "XMOG" }, --Ironhide Cloak
	[4726] = { "-ARMOR", "XMOG" }, --Chief Brigadier Cloak
	[45811] = { "-ARMOR", "XMOG" }, --Frostguard Drape
	[78340] = { "-ARMOR", "XMOG" }, --Cloak of the Darkmoon Faire
	[13007] = { "-ARMOR", "XMOG" }, --Mageflame Cloak
	[116693] = { "-ARMOR", "XMOG" }, --Coldsinger Cloak
	[24254] = { "-ARMOR", "XMOG" }, --White Remedy Cape
	[18339] = { "-ARMOR", "XMOG" }, --Eidolon Cloak
	[67131] = { "-ARMOR", "XMOG" }, --Ritssyn's Ruminous Drape
	[10098] = { "-ARMOR", "XMOG" }, --Councillor's Cloak
	[87428] = { "-ARMOR", "XMOG" }, --Aquino's Cloak of Unity
	[25034] = { "-ARMOR", "XMOG" }, --Elementalist Cloak
	[36416] = { "-ARMOR", "XMOG" }, --Regal Cloak
	[98772] = { "-ARMOR", "XMOG" }, --Crafted Malevolent Gladiator's Drape of Cruelty
	[3018] = { "-ARMOR", "XMOG" }, --Hide of Lupos
	[9919] = { "-ARMOR", "XMOG" }, --Tracker's Cloak
	[15632] = { "-ARMOR", "XMOG" }, --Formidable Cape
	[45322] = { "-ARMOR", "XMOG" }, --Cloak of the Iron Council
	[98914] = { "-ARMOR", "XMOG" }, --Crafted Malevolent Gladiator's Cloak of Prowess
	[98756] = { "-ARMOR", "XMOG" }, --Crafted Malevolent Gladiator's Cape of Cruelty
	[7460] = { "-ARMOR", "XMOG" }, --Knight's Cloak
	[85853] = { "-ARMOR", "XMOG" }, --Stormscale Drape
	[118811] = { "-ARMOR", "XMOG" }, --Embroidered Wolfsfur Cloak
	[20693] = { "-ARMOR", "XMOG" }, --Weighted Cloak
	[7474] = { "-ARMOR", "XMOG" }, --Regal Cloak
	[68762] = { "-ARMOR", "XMOG" }, --Imbued Cadet Cloak
	[93420] = { "-ARMOR", "XMOG" }, --Crafted Dreadful Gladiator's Cape of Cruelty
	[116702] = { "-ARMOR", "XMOG" }, --Evermorn Cloak
	[93439] = { "-ARMOR", "XMOG" }, --Crafted Dreadful Gladiator's Drape of Meditation
	[32540] = { "-ARMOR", "XMOG" }, --Terokk's Might
	[93608] = { "-ARMOR", "XMOG" }, --Crafted Dreadful Gladiator's Cloak of Prowess
	[76160] = { "-ARMOR", "XMOG" }, --Drapes of the Dragonshrine
	[14430] = { "-ARMOR", "XMOG" }, --Windchaser Cloak
	[36403] = { "-ARMOR", "XMOG" }, --Riding Cloak
	[5969] = { "-ARMOR", "XMOG" }, --Regent's Cloak
	[10060] = { "-ARMOR", "XMOG" }, --Duskwoven Cape
	[14280] = { "-ARMOR", "XMOG" }, --Opulent Cape
	[15183] = { "-ARMOR", "XMOG" }, --Praetorian Cloak
	[15526] = { "-ARMOR", "XMOG" }, --Sentry's Cape
	[14813] = { "-ARMOR", "XMOG" }, --Warstrike Cape
	[14665] = { "-ARMOR", "XMOG" }, --Keeper's Cloak
	[15594] = { "-ARMOR", "XMOG" }, --Steadfast Cloak
	[24253] = { "-ARMOR", "XMOG" }, --Cloak of Eternity
	[67134] = { "-ARMOR", "XMOG" }, --Dory's Finery
	[15392] = { "-ARMOR", "XMOG" }, --Jadefire Cloak
	[15437] = { "-ARMOR", "XMOG" }, --Supreme Cape
	[41607] = { "-ARMOR", "XMOG" }, --Cloak of the Moon
	[6417] = { "-ARMOR", "XMOG" }, --Aurora Cloak
	[14724] = { "-ARMOR", "XMOG" }, --War Paint Cloak
	[115348] = { "-ARMOR", "XMOG" }, --Feathered Cape
	[15579] = { "-ARMOR", "XMOG" }, --Sparkleshell Cloak
	[25030] = { "-ARMOR", "XMOG" }, --Silky Velvet Cloak
	[90578] = { "-ARMOR", "XMOG" }, --Zom's Rain-Stained Cloak
	[25039] = { "-ARMOR", "XMOG" }, --Farseer Cloak
	[10231] = { "-ARMOR", "XMOG" }, --Engraved Cape
	[8216] = { "-ARMOR", "XMOG" }, --Big Voodoo Cloak
	[1190] = { "-ARMOR", "XMOG" }, --Overseer's Cloak
	[116720] = { "-ARMOR", "XMOG" }, --Ancestral Cloak
	[118807] = { "-ARMOR", "XMOG" }, --Dunewalker Wrap
	[14440] = { "-ARMOR", "XMOG" }, --Venomshroud Cape
	[116705] = { "-ARMOR", "XMOG" }, --Zangarra Cloak
	[15519] = { "-ARMOR", "XMOG" }, --Spiked Chain Cloak
	[31255] = { "-ARMOR", "XMOG" }, --Cloak of the Craft
	[66883] = { "-ARMOR", "XMOG" }, --Vertigo Cloak
	[14673] = { "-ARMOR", "XMOG" }, --Pridelord Cape
	[10079] = { "-ARMOR", "XMOG" }, --Lord's Cape
	[116714] = { "-ARMOR", "XMOG" }, --Shadowsage Cloak
	[8127] = { "-ARMOR", "XMOG" }, --Myrmidon's Cape
	[9898] = { "-ARMOR", "XMOG" }, --Jazeraint Cloak
	[68743] = { "-ARMOR", "XMOG" }, --Imbued Infantry Cloak
	[5751] = { "-ARMOR", "XMOG" }, --Webwing Cloak
	[14229] = { "-ARMOR", "XMOG" }, --Embersilk Cloak
	[15165] = { "-ARMOR", "XMOG" }, --Imposing Cape
	[4732] = { "-ARMOR", "XMOG" }, --Glyphed Cloak
	[4447] = { "-ARMOR", "XMOG" }, --Cloak of Night
	[15501] = { "-ARMOR", "XMOG" }, --Outrunner's Cloak
	[14602] = { "-ARMOR", "XMOG" }, --Warden's Cloak
	[14321] = { "-ARMOR", "XMOG" }, --Resplendent Cloak
	[4713] = { "-ARMOR", "XMOG" }, --Silver-Thread Cloak
	[116711] = { "-ARMOR", "XMOG" }, --Sunsworn Cloak
	[90580] = { "-ARMOR", "XMOG" }, --Cristof's Crushing Cloak
	[12979] = { "-ARMOR", "XMOG" }, --Firebane Cloak
	[87431] = { "-ARMOR", "XMOG" }, --Roffle's Flowing Raiment
	[5965] = { "-ARMOR", "XMOG" }, --Guardian Cloak
	[10194] = { "-ARMOR", "XMOG" }, --Crusader's Cloak
	[8304] = { "-ARMOR", "XMOG" }, --Hero's Cape
	[8266] = { "-ARMOR", "XMOG" }, --Ebonhold Cloak
	[90589] = { "-ARMOR", "XMOG" }, --Dirl's Drafty Drape
	[15147] = { "-ARMOR", "XMOG" }, --Ghostwalker Cloak
	[7436] = { "-ARMOR", "XMOG" }, --Twilight Cape
	[15508] = { "-ARMOR", "XMOG" }, --Grunt's Cape
	[6424] = { "-ARMOR", "XMOG" }, --Blackforge Cape
	[36413] = { "-ARMOR", "XMOG" }, --Dyed Taffeta Cape
	[37797] = { "-ARMOR", "XMOG" }, --Cloak of the Agile Mind
	[37756] = { "-ARMOR", "XMOG" }, --Zoe's Comforting Cape
	[10159] = { "-ARMOR", "XMOG" }, --Mercurial Cloak
	[25032] = { "-ARMOR", "XMOG" }, --Hellfire Cloak
	[15135] = { "-ARMOR", "XMOG" }, --Cutthroat's Cape
	[55314] = { "-ARMOR", "XMOG" }, --Thondroril Cloak
	[2284] = { "-ARMOR", "XMOG" }, --Rat Cloth Cloak
	[7053] = { "-ARMOR", "XMOG" }, --Azure Silk Cloak
	[10249] = { "-ARMOR", "XMOG" }, --Master's Cloak
	[10258] = { "-ARMOR", "XMOG" }, --Adventurer's Cape
	[25037] = { "-ARMOR", "XMOG" }, --Patched Cape
	[14103] = { "-ARMOR", "XMOG" }, --Brightcloth Cloak
	[25031] = { "-ARMOR", "XMOG" }, --Silvermoon Royal Cloak
	[4719] = { "-ARMOR", "XMOG" }, --Nightsky Cloak
	[36411] = { "-ARMOR", "XMOG" }, --Brawler's Cape
	[36415] = { "-ARMOR", "XMOG" }, --Vintage Satin Cloak
	[66991] = { "-ARMOR", "XMOG" }, --Cloak of Rich Anger
	[69800] = { "-ARMOR", "XMOG" }, --Spiritguard Drape
	[10138] = { "-ARMOR", "XMOG" }, --High Councillor's Cloak
	[45493] = { "-ARMOR", "XMOG" }, --Asimov's Drape
	[10174] = { "-ARMOR", "XMOG" }, --Mystical Cape
	[6179] = { "-ARMOR", "XMOG" }, --Privateer's Cape
	[7419] = { "-ARMOR", "XMOG" }, --Phalanx Cloak
	[8259] = { "-ARMOR", "XMOG" }, --Serpentskin Cloak
	[10071] = { "-ARMOR", "XMOG" }, --Righteous Cloak
	[7377] = { "-ARMOR", "XMOG" }, --Frost Leather Cloak
	[67119] = { "-ARMOR", "XMOG" }, --Thousand Bandage Drape
	[116699] = { "-ARMOR", "XMOG" }, --Growthshaper Cloak
	[15364] = { "-ARMOR", "XMOG" }, --Trickster's Cloak
	[67140] = { "-ARMOR", "XMOG" }, --Drape of Inimitable Fate
	[36410] = { "-ARMOR", "XMOG" }, --Caribou Skin Cloak
	[13005] = { "-ARMOR", "XMOG" }, --Amy's Blanket
	[7533] = { "-ARMOR", "XMOG" }, --Cabalist Cloak
	[5542] = { "-ARMOR", "XMOG" }, --Pearl-Clasped Cloak
	[55311] = { "-ARMOR", "XMOG" }, --Mirkfallon Cloak
	[66965] = { "-ARMOR", "XMOG" }, --Drape of Fiery Dreams
	[8286] = { "-ARMOR", "XMOG" }, --Arcane Cloak
	[9860] = { "-ARMOR", "XMOG" }, --Archer's Cloak
	[36414] = { "-ARMOR", "XMOG" }, --Mammoth Fur Cloak
	[82171] = { "-ARMOR", "XMOG" }, --Grummle Cloak
	[14210] = { "-ARMOR", "XMOG" }, --Vital Cape
	[7544] = { "-ARMOR", "XMOG" }, --Champion's Cape
	[10224] = { "-ARMOR", "XMOG" }, --Nightshade Cloak
	[2316] = { "-ARMOR", "XMOG" }, --Dark Leather Cloak
	[6575] = { "-ARMOR", "XMOG" }, --Defender Cloak
	[31140] = { "-ARMOR", "XMOG" }, --Cloak of Entropy
	[2059] = { "-ARMOR", "XMOG" }, --Sentry Cloak
	[10212] = { "-ARMOR", "XMOG" }, --Elegant Cloak
	[15309] = { "-ARMOR", "XMOG" }, --Feral Cloak
	[36408] = { "-ARMOR", "XMOG" }, --Reversible Wool Cape
	[13108] = { "-ARMOR", "XMOG" }, --Tigerstrike Mantle
	[36407] = { "-ARMOR", "XMOG" }, --Lace-Trimmed Cloak
	[14376] = { "-ARMOR", "XMOG" }, --Sanguine Cape
	[25041] = { "-ARMOR", "XMOG" }, --Ambusher's Cloak
	[10148] = { "-ARMOR", "XMOG" }, --Mighty Cloak
	[14563] = { "-ARMOR", "XMOG" }, --Prospector's Cloak
	[14167] = { "-ARMOR", "XMOG" }, --Buccaneer's Cape
	[7356] = { "-ARMOR", "XMOG" }, --Elder's Cloak
	[13121] = { "-ARMOR", "XMOG" }, --Wing of the Whelpling
	[4715] = { "-ARMOR", "XMOG" }, --Emblazoned Cloak
	[4326] = { "-ARMOR", "XMOG" }, --Long Silken Cloak
	[37796] = { "-ARMOR", "XMOG" }, --Earthbound Cape
	[6585] = { "-ARMOR", "XMOG" }, --Scouting Cloak
	[9786] = { "-ARMOR", "XMOG" }, --Raider's Cloak
	[4706] = { "-ARMOR", "XMOG" }, --Lambent Scale Cloak
	[4695] = { "-ARMOR", "XMOG" }, --Burnished Cloak
	[2580] = { "-ARMOR", "XMOG" }, --Reinforced Linen Cape
	[6564] = { "-ARMOR", "XMOG" }, --Shimmering Cloak
	[9838] = { "-ARMOR", "XMOG" }, --Banded Cloak
	[14161] = { "-ARMOR", "XMOG" }, --Pagan Cape
	[25042] = { "-ARMOR", "XMOG" }, --Nether Cloak
	[9779] = { "-ARMOR", "XMOG" }, --Bandit Cloak
	[2308] = { "-ARMOR", "XMOG" }, --Fine Leather Cloak
	[8297] = { "-ARMOR", "XMOG" }, --Traveler's Cloak
	[7446] = { "-ARMOR", "XMOG" }, --Sentinel Cloak
	[4710] = { "-ARMOR", "XMOG" }, --Forest Cloak
	[6614] = { "-ARMOR", "XMOG" }, --Sage's Cloak
	[14288] = { "-ARMOR", "XMOG" }, --Arachnidian Armor
	[14328] = { "-ARMOR", "XMOG" }, --Eternal Chestguard
	[14175] = { "-ARMOR", "XMOG" }, --Buccaneer's Vest
	[14277] = { "-ARMOR", "XMOG" }, --Gaea's Tunic
	[14190] = { "-ARMOR", "XMOG" }, --Raincaller Vest
	[14417] = { "-ARMOR", "XMOG" }, --Silksand Tunic
	[14230] = { "-ARMOR", "XMOG" }, --Embersilk Tunic
	[14398] = { "-ARMOR", "XMOG" }, --Resilient Tunic
	[14372] = { "-ARMOR", "XMOG" }, --Sanguine Armor
	[14133] = { "-ARMOR", "XMOG" }, --Ritual Tunic
	[14427] = { "-ARMOR", "XMOG" }, --Windchaser Wraps
	[14398] = { "-ARMOR", "XMOG" }, --Resilient Tunic
	[21865] = { "-ARMOR", "XMOG" }, --Soulcloth Vest
	[14455] = { "-ARMOR", "XMOG" }, --Highborne Padded Armor
	[14407] = { "-ARMOR", "XMOG" }, --Stonecloth Vest
	[7110] = { "-ARMOR", "XMOG" }, --Silver-Thread Armor
	[14267] = { "-ARMOR", "XMOG" }, --Bloodwoven Jerkin
	[21862] = { "-ARMOR", "XMOG" }, --Imbued Netherweave Tunic
	[14318] = { "-ARMOR", "XMOG" }, --Resplendent Tunic
	[1486] = { "-ARMOR", "XMOG" }, --Tree Bark Jacket
	[14456] = { "-ARMOR", "XMOG" }, --Elunarian Vest
	[7111] = { "-ARMOR", "XMOG" }, --Nightsky Armor
	[14215] = { "-ARMOR", "XMOG" }, --Vital Tunic
	[10021] = { "-ARMOR", "XMOG" }, --Dreamweave Vest
	[14216] = { "-ARMOR", "XMOG" }, --Geomancer's Jerkin
	[7112] = { "-ARMOR", "XMOG" }, --Aurora Armor
	[9874] = { "-ARMOR", "XMOG" }, --Sorcerer Drape
	[2234] = { "-ARMOR", "XMOG" }, --Nightwalker Armor
	[6561] = { "-ARMOR", "XMOG" }, --Seer's Padded Armor
	[8283] = { "-ARMOR", "XMOG" }, --Arcane Armor
	[14138] = { "-ARMOR", "XMOG" }, --Mooncloth Vest
	[10218] = { "-ARMOR", "XMOG" }, --Elegant Tunic
	[10553] = { "-ARMOR", "XMOG" }, --Foreman Vest
	[3310] = { "-ARMOR", "XMOG" }, --Barbaric Cloth Vest
	[9749] = { "-ARMOR", "XMOG" }, --Simple Blouse
	[14202] = { "-ARMOR", "XMOG" }, --Thistlefur Jerkin
	[7113] = { "-ARMOR", "XMOG" }, --Mistscape Armor
	[14121] = { "-ARMOR", "XMOG" }, --Aboriginal Vest
	[6609] = { "-ARMOR", "XMOG" }, --Sage's Cloth
	[82423] = { "-ARMOR", "XMOG" }, --Contender's Silk Raiment
	[14369] = { "-ARMOR", "XMOG" }, --Mystic's Wrap
	[3292] = { "-ARMOR", "XMOG" }, --Ancestral Tunic
	[7332] = { "-ARMOR", "XMOG" }, --Regal Armor
	[14042] = { "-ARMOR", "XMOG" }, --Cindercloth Vest
	[8245] = { "-ARMOR", "XMOG" }, --Imperial Red Tunic
	[14141] = { "-ARMOR", "XMOG" }, --Ghostweave Vest
	[7429] = { "-ARMOR", "XMOG" }, --Twilight Armor
	[14308] = { "-ARMOR", "XMOG" }, --Celestial Tunic
	[6567] = { "-ARMOR", "XMOG" }, --Shimmering Armor
	[10135] = { "-ARMOR", "XMOG" }, --High Councillor's Tunic
	[14237] = { "-ARMOR", "XMOG" }, --Darkmist Armor
	[2957] = { "-ARMOR", "XMOG" }, --Journeyman's Vest
	[14306] = { "-ARMOR", "XMOG" }, --Bonecaster's Vest
	[10181] = { "-ARMOR", "XMOG" }, --Mystical Armor
	[10057] = { "-ARMOR", "XMOG" }, --Duskwoven Tunic
	[7517] = { "-ARMOR", "XMOG" }, --Gossamer Tunic
	[82399] = { "-ARMOR", "XMOG" }, --Windwool Tunic
	[10104] = { "-ARMOR", "XMOG" }, --Councillor's Tunic
	[9905] = { "-ARMOR", "XMOG" }, --Royal Blouse
	[10007] = { "-ARMOR", "XMOG" }, --Red Mageweave Vest
	[24607] = { "-ARMOR", "XMOG" }, --Laughing Skull Tunic
	[24639] = { "-ARMOR", "XMOG" }, --Mistyreed Tunic
	[9844] = { "-ARMOR", "XMOG" }, --Conjurer's Vest
	[6240] = { "-ARMOR", "XMOG" }, --Blue Linen Vest
	[21855] = { "-ARMOR", "XMOG" }, --Netherweave Tunic
	[13869] = { "-ARMOR", "XMOG" }, --Frostweave Tunic
	[7065] = { "-ARMOR", "XMOG" }, --Green Silk Armor
	[9434] = { "-ARMOR", "XMOG" }, --Elemental Raiment
	[13857] = { "-ARMOR", "XMOG" }, --Runecloth Tunic
	[6239] = { "-ARMOR", "XMOG" }, --Red Linen Vest
	[24687] = { "-ARMOR", "XMOG" }, --Elementalist Tunic
	[4324] = { "-ARMOR", "XMOG" }, --Azure Silk Vest
	[9998] = { "-ARMOR", "XMOG" }, --Black Mageweave Vest
	[24631] = { "-ARMOR", "XMOG" }, --Feralfen Jerkin
	[7051] = { "-ARMOR", "XMOG" }, --Earthen Vest
	[6266] = { "-ARMOR", "XMOG" }, --Disciple's Vest
	[6536] = { "-ARMOR", "XMOG" }, --Willow Vest
	[24615] = { "-ARMOR", "XMOG" }, --Vindicator Tunic
	[7058] = { "-ARMOR", "XMOG" }, --Crimson Silk Vest
	[24591] = { "-ARMOR", "XMOG" }, --Fireheart Chestpiece
	[24663] = { "-ARMOR", "XMOG" }, --Shadow Council Tunic
	[2582] = { "-ARMOR", "XMOG" }, --Green Woolen Vest
	[2578] = { "-ARMOR", "XMOG" }, --Barbaric Linen Vest
	[14094] = { "-ARMOR", "XMOG" }, --Beaded Wraps
	[9791] = { "-ARMOR", "XMOG" }, --Ivycloth Tunic
	[24671] = { "-ARMOR", "XMOG" }, --Eldr'naan Jerkin
	[10578] = { "-ARMOR", "XMOG" }, --Thoughtcast Boots
	[14310] = { "-ARMOR", "XMOG" }, --Celestial Slippers
	[119342] = { "-ARMOR", "XMOG" }, --Furnace Stoker's Footwraps
	[14290] = { "-ARMOR", "XMOG" }, --Arachnidian Footpads
	[114815] = { "-ARMOR", "XMOG" }, --Hexweave Slippers
	[14214] = { "-ARMOR", "XMOG" }, --Vital Boots
	[21870] = { "-ARMOR", "XMOG" }, --Frozen Shadoweave Boots
	[77177] = { "-ARMOR", "XMOG" }, --Splinterfoot Sandals
	[45567] = { "-ARMOR", "XMOG" }, --Savior's Slippers
	[45566] = { "-ARMOR", "XMOG" }, --Spellslinger's Slippers
	[42096] = { "-ARMOR", "XMOG" }, --Aurora Slippers
	[4320] = { "-ARMOR", "XMOG" }, --Spidersilk Boots
	[43585] = { "-ARMOR", "XMOG" }, --Glacial Slippers
	[14299] = { "-ARMOR", "XMOG" }, --Bonecaster's Boots
	[98768] = { "-ARMOR", "XMOG" }, --Crafted Malevolent Gladiator's Treads of Meditation
	[98767] = { "-ARMOR", "XMOG" }, --Crafted Malevolent Gladiator's Treads of Alacrity
	[14196] = { "-ARMOR", "XMOG" }, --Thistlefur Sandals
	[1560] = { "-ARMOR", "XMOG" }, --Bluegill Sandals
	[3076] = { "-ARMOR", "XMOG" }, --Smoldering Boots
	[14236] = { "-ARMOR", "XMOG" }, --Embersilk Boots
	[14285] = { "-ARMOR", "XMOG" }, --Opulent Boots
	[14364] = { "-ARMOR", "XMOG" }, --Mystic's Slippers
	[14408] = { "-ARMOR", "XMOG" }, --Stonecloth Boots
	[6394] = { "-ARMOR", "XMOG" }, --Silver-Thread Boots
	[98766] = { "-ARMOR", "XMOG" }, --Crafted Malevolent Gladiator's Treads of Cruelty
	[14319] = { "-ARMOR", "XMOG" }, --Resplendent Boots
	[4321] = { "-ARMOR", "XMOG" }, --Spider Silk Slippers
	[14418] = { "-ARMOR", "XMOG" }, --Silksand Boots
	[75095] = { "-ARMOR", "XMOG" }, --Vicious Embersilk Boots
	[14399] = { "-ARMOR", "XMOG" }, --Resilient Boots
	[75087] = { "-ARMOR", "XMOG" }, --Vicious Fireweave Boots
	[106412] = { "-ARMOR", "XMOG" }, --Lunarglow Sandals
	[43970] = { "-ARMOR", "XMOG" }, --Frostsavage Boots
	[14269] = { "-ARMOR", "XMOG" }, --Gaea's Slippers
	[9845] = { "-ARMOR", "XMOG" }, --Conjurer's Shoes
	[14329] = { "-ARMOR", "XMOG" }, --Eternal Boots
	[118818] = { "-ARMOR", "XMOG" }, --Kymi's Stylish Slippers
	[4047] = { "-ARMOR", "XMOG" }, --Mistscape Boots
	[14259] = { "-ARMOR", "XMOG" }, --Bloodwoven Boots
	[14428] = { "-ARMOR", "XMOG" }, --Windchaser Footpads
	[14114] = { "-ARMOR", "XMOG" }, --Aboriginal Footwraps
	[9876] = { "-ARMOR", "XMOG" }, --Sorcerer Slippers
	[14174] = { "-ARMOR", "XMOG" }, --Buccaneer's Boots
	[13099] = { "-ARMOR", "XMOG" }, --Moccasins of the White Hare
	[87434] = { "-ARMOR", "XMOG" }, --Sandals of Sympathetic Healing
	[10179] = { "-ARMOR", "XMOG" }, --Mystical Boots
	[106643] = { "-ARMOR", "XMOG" }, --Sunscryer Sandals
	[10031] = { "-ARMOR", "XMOG" }, --Shadoweave Boots
	[68754] = { "-ARMOR", "XMOG" }, --Imbued Disciple's Boots
	[9767] = { "-ARMOR", "XMOG" }, --Greenweave Sandals
	[8284] = { "-ARMOR", "XMOG" }, --Arcane Boots
	[10137] = { "-ARMOR", "XMOG" }, --High Councillor's Boots
	[6612] = { "-ARMOR", "XMOG" }, --Sage's Boots
	[7434] = { "-ARMOR", "XMOG" }, --Twilight Boots
	[8246] = { "-ARMOR", "XMOG" }, --Imperial Red Boots
	[6537] = { "-ARMOR", "XMOG" }, --Willow Boots
	[3307] = { "-ARMOR", "XMOG" }, --Barbaric Cloth Boots
	[7472] = { "-ARMOR", "XMOG" }, --Regal Boots
	[9792] = { "-ARMOR", "XMOG" }, --Ivycloth Boots
	[54477] = { "-ARMOR", "XMOG" }, --Deathsilk Boots
	[40558] = { "-ARMOR", "XMOG" }, --Arcanic Tramplers
	[24590] = { "-ARMOR", "XMOG" }, --Fireheart Boots
	[24662] = { "-ARMOR", "XMOG" }, --Shadow Council Boots
	[13100] = { "-ARMOR", "XMOG" }, --Furen's Boots
	[37752] = { "-ARMOR", "XMOG" }, --Sandals of Broken Dreams
	[9936] = { "-ARMOR", "XMOG" }, --Abjurer's Boots
	[82403] = { "-ARMOR", "XMOG" }, --Windwool Boots
	[106610] = { "-ARMOR", "XMOG" }, --Ravendown Sandals
	[10095] = { "-ARMOR", "XMOG" }, --Councillor's Boots
	[4325] = { "-ARMOR", "XMOG" }, --Boots of the Enchanter
	[10211] = { "-ARMOR", "XMOG" }, --Elegant Boots
	[71023] = { "-ARMOR", "XMOG" }, --Coalwalker Sandals
	[24638] = { "-ARMOR", "XMOG" }, --Mistyreed Boots
	[10058] = { "-ARMOR", "XMOG" }, --Duskwoven Sandals
	[24646] = { "-ARMOR", "XMOG" }, --Astralaan Boots
	[54482] = { "-ARMOR", "XMOG" }, --Spiritmend Boots
	[2583] = { "-ARMOR", "XMOG" }, --Woolen Boots
	[13864] = { "-ARMOR", "XMOG" }, --Runecloth Boots
	[106544] = { "-ARMOR", "XMOG" }, --Orunai Sandals
	[82034] = { "-ARMOR", "XMOG" }, --Reed Sandals
	[36044] = { "-ARMOR", "XMOG" }, --Crystalsong Slippers
	[67113] = { "-ARMOR", "XMOG" }, --Medic's Bloodstained Sandals
	[40246] = { "-ARMOR", "XMOG" }, --Boots of Impetuous Ideals
	[4313] = { "-ARMOR", "XMOG" }, --Red Woolen Boots
	[14458] = { "-ARMOR", "XMOG" }, --Elunarian Boots
	[36036] = { "-ARMOR", "XMOG" }, --Condor Sandals
	[106709] = { "-ARMOR", "XMOG" }, --Voidwrap Sandals
	[106511] = { "-ARMOR", "XMOG" }, --Mandragoran Sandals
	[10044] = { "-ARMOR", "XMOG" }, --Cindercloth Boots
	[31230] = { "-ARMOR", "XMOG" }, --Abyss Walker's Boots
	[6416] = { "-ARMOR", "XMOG" }, --Aurora Boots
	[82199] = { "-ARMOR", "XMOG" }, --Trellised Sandals
	[35964] = { "-ARMOR", "XMOG" }, --Bloodspore Sandals
	[13101] = { "-ARMOR", "XMOG" }, --Wolfrunner Shoes
	[2569] = { "-ARMOR", "XMOG" }, --Linen Boots
	[4312] = { "-ARMOR", "XMOG" }, --Soft-Soled Linen Boots
	[55724] = { "-ARMOR", "XMOG" }, --Baradin Sandals
	[24582] = { "-ARMOR", "XMOG" }, --Outlander's Boots
	[21853] = { "-ARMOR", "XMOG" }, --Netherweave Boots
	[14238] = { "-ARMOR", "XMOG" }, --Darkmist Boots
	[24670] = { "-ARMOR", "XMOG" }, --Eldr'naan Boots
	[36004] = { "-ARMOR", "XMOG" }, --Icemist Slippers
	[41520] = { "-ARMOR", "XMOG" }, --Frostwoven Boots
	[24630] = { "-ARMOR", "XMOG" }, --Feralfen Sandals
	[24686] = { "-ARMOR", "XMOG" }, --Elementalist Boots
	[24622] = { "-ARMOR", "XMOG" }, --Slavehandler Footpads
	[24598] = { "-ARMOR", "XMOG" }, --Starfire Sandals
	[24614] = { "-ARMOR", "XMOG" }, --Vindicator Boots
	[24606] = { "-ARMOR", "XMOG" }, --Laughing Skull Boots
	[16692] = { "-ARMOR", "XMOG" }, --Devout Gloves
	[14294] = { "-ARMOR", "XMOG" }, --Arachnidian Gloves
	[14314] = { "-ARMOR", "XMOG" }, --Celestial Handwraps
	[31166] = { "-ARMOR", "XMOG" }, --Nethersteel-Lined Handwraps
	[113610] = { "-ARMOR", "XMOG" }, --Meatmonger's Gory Grips
	[114812] = { "-ARMOR", "XMOG" }, --Hexweave Gloves
	[82440] = { "-ARMOR", "XMOG" }, --Gloves of Creation
	[21847] = { "-ARMOR", "XMOG" }, --Spellfire Gloves
	[42113] = { "-ARMOR", "XMOG" }, --Spellweave Gloves
	[14191] = { "-ARMOR", "XMOG" }, --Raincaller Mitts
	[4768] = { "-ARMOR", "XMOG" }, --Adept's Gloves
	[20655] = { "-ARMOR", "XMOG" }, --Abyssal Cloth Handwraps
	[106409] = { "-ARMOR", "XMOG" }, --Lunarglow Handwraps
	[42111] = { "-ARMOR", "XMOG" }, --Ebonweave Gloves
	[98825] = { "-ARMOR", "XMOG" }, --Crafted Malevolent Gladiator's Silk Handguards
	[14302] = { "-ARMOR", "XMOG" }, --Bonecaster's Gloves
	[42103] = { "-ARMOR", "XMOG" }, --Moonshroud Gloves
	[6628] = { "-ARMOR", "XMOG" }, --Raven's Claws
	[4767] = { "-ARMOR", "XMOG" }, --Coppercloth Gloves
	[98865] = { "-ARMOR", "XMOG" }, --Crafted Malevolent Gladiator's Mooncloth Gloves
	[4042] = { "-ARMOR", "XMOG" }, --Aurora Gloves
	[75063] = { "-ARMOR", "XMOG" }, --Vicious Fireweave Gloves
	[21863] = { "-ARMOR", "XMOG" }, --Soulcloth Gloves
	[41516] = { "-ARMOR", "XMOG" }, --Frostsavage Gloves
	[98921] = { "-ARMOR", "XMOG" }, --Crafted Malevolent Gladiator's Felweave Handguards
	[75070] = { "-ARMOR", "XMOG" }, --Vicious Embersilk Gloves
	[45927] = { "-ARMOR", "XMOG" }, --Handwraps of Resonance
	[6565] = { "-ARMOR", "XMOG" }, --Shimmering Gloves
	[3308] = { "-ARMOR", "XMOG" }, --Barbaric Cloth Gloves
	[93499] = { "-ARMOR", "XMOG" }, --Crafted Dreadful Gladiator's Silk Handguards
	[14272] = { "-ARMOR", "XMOG" }, --Gaea's Handwraps
	[42095] = { "-ARMOR", "XMOG" }, --Light Blessed Mittens
	[93550] = { "-ARMOR", "XMOG" }, --Crafted Dreadful Gladiator's Mooncloth Gloves
	[7366] = { "-ARMOR", "XMOG" }, --Elder's Gloves
	[14222] = { "-ARMOR", "XMOG" }, --Geomancer's Gloves
	[14211] = { "-ARMOR", "XMOG" }, --Vital Handwraps
	[4040] = { "-ARMOR", "XMOG" }, --Nightsky Gloves
	[14422] = { "-ARMOR", "XMOG" }, --Silksand Gloves
	[87444] = { "-ARMOR", "XMOG" }, --Wind-Kissed Handwraps
	[14461] = { "-ARMOR", "XMOG" }, --Elunarian Handgrips
	[3074] = { "-ARMOR", "XMOG" }, --Smoldering Gloves
	[54478] = { "-ARMOR", "XMOG" }, --Deathsilk Gloves
	[14333] = { "-ARMOR", "XMOG" }, --Eternal Gloves
	[92726] = { "-ARMOR", "XMOG" }, --Bipsi's Gloves
	[118820] = { "-ARMOR", "XMOG" }, --Anruin's Grips of Agony
	[6541] = { "-ARMOR", "XMOG" }, --Willow Gloves
	[1659] = { "-ARMOR", "XMOG" }, --Engineering Gloves
	[69797] = { "-ARMOR", "XMOG" }, --Charmbinder Grips
	[87447] = { "-ARMOR", "XMOG" }, --Toad-Slime Gloves
	[14377] = { "-ARMOR", "XMOG" }, --Sanguine Handwraps
	[9795] = { "-ARMOR", "XMOG" }, --Ivycloth Gloves
	[106607] = { "-ARMOR", "XMOG" }, --Ravendown Handwraps
	[24608] = { "-ARMOR", "XMOG" }, --Laughing Skull Gloves
	[10176] = { "-ARMOR", "XMOG" }, --Mystical Gloves
	[9880] = { "-ARMOR", "XMOG" }, --Sorcerer Gloves
	[9848] = { "-ARMOR", "XMOG" }, --Conjurer's Gloves
	[8287] = { "-ARMOR", "XMOG" }, --Arcane Gloves
	[14323] = { "-ARMOR", "XMOG" }, --Resplendent Gauntlets
	[106508] = { "-ARMOR", "XMOG" }, --Mandragoran Handwraps
	[7049] = { "-ARMOR", "XMOG" }, --Truefaith Gloves
	[10214] = { "-ARMOR", "XMOG" }, --Elegant Gloves
	[39733] = { "-ARMOR", "XMOG" }, --Gloves of Token Respect
	[54484] = { "-ARMOR", "XMOG" }, --Spiritmend Gloves
	[10023] = { "-ARMOR", "XMOG" }, --Shadoweave Gloves
	[892] = { "-ARMOR", "XMOG" }, --Gnoll Casting Gloves
	[7047] = { "-ARMOR", "XMOG" }, --Hands of Darkness
	[6428] = { "-ARMOR", "XMOG" }, --Mistscape Gloves
	[106706] = { "-ARMOR", "XMOG" }, --Voidwrap Handwraps
	[10140] = { "-ARMOR", "XMOG" }, --High Councillor's Gloves
	[14253] = { "-ARMOR", "XMOG" }, --Lunar Handwraps
	[44211] = { "-ARMOR", "XMOG" }, --Frostwoven Gloves
	[10099] = { "-ARMOR", "XMOG" }, --Councillor's Gloves
	[4331] = { "-ARMOR", "XMOG" }, --Phoenix Gloves
	[21851] = { "-ARMOR", "XMOG" }, --Netherweave Gloves
	[14043] = { "-ARMOR", "XMOG" }, --Cindercloth Gloves
	[66641] = { "-ARMOR", "XMOG" }, --Vonica's Gauntlets
	[9939] = { "-ARMOR", "XMOG" }, --Abjurer's Gloves
	[7064] = { "-ARMOR", "XMOG" }, --Crimson Silk Gloves
	[14101] = { "-ARMOR", "XMOG" }, --Brightcloth Gloves
	[14367] = { "-ARMOR", "XMOG" }, --Mystic's Gloves
	[67146] = { "-ARMOR", "XMOG" }, --Woundsplicer Handwraps
	[106574] = { "-ARMOR", "XMOG" }, --Gordunni Handwraps
	[36046] = { "-ARMOR", "XMOG" }, --Crystalsong Gloves
	[90588] = { "-ARMOR", "XMOG" }, --Rittsyn's Ruinblasters
	[13870] = { "-ARMOR", "XMOG" }, --Frostweave Gloves
	[10018] = { "-ARMOR", "XMOG" }, --Red Mageweave Gloves
	[10062] = { "-ARMOR", "XMOG" }, --Duskwoven Gloves
	[24616] = { "-ARMOR", "XMOG" }, --Vindicator Gloves
	[6615] = { "-ARMOR", "XMOG" }, --Sage's Gloves
	[24624] = { "-ARMOR", "XMOG" }, --Slavehandler Handwraps
	[41545] = { "-ARMOR", "XMOG" }, --Duskweave Gloves
	[81970] = { "-ARMOR", "XMOG" }, --Stitched Handwraps
	[14168] = { "-ARMOR", "XMOG" }, --Buccaneer's Gloves
	[67126] = { "-ARMOR", "XMOG" }, --Roffle's Ruffly Gloves
	[31149] = { "-ARMOR", "XMOG" }, --Gloves of Pandemonium
	[2984] = { "-ARMOR", "XMOG" }, --Seer's Gloves
	[9823] = { "-ARMOR", "XMOG" }, --Durable Gloves
	[13863] = { "-ARMOR", "XMOG" }, --Runecloth Gloves
	[4310] = { "-ARMOR", "XMOG" }, --Heavy Woolen Gloves
	[14124] = { "-ARMOR", "XMOG" }, --Ritual Gloves
	[14162] = { "-ARMOR", "XMOG" }, --Pagan Mitts
	[82141] = { "-ARMOR", "XMOG" }, --Brewer's Handwraps
	[24640] = { "-ARMOR", "XMOG" }, --Mistyreed Gloves
	[9395] = { "-ARMOR", "XMOG" }, --Gloves of Old
	[35998] = { "-ARMOR", "XMOG" }, --Voldrune Gloves
	[82400] = { "-ARMOR", "XMOG" }, --Windwool Gloves
	[4307] = { "-ARMOR", "XMOG" }, --Heavy Linen Gloves
	[37759] = { "-ARMOR", "XMOG" }, --Rhie-Ay's Clutching Gauntlets
	[55733] = { "-ARMOR", "XMOG" }, --Baradin Handwraps
	[24680] = { "-ARMOR", "XMOG" }, --Archmage Gloves
	[36038] = { "-ARMOR", "XMOG" }, --Condor Gloves
	[24656] = { "-ARMOR", "XMOG" }, --Consortium Gloves
	[10003] = { "-ARMOR", "XMOG" }, --Black Mageweave Gloves
	[24672] = { "-ARMOR", "XMOG" }, --Eldr'naan Gloves
	[24632] = { "-ARMOR", "XMOG" }, --Feralfen Hand
	[35974] = { "-ARMOR", "XMOG" }, --Mur'ghoul Handwraps
	[10588] = { "-ARMOR", "XMOG" }, --Goblin Rocket Helmet
	[14441] = { "-ARMOR", "XMOG" }, --Venomshroud Mask
	[118893] = { "-ARMOR", "XMOG" }, --Lylirra's Shining Circlet
	[14178] = { "-ARMOR", "XMOG" }, --Watcher's Cap
	[114810] = { "-ARMOR", "XMOG" }, --Hexweave Cowl
	[31220] = { "-ARMOR", "XMOG" }, --Amethyst Beholder Eye
	[14421] = { "-ARMOR", "XMOG" }, --Silksand Circlet
	[10504] = { "-ARMOR", "XMOG" }, --Green Lens
	[14449] = { "-ARMOR", "XMOG" }, --Highborne Crown
	[14130] = { "-ARMOR", "XMOG" }, --Wizardweave Turban
	[2622] = { "-ARMOR", "XMOG" }, --Nimar's Tribal Headdress
	[10097] = { "-ARMOR", "XMOG" }, --Councillor's Circlet
	[2955] = { "-ARMOR", "XMOG" }, --First Mate Hat
	[14460] = { "-ARMOR", "XMOG" }, --Elunarian Diadem
	[10025] = { "-ARMOR", "XMOG" }, --Shadoweave Mask
	[32776] = { "-ARMOR", "XMOG" }, --Crown of the Sea Witch
	[43971] = { "-ARMOR", "XMOG" }, --Frostsavage Cowl
	[118821] = { "-ARMOR", "XMOG" }, --Mystical Cap of Skill
	[93500] = { "-ARMOR", "XMOG" }, --Crafted Dreadful Gladiator's Silk Cowl
	[109172] = { "-ARMOR", "XMOG" }, --Plasma Mechshades
	[2623] = { "-ARMOR", "XMOG" }, --Holy Diadem
	[9940] = { "-ARMOR", "XMOG" }, --Abjurer's Hood
	[10219] = { "-ARMOR", "XMOG" }, --Elegant Circlet
	[14246] = { "-ARMOR", "XMOG" }, --Darkmist Wizard Hat
	[93556] = { "-ARMOR", "XMOG" }, --Crafted Dreadful Gladiator's Satin Hood
	[14322] = { "-ARMOR", "XMOG" }, --Resplendent Circlet
	[10250] = { "-ARMOR", "XMOG" }, --Master's Hat
	[14332] = { "-ARMOR", "XMOG" }, --Eternal Crown
	[93616] = { "-ARMOR", "XMOG" }, --Crafted Dreadful Gladiator's Felweave Cowl
	[82429] = { "-ARMOR", "XMOG" }, --Contender's Satin Cowl
	[4039] = { "-ARMOR", "XMOG" }, --Nightsky Cowl
	[14208] = { "-ARMOR", "XMOG" }, --Vital Headband
	[3345] = { "-ARMOR", "XMOG" }, --Silk Wizard Hat
	[2620] = { "-ARMOR", "XMOG" }, --Augural Shroud
	[87450] = { "-ARMOR", "XMOG" }, --Hood of Alchemical Vapors
	[54485] = { "-ARMOR", "XMOG" }, --Spiritmend Cowl
	[106408] = { "-ARMOR", "XMOG" }, --Lunarglow Cowl
	[2621] = { "-ARMOR", "XMOG" }, --Cowl of Necromancy
	[8292] = { "-ARMOR", "XMOG" }, --Arcane Cover
	[9878] = { "-ARMOR", "XMOG" }, --Sorcerer Hat
	[14293] = { "-ARMOR", "XMOG" }, --Arachnidian Circlet
	[10139] = { "-ARMOR", "XMOG" }, --High Councillor's Circlet
	[10175] = { "-ARMOR", "XMOG" }, --Mystical Headwrap
	[14228] = { "-ARMOR", "XMOG" }, --Embersilk Coronet
	[9915] = { "-ARMOR", "XMOG" }, --Royal Headband
	[14410] = { "-ARMOR", "XMOG" }, --Stonecloth Circlet
	[14111] = { "-ARMOR", "XMOG" }, --Felcloth Hood
	[14307] = { "-ARMOR", "XMOG" }, --Bonecaster's Crown
	[90573] = { "-ARMOR", "XMOG" }, --Wang's Unshakable Smile
	[24593] = { "-ARMOR", "XMOG" }, --Fireheart Skullcap
	[14252] = { "-ARMOR", "XMOG" }, --Lunar Coronet
	[106738] = { "-ARMOR", "XMOG" }, --Dark Star Cowl
	[31272] = { "-ARMOR", "XMOG" }, --Crown of Endless Knowledge
	[7432] = { "-ARMOR", "XMOG" }, --Twilight Cowl
	[20832] = { "-ARMOR", "XMOG" }, --Moonsoul Crown
	[24585] = { "-ARMOR", "XMOG" }, --Outlander's Facewrap
	[5608] = { "-ARMOR", "XMOG" }, --Living Cowl
	[8254] = { "-ARMOR", "XMOG" }, --Imperial Red Circlet
	[10008] = { "-ARMOR", "XMOG" }, --White Bandit Mask
	[45435] = { "-ARMOR", "XMOG" }, --Cowl of the Absolute
	[114828] = { "-ARMOR", "XMOG" }, --Sumptuous Cowl
	[14220] = { "-ARMOR", "XMOG" }, --Geomancer's Cap
	[2721] = { "-ARMOR", "XMOG" }, --Holy Shroud
	[10033] = { "-ARMOR", "XMOG" }, --Red Mageweave Headband
	[41546] = { "-ARMOR", "XMOG" }, --Duskweave Cowl
	[10030] = { "-ARMOR", "XMOG" }, --Admiral's Hat
	[106672] = { "-ARMOR", "XMOG" }, --Windswept Cowl
	[82397] = { "-ARMOR", "XMOG" }, --Windwool Hood
	[4323] = { "-ARMOR", "XMOG" }, --Shadow Hood
	[10288] = { "-ARMOR", "XMOG" }, --Sage's Circlet
	[94262] = { "-ARMOR", "XMOG" }, --Faded Spirit-Wrencher Cage
	[4368] = { "-ARMOR", "XMOG" }, --Flying Tiger Goggles
	[66931] = { "-ARMOR", "XMOG" }, --Mercury-Coated Hood
	[2624] = { "-ARMOR", "XMOG" }, --Thinking Cap
	[106540] = { "-ARMOR", "XMOG" }, --Orunai Cowl
	[94066] = { "-ARMOR", "XMOG" }, --Forlorn Loa-Binder Cage
	[7520] = { "-ARMOR", "XMOG" }, --Gossamer Headpiece
	[24609] = { "-ARMOR", "XMOG" }, --Laughing Skull Cap
	[13866] = { "-ARMOR", "XMOG" }, --Runecloth Headband
	[24601] = { "-ARMOR", "XMOG" }, --Starfire Circlet
	[4322] = { "-ARMOR", "XMOG" }, --Enchanter's Cowl
	[82085] = { "-ARMOR", "XMOG" }, --Growing Cowl
	[10061] = { "-ARMOR", "XMOG" }, --Duskwoven Turban
	[9849] = { "-ARMOR", "XMOG" }, --Conjurer's Hood
	[7048] = { "-ARMOR", "XMOG" }, --Azure Silk Hood
	[35975] = { "-ARMOR", "XMOG" }, --Mur'ghoul Cap
	[82250] = { "-ARMOR", "XMOG" }, --Waterfall Cowl
	[36015] = { "-ARMOR", "XMOG" }, --Tethys Hood
	[41521] = { "-ARMOR", "XMOG" }, --Frostwoven Cowl
	[24617] = { "-ARMOR", "XMOG" }, --Vindicator Cap
	[37754] = { "-ARMOR", "XMOG" }, --Shimmersteel Hood
	[7050] = { "-ARMOR", "XMOG" }, --Silk Headband
	[55745] = { "-ARMOR", "XMOG" }, --Everstill Cowl
	[36031] = { "-ARMOR", "XMOG" }, --Oracle Circlet
	[36055] = { "-ARMOR", "XMOG" }, --Vizier Hood
	[54476] = { "-ARMOR", "XMOG" }, --Deathsilk Cowl
	[24665] = { "-ARMOR", "XMOG" }, --Shadow Council Cowl
	[24673] = { "-ARMOR", "XMOG" }, --Eldr'naan Hood
	[37746] = { "-ARMOR", "XMOG" }, --Helm of the Burning Soul
	[24633] = { "-ARMOR", "XMOG" }, --Feralfen Hood
	[24649] = { "-ARMOR", "XMOG" }, --Astralaan Headdress
	[24681] = { "-ARMOR", "XMOG" }, --Archmage Headpiece
	[20408] = { "-ARMOR", "XMOG" }, --Twilight Cultist Cowl
	[24689] = { "-ARMOR", "XMOG" }, --Elementalist Skullcap
	[10024] = { "-ARMOR", "XMOG" }, --Black Mageweave Headband
	[71981] = { "-ARMOR", "XMOG" }, --World Mender's Pants
	[4044] = { "-ARMOR", "XMOG" }, --Aurora Pants
	[30734] = { "-ARMOR", "XMOG" }, --Leggings of the Seventh Circle
	[114811] = { "-ARMOR", "XMOG" }, --Hexweave Leggings
	[98603] = { "-ARMOR", "XMOG" }, --Leggings of the Night Sky
	[14274] = { "-ARMOR", "XMOG" }, --Gaea's Leggings
	[14305] = { "-ARMOR", "XMOG" }, --Bonecaster's Sarong
	[14379] = { "-ARMOR", "XMOG" }, --Sanguine Trousers
	[3563] = { "-ARMOR", "XMOG" }, --Seafarer's Pantaloons
	[98599] = { "-ARMOR", "XMOG" }, --White Cloud Leggings
	[98827] = { "-ARMOR", "XMOG" }, --Crafted Malevolent Gladiator's Silk Trousers
	[12987] = { "-ARMOR", "XMOG" }, --Darkweave Breeches
	[14264] = { "-ARMOR", "XMOG" }, --Bloodwoven Pants
	[75082] = { "-ARMOR", "XMOG" }, --Vicious Fireweave Pants
	[14119] = { "-ARMOR", "XMOG" }, --Aboriginal Loincloth
	[31556] = { "-ARMOR", "XMOG" }, --Windchanneller's Leggings
	[4434] = { "-ARMOR", "XMOG" }, --Scarecrow Trousers
	[14315] = { "-ARMOR", "XMOG" }, --Celestial Kilt
	[75072] = { "-ARMOR", "XMOG" }, --Vicious Embersilk Pants
	[93557] = { "-ARMOR", "XMOG" }, --Crafted Dreadful Gladiator's Satin Leggings
	[43975] = { "-ARMOR", "XMOG" }, --Frostsavage Leggings
	[90725] = { "-ARMOR", "XMOG" }, --Gaarn's Leggings of Infestation
	[10217] = { "-ARMOR", "XMOG" }, --Elegant Leggings
	[14295] = { "-ARMOR", "XMOG" }, --Arachnidian Legguards
	[9772] = { "-ARMOR", "XMOG" }, --Greenweave Leggings
	[93617] = { "-ARMOR", "XMOG" }, --Crafted Dreadful Gladiator's Felweave Trousers
	[14424] = { "-ARMOR", "XMOG" }, --Silksand Legwraps
	[3309] = { "-ARMOR", "XMOG" }, --Barbaric Loincloth
	[14433] = { "-ARMOR", "XMOG" }, --Windchaser Woolies
	[10141] = { "-ARMOR", "XMOG" }, --High Councillor's Pants
	[14132] = { "-ARMOR", "XMOG" }, --Wizardweave Leggings
	[7519] = { "-ARMOR", "XMOG" }, --Gossamer Pants
	[90721] = { "-ARMOR", "XMOG" }, --Cournith Waterstrider's Silken Finery
	[14165] = { "-ARMOR", "XMOG" }, --Pagan Britches
	[118822] = { "-ARMOR", "XMOG" }, --Kitsy's Knickers
	[14144] = { "-ARMOR", "XMOG" }, --Ghostweave Pants
	[3073] = { "-ARMOR", "XMOG" }, --Smoldering Pants
	[21859] = { "-ARMOR", "XMOG" }, --Imbued Netherweave Pants
	[37755] = { "-ARMOR", "XMOG" }, --Leggings of the Icy Heart
	[14224] = { "-ARMOR", "XMOG" }, --Geomancer's Trousers
	[8289] = { "-ARMOR", "XMOG" }, --Arcane Leggings
	[14233] = { "-ARMOR", "XMOG" }, --Embersilk Leggings
	[6405] = { "-ARMOR", "XMOG" }, --Nightsky Trousers
	[14045] = { "-ARMOR", "XMOG" }, --Cindercloth Pants
	[3291] = { "-ARMOR", "XMOG" }, --Ancestral Woollies
	[10101] = { "-ARMOR", "XMOG" }, --Councillor's Pants
	[14334] = { "-ARMOR", "XMOG" }, --Eternal Sarong
	[6616] = { "-ARMOR", "XMOG" }, --Sage's Pants
	[14462] = { "-ARMOR", "XMOG" }, --Elunarian Sarong
	[7469] = { "-ARMOR", "XMOG" }, --Regal Leggings
	[98867] = { "-ARMOR", "XMOG" }, --Crafted Malevolent Gladiator's Mooncloth Leggings
	[98923] = { "-ARMOR", "XMOG" }, --Crafted Malevolent Gladiator's Felweave Trousers
	[9851] = { "-ARMOR", "XMOG" }, --Conjurer's Breeches
	[10554] = { "-ARMOR", "XMOG" }, --Foreman Pants
	[87463] = { "-ARMOR", "XMOG" }, --Very Manly Leggings
	[24658] = { "-ARMOR", "XMOG" }, --Consortium Pants
	[4037] = { "-ARMOR", "XMOG" }, --Silver-Thread Pants
	[14404] = { "-ARMOR", "XMOG" }, --Resilient Leggings
	[24666] = { "-ARMOR", "XMOG" }, --Shadow Council Pants
	[82401] = { "-ARMOR", "XMOG" }, --Windwool Pants
	[24642] = { "-ARMOR", "XMOG" }, --Mistyreed Pants
	[114831] = { "-ARMOR", "XMOG" }, --Sumptuous Leggings
	[9797] = { "-ARMOR", "XMOG" }, --Ivycloth Pants
	[10009] = { "-ARMOR", "XMOG" }, --Red Mageweave Pants
	[54483] = { "-ARMOR", "XMOG" }, --Spiritmend Leggings
	[14090] = { "-ARMOR", "XMOG" }, --Beaded Britches
	[41548] = { "-ARMOR", "XMOG" }, --Duskweave Leggings
	[4317] = { "-ARMOR", "XMOG" }, --Phoenix Pants
	[14104] = { "-ARMOR", "XMOG" }, --Brightcloth Pants
	[54472] = { "-ARMOR", "XMOG" }, --Deathsilk Leggings
	[94061] = { "-ARMOR", "XMOG" }, --Exiled Dabbler's Leggings
	[14324] = { "-ARMOR", "XMOG" }, --Resplendent Sarong
	[24650] = { "-ARMOR", "XMOG" }, --Astralaan Pants
	[106641] = { "-ARMOR", "XMOG" }, --Sunscryer Leggings
	[106443] = { "-ARMOR", "XMOG" }, --Anchorite Leggings
	[13871] = { "-ARMOR", "XMOG" }, --Frostweave Pants
	[14370] = { "-ARMOR", "XMOG" }, --Mystic's Woolies
	[13865] = { "-ARMOR", "XMOG" }, --Runecloth Pants
	[9999] = { "-ARMOR", "XMOG" }, --Black Mageweave Leggings
	[7368] = { "-ARMOR", "XMOG" }, --Elder's Pants
	[24610] = { "-ARMOR", "XMOG" }, --Laughing Skull Pants
	[106476] = { "-ARMOR", "XMOG" }, --Iyun Leggings
	[106707] = { "-ARMOR", "XMOG" }, --Voidwrap Leggings
	[31343] = { "-ARMOR", "XMOG" }, --Kamaei's Cerulean Skirt
	[9911] = { "-ARMOR", "XMOG" }, --Royal Trousers
	[66904] = { "-ARMOR", "XMOG" }, --Gartic's Resplendent Leggings
	[106542] = { "-ARMOR", "XMOG" }, --Orunai Leggings
	[82252] = { "-ARMOR", "XMOG" }, --Waterfall Leggings
	[35992] = { "-ARMOR", "XMOG" }, --Bristlepine Leggings
	[7431] = { "-ARMOR", "XMOG" }, --Twilight Pants
	[81968] = { "-ARMOR", "XMOG" }, --Stitched Leggings
	[41519] = { "-ARMOR", "XMOG" }, --Frostwoven Leggings
	[10064] = { "-ARMOR", "XMOG" }, --Duskwoven Pants
	[2982] = { "-ARMOR", "XMOG" }, --Seer's Pants
	[10002] = { "-ARMOR", "XMOG" }, --Shadoweave Pants
	[3067] = { "-ARMOR", "XMOG" }, --Bright Pants
	[45468] = { "-ARMOR", "XMOG" }, --Leggings of Lost Love
	[55756] = { "-ARMOR", "XMOG" }, --Bluefen Leggings
	[4723] = { "-ARMOR", "XMOG" }, --Humbert's Pants
	[4316] = { "-ARMOR", "XMOG" }, --Heavy Woolen Pants
	[31306] = { "-ARMOR", "XMOG" }, --Leggings of the Sacred Crest
	[24618] = { "-ARMOR", "XMOG" }, --Vindicator Pants
	[21852] = { "-ARMOR", "XMOG" }, --Netherweave Pants
	[14125] = { "-ARMOR", "XMOG" }, --Ritual Leggings
	[9747] = { "-ARMOR", "XMOG" }, --Simple Britches
	[10048] = { "-ARMOR", "XMOG" }, --Colorful Kilt
	[36056] = { "-ARMOR", "XMOG" }, --Vizier Leggings
	[7062] = { "-ARMOR", "XMOG" }, --Crimson Silk Pantaloons
	[36064] = { "-ARMOR", "XMOG" }, --Coldwraith Pants
	[7046] = { "-ARMOR", "XMOG" }, --Azure Silk Pants
	[14207] = { "-ARMOR", "XMOG" }, --Vital Leggings
	[2970] = { "-ARMOR", "XMOG" }, --Spellbinder Pants
	[24626] = { "-ARMOR", "XMOG" }, --Slavehandler Pants
	[4309] = { "-ARMOR", "XMOG" }, --Handstitched Linen Britches
	[10047] = { "-ARMOR", "XMOG" }, --Simple Kilt
	[24682] = { "-ARMOR", "XMOG" }, --Archmage Pants
	[13008] = { "-ARMOR", "XMOG" }, --Dalewind Trousers
	[35968] = { "-ARMOR", "XMOG" }, --Bloodspore Leggings
	[10177] = { "-ARMOR", "XMOG" }, --Mystical Leggings
	[24674] = { "-ARMOR", "XMOG" }, --Eldr'naan Pants
	[4343] = { "-ARMOR", "XMOG" }, --Brown Linen Pants
	[14097] = { "-ARMOR", "XMOG" }, --Native Pants
	[24586] = { "-ARMOR", "XMOG" }, --Outlander's Leggings
	[6540] = { "-ARMOR", "XMOG" }, --Willow Pants
	[17050] = { "-ARMOR", "XMOG" }, --Chan's Imperial Robes
	[3019] = { "-ARMOR", "XMOG" }, --Noble's Robe
	[14297] = { "-ARMOR", "XMOG" }, --Arachnidian Robes
	[14380] = { "-ARMOR", "XMOG" }, --Sanguine Robe
	[3569] = { "-ARMOR", "XMOG" }, --Vicar's Robe
	[14127] = { "-ARMOR", "XMOG" }, --Ritual Shroud
	[14336] = { "-ARMOR", "XMOG" }, --Eternal Wraps
	[21848] = { "-ARMOR", "XMOG" }, --Spellfire Robe
	[14453] = { "-ARMOR", "XMOG" }, --Highborne Robes
	[14275] = { "-ARMOR", "XMOG" }, --Gaea's Raiment
	[21875] = { "-ARMOR", "XMOG" }, --Primal Mooncloth Robe
	[21871] = { "-ARMOR", "XMOG" }, --Frozen Shadoweave Robe
	[42101] = { "-ARMOR", "XMOG" }, --Ebonweave Robe
	[114813] = { "-ARMOR", "XMOG" }, --Hexweave Robe
	[42102] = { "-ARMOR", "XMOG" }, --Spellweave Robe
	[43583] = { "-ARMOR", "XMOG" }, --Glacial Robe
	[47606] = { "-ARMOR", "XMOG" }, --Royal Moonshroud Robe
	[44668] = { "-ARMOR", "XMOG" }, --Egg-Warming Blanket
	[14234] = { "-ARMOR", "XMOG" }, --Embersilk Robes
	[6415] = { "-ARMOR", "XMOG" }, --Aurora Robe
	[5770] = { "-ARMOR", "XMOG" }, --Robes of Arcana
	[14425] = { "-ARMOR", "XMOG" }, --Silksand Wraps
	[940] = { "-ARMOR", "XMOG" }, --Robes of Insight
	[8113] = { "-ARMOR", "XMOG" }, --Hibernal Robe
	[14326] = { "-ARMOR", "XMOG" }, --Resplendent Robes
	[42100] = { "-ARMOR", "XMOG" }, --Moonshroud Robe
	[3072] = { "-ARMOR", "XMOG" }, --Smoldering Robe
	[14413] = { "-ARMOR", "XMOG" }, --Stonecloth Robe
	[2800] = { "-ARMOR", "XMOG" }, --Black Velvet Robes
	[7518] = { "-ARMOR", "XMOG" }, --Gossamer Robe
	[21861] = { "-ARMOR", "XMOG" }, --Imbued Netherweave Robe
	[4476] = { "-ARMOR", "XMOG" }, --Beastwalker Robe
	[18486] = { "-ARMOR", "XMOG" }, --Mooncloth Robe
	[75088] = { "-ARMOR", "XMOG" }, --Vicious Fireweave Robe
	[14284] = { "-ARMOR", "XMOG" }, --Opulent Robes
	[118819] = { "-ARMOR", "XMOG" }, --Ariya's Auspicious Robe
	[98924] = { "-ARMOR", "XMOG" }, --Crafted Malevolent Gladiator's Felweave Raiment
	[14213] = { "-ARMOR", "XMOG" }, --Vital Raiment
	[14405] = { "-ARMOR", "XMOG" }, --Resilient Robe
	[14317] = { "-ARMOR", "XMOG" }, --Celestial Silk Robes
	[14225] = { "-ARMOR", "XMOG" }, --Geomancer's Wraps
	[1297] = { "-ARMOR", "XMOG" }, --Robes of the Shadowcaster
	[98868] = { "-ARMOR", "XMOG" }, --Crafted Malevolent Gladiator's Mooncloth Robe
	[10102] = { "-ARMOR", "XMOG" }, --Councillor's Robes
	[43972] = { "-ARMOR", "XMOG" }, --Frostsavage Robe
	[14172] = { "-ARMOR", "XMOG" }, --Buccaneer's Robes
	[14464] = { "-ARMOR", "XMOG" }, --Elunarian Silk Robes
	[93502] = { "-ARMOR", "XMOG" }, --Crafted Dreadful Gladiator's Silk Robe
	[9773] = { "-ARMOR", "XMOG" }, --Greenweave Robe
	[13868] = { "-ARMOR", "XMOG" }, --Frostweave Robe
	[9943] = { "-ARMOR", "XMOG" }, --Abjurer's Robe
	[4035] = { "-ARMOR", "XMOG" }, --Silver-Thread Robe
	[5766] = { "-ARMOR", "XMOG" }, --Lesser Wizard's Robe
	[1997] = { "-ARMOR", "XMOG" }, --Pressed Felt Robe
	[93553] = { "-ARMOR", "XMOG" }, --Crafted Dreadful Gladiator's Mooncloth Robe
	[6531] = { "-ARMOR", "XMOG" }, --Barbaric Cloth Robe
	[14371] = { "-ARMOR", "XMOG" }, --Mystic's Robe
	[9826] = { "-ARMOR", "XMOG" }, --Durable Robe
	[31264] = { "-ARMOR", "XMOG" }, --Silvermoon Robes
	[10215] = { "-ARMOR", "XMOG" }, --Elegant Robes
	[6427] = { "-ARMOR", "XMOG" }, --Mistscape Robe
	[2566] = { "-ARMOR", "XMOG" }, --Sacrificial Robes
	[54475] = { "-ARMOR", "XMOG" }, --Deathsilk Robe
	[7369] = { "-ARMOR", "XMOG" }, --Elder's Robe
	[14120] = { "-ARMOR", "XMOG" }, --Aboriginal Robe
	[14303] = { "-ARMOR", "XMOG" }, --Bonecaster's Shroud
	[9748] = { "-ARMOR", "XMOG" }, --Simple Robe
	[9884] = { "-ARMOR", "XMOG" }, --Sorcerer Robe
	[87484] = { "-ARMOR", "XMOG" }, --Robes of the Quiet Isle
	[10143] = { "-ARMOR", "XMOG" }, --High Councillor's Robe
	[9913] = { "-ARMOR", "XMOG" }, --Royal Gown
	[31340] = { "-ARMOR", "XMOG" }, --Will of Edward the Odd
	[6610] = { "-ARMOR", "XMOG" }, --Sage's Robe
	[14204] = { "-ARMOR", "XMOG" }, --Thistlefur Robe
	[24655] = { "-ARMOR", "XMOG" }, --Consortium Robe
	[37753] = { "-ARMOR", "XMOG" }, --Mendicant's Robe of Mendacity
	[7430] = { "-ARMOR", "XMOG" }, --Twilight Robe
	[14109] = { "-ARMOR", "XMOG" }, --Native Robe
	[7468] = { "-ARMOR", "XMOG" }, --Regal Robe
	[6528] = { "-ARMOR", "XMOG" }, --Spellbinder Robe
	[41515] = { "-ARMOR", "XMOG" }, --Frostwoven Robe
	[106543] = { "-ARMOR", "XMOG" }, --Orunai Robe
	[14091] = { "-ARMOR", "XMOG" }, --Beaded Robe
	[1716] = { "-ARMOR", "XMOG" }, --Robe of the Magi
	[6569] = { "-ARMOR", "XMOG" }, --Shimmering Robe
	[10065] = { "-ARMOR", "XMOG" }, --Duskwoven Robe
	[8290] = { "-ARMOR", "XMOG" }, --Arcane Robe
	[114829] = { "-ARMOR", "XMOG" }, --Sumptuous Robes
	[67106] = { "-ARMOR", "XMOG" }, --Robes of Broken Dreams
	[67133] = { "-ARMOR", "XMOG" }, --Dizze's Whirling Robe
	[41549] = { "-ARMOR", "XMOG" }, --Duskweave Robe
	[13858] = { "-ARMOR", "XMOG" }, --Runecloth Robe
	[106609] = { "-ARMOR", "XMOG" }, --Ravendown Robe
	[6538] = { "-ARMOR", "XMOG" }, --Willow Robe
	[10178] = { "-ARMOR", "XMOG" }, --Mystical Robe
	[54486] = { "-ARMOR", "XMOG" }, --Spiritmend Robe
	[94064] = { "-ARMOR", "XMOG" }, --Forlorn Loa-Binder Robe
	[3069] = { "-ARMOR", "XMOG" }, --Bright Robe
	[6527] = { "-ARMOR", "XMOG" }, --Ancestral Robe
	[2981] = { "-ARMOR", "XMOG" }, --Seer's Robe
	[94065] = { "-ARMOR", "XMOG" }, --Faded Spirit-Wrencher Robe
	[6263] = { "-ARMOR", "XMOG" }, --Blue Overalls
	[94058] = { "-ARMOR", "XMOG" }, --Exiled Dabbler's Robe
	[10254] = { "-ARMOR", "XMOG" }, --Master's Robe
	[10004] = { "-ARMOR", "XMOG" }, --Shadoweave Robe
	[10042] = { "-ARMOR", "XMOG" }, --Cindercloth Robe
	[106708] = { "-ARMOR", "XMOG" }, --Voidwrap Robe
	[36005] = { "-ARMOR", "XMOG" }, --Icemist Robe
	[106411] = { "-ARMOR", "XMOG" }, --Lunarglow Robe
	[36045] = { "-ARMOR", "XMOG" }, --Crystalsong Robe
	[9852] = { "-ARMOR", "XMOG" }, --Conjurer's Robe
	[2585] = { "-ARMOR", "XMOG" }, --Gray Woolen Robe
	[31282] = { "-ARMOR", "XMOG" }, --Shroud of Spiritual Purity
	[6264] = { "-ARMOR", "XMOG" }, --Greater Adept's Robe
	[106477] = { "-ARMOR", "XMOG" }, --Iyun Robe
	[14100] = { "-ARMOR", "XMOG" }, --Brightcloth Robe
	[66919] = { "-ARMOR", "XMOG" }, --Robes of Whispering Sands
	[87485] = { "-ARMOR", "XMOG" }, --Robes of Forgone Hope
	[82253] = { "-ARMOR", "XMOG" }, --Waterfall Robe
	[24647] = { "-ARMOR", "XMOG" }, --Astralaan Robe
	[6512] = { "-ARMOR", "XMOG" }, --Disciple's Robe
	[82033] = { "-ARMOR", "XMOG" }, --Reed Robe
	[55714] = { "-ARMOR", "XMOG" }, --Mistmantle Robe
	[35965] = { "-ARMOR", "XMOG" }, --Bloodspore Robe
	[2572] = { "-ARMOR", "XMOG" }, --Red Linen Robe
	[36061] = { "-ARMOR", "XMOG" }, --Coldwraith Robe
	[31297] = { "-ARMOR", "XMOG" }, --Robe of the Crimson Order
	[6242] = { "-ARMOR", "XMOG" }, --Blue Linen Robe
	[10001] = { "-ARMOR", "XMOG" }, --Black Mageweave Robe
	[36037] = { "-ARMOR", "XMOG" }, --Condor Robe
	[20407] = { "-ARMOR", "XMOG" }, --Twilight Cultist Robe
	[24679] = { "-ARMOR", "XMOG" }, --Archmage Robe
	[6238] = { "-ARMOR", "XMOG" }, --Brown Linen Robe
	[6241] = { "-ARMOR", "XMOG" }, --White Linen Robe
	[6511] = { "-ARMOR", "XMOG" }, --Journeyman's Robe
	[38318] = { "-ARMOR", "XMOG" }, --Darkmoon Robe
	[120166] = { "-ARMOR", "XMOG" }, --Gorestained Garb
	[21869] = { "-ARMOR", "XMOG" }, --Frozen Shadoweave Shoulders
	[114809] = { "-ARMOR", "XMOG" }, --Hexweave Mantle
	[4729] = { "-ARMOR", "XMOG" }, --Aurora Mantle
	[21874] = { "-ARMOR", "XMOG" }, --Primal Mooncloth Shoulders
	[21864] = { "-ARMOR", "XMOG" }, --Soulcloth Shoulders
	[4661] = { "-ARMOR", "XMOG" }, --Bright Mantle
	[8288] = { "-ARMOR", "XMOG" }, --Arcane Pads
	[93503] = { "-ARMOR", "XMOG" }, --Crafted Dreadful Gladiator's Silk Amice
	[93559] = { "-ARMOR", "XMOG" }, --Crafted Dreadful Gladiator's Satin Mantle
	[14412] = { "-ARMOR", "XMOG" }, --Stonecloth Epaulets
	[4718] = { "-ARMOR", "XMOG" }, --Nightsky Mantle
	[82422] = { "-ARMOR", "XMOG" }, --Contender's Silk Amice
	[14463] = { "-ARMOR", "XMOG" }, --Elunarian Spaulders
	[14423] = { "-ARMOR", "XMOG" }, --Silksand Shoulder Pads
	[14278] = { "-ARMOR", "XMOG" }, --Opulent Mantle
	[98874] = { "-ARMOR", "XMOG" }, --Crafted Malevolent Gladiator's Satin Mantle
	[24611] = { "-ARMOR", "XMOG" }, --Laughing Skull Shoulderpads
	[75091] = { "-ARMOR", "XMOG" }, --Vicious Fireweave Shoulders
	[98829] = { "-ARMOR", "XMOG" }, --Crafted Malevolent Gladiator's Silk Amice
	[14243] = { "-ARMOR", "XMOG" }, --Darkmist Mantle
	[14232] = { "-ARMOR", "XMOG" }, --Embersilk Mantle
	[7523] = { "-ARMOR", "XMOG" }, --Gossamer Shoulderpads
	[98925] = { "-ARMOR", "XMOG" }, --Crafted Malevolent Gladiator's Felweave Amice
	[93619] = { "-ARMOR", "XMOG" }, --Crafted Dreadful Gladiator's Felweave Amice
	[118823] = { "-ARMOR", "XMOG" }, --Mantle of Moera
	[12998] = { "-ARMOR", "XMOG" }, --Magician's Mantle
	[10210] = { "-ARMOR", "XMOG" }, --Elegant Mantle
	[14273] = { "-ARMOR", "XMOG" }, --Gaea's Amice
	[7367] = { "-ARMOR", "XMOG" }, --Elder's Mantle
	[14325] = { "-ARMOR", "XMOG" }, --Resplendent Epaulets
	[75064] = { "-ARMOR", "XMOG" }, --Vicious Embersilk Shoulders
	[54474] = { "-ARMOR", "XMOG" }, --Deathsilk Shoulders
	[43973] = { "-ARMOR", "XMOG" }, --Frostsavage Shoulders
	[8250] = { "-ARMOR", "XMOG" }, --Imperial Red Mantle
	[9912] = { "-ARMOR", "XMOG" }, --Royal Amice
	[7060] = { "-ARMOR", "XMOG" }, --Azure Shoulders
	[10142] = { "-ARMOR", "XMOG" }, --High Councillor's Mantle
	[6617] = { "-ARMOR", "XMOG" }, --Sage's Mantle
	[7473] = { "-ARMOR", "XMOG" }, --Regal Mantle
	[106545] = { "-ARMOR", "XMOG" }, --Orunai Shoulderpads
	[9881] = { "-ARMOR", "XMOG" }, --Sorcerer Mantle
	[24587] = { "-ARMOR", "XMOG" }, --Outlander's Pauldrons
	[24659] = { "-ARMOR", "XMOG" }, --Consortium Mantle
	[10172] = { "-ARMOR", "XMOG" }, --Mystical Mantle
	[94067] = { "-ARMOR", "XMOG" }, --Forlorn Loa-Binder Shoulders
	[7435] = { "-ARMOR", "XMOG" }, --Twilight Mantle
	[10063] = { "-ARMOR", "XMOG" }, --Duskwoven Amice
	[87490] = { "-ARMOR", "XMOG" }, --Orb-Bound Shoulders
	[14335] = { "-ARMOR", "XMOG" }, --Eternal Spaulders
	[10028] = { "-ARMOR", "XMOG" }, --Shadoweave Shoulders
	[10029] = { "-ARMOR", "XMOG" }, --Red Mageweave Shoulders
	[106446] = { "-ARMOR", "XMOG" }, --Anchorite Shoulderpads
	[82398] = { "-ARMOR", "XMOG" }, --Windwool Shoulders
	[41550] = { "-ARMOR", "XMOG" }, --Duskweave Shoulders
	[13867] = { "-ARMOR", "XMOG" }, --Runecloth Shoulders
	[24675] = { "-ARMOR", "XMOG" }, --Eldr'naan Shoulderpads
	[106644] = { "-ARMOR", "XMOG" }, --Sunscryer Shoulderpads
	[6395] = { "-ARMOR", "XMOG" }, --Silver-Thread Amice
	[106743] = { "-ARMOR", "XMOG" }, --Dark Star Shoulderpads
	[24603] = { "-ARMOR", "XMOG" }, --Starfire Mantle
	[9941] = { "-ARMOR", "XMOG" }, --Abjurer's Mantle
	[82255] = { "-ARMOR", "XMOG" }, --Waterfall Shoulderpads
	[50449] = { "-ARMOR", "XMOG" }, --Stiffened Corpse Shoulderpads
	[106710] = { "-ARMOR", "XMOG" }, --Voidwrap Shoulderpads
	[13013] = { "-ARMOR", "XMOG" }, --Elder Wizard's Mantle
	[106512] = { "-ARMOR", "XMOG" }, --Mandragoran Shoulderpads
	[37757] = { "-ARMOR", "XMOG" }, --Charlotte's Chastizing Pauldrons
	[10027] = { "-ARMOR", "XMOG" }, --Black Mageweave Shoulders
	[9850] = { "-ARMOR", "XMOG" }, --Conjurer's Mantle
	[4315] = { "-ARMOR", "XMOG" }, --Reinforced Woolen Shoulders
	[36041] = { "-ARMOR", "XMOG" }, --Condor Shoulderpads
	[4314] = { "-ARMOR", "XMOG" }, --Double-Stitched Woolen Shoulders
	[35580] = { "-ARMOR", "XMOG" }, --Skein Woven Mantle
	[66882] = { "-ARMOR", "XMOG" }, --Skeletalized Shoulderpads
	[94029] = { "-ARMOR", "XMOG" }, --Faded Spirit-Wrencher Shoulders
	[7057] = { "-ARMOR", "XMOG" }, --Green Silken Shoulders
	[24627] = { "-ARMOR", "XMOG" }, --Slavehandler Amice
	[81967] = { "-ARMOR", "XMOG" }, --Stitched Shoulderpads
	[67117] = { "-ARMOR", "XMOG" }, --Woundsealer Spaulders
	[55764] = { "-ARMOR", "XMOG" }, --Mystral Shoulderpads
	[20406] = { "-ARMOR", "XMOG" }, --Twilight Cultist Mantle
	[24595] = { "-ARMOR", "XMOG" }, --Fireheart Shoulderpads
	[35985] = { "-ARMOR", "XMOG" }, --Foothold Shoulderpads
	[35961] = { "-ARMOR", "XMOG" }, --Farshire Shoulderpads
	[36049] = { "-ARMOR", "XMOG" }, --Crystalsong Mantle
	[24667] = { "-ARMOR", "XMOG" }, --Shadow Council Mantle
	[24683] = { "-ARMOR", "XMOG" }, --Archmage Mantle
	[24643] = { "-ARMOR", "XMOG" }, --Mistyreed Shoulderpads
	[78207] = { "-ARMOR", "XMOG" }, --Replica Devout Belt
	[118817] = { "-ARMOR", "XMOG" }, --Girthbinder of N'karas
	[119336] = { "-ARMOR", "XMOG" }, --Cord of Winsome Sorrows
	[54504] = { "-ARMOR", "XMOG" }, --Belt of the Depths
	[4436] = { "-ARMOR", "XMOG" }, --Jewel-Encrusted Sash
	[14327] = { "-ARMOR", "XMOG" }, --Resplendent Belt
	[16702] = { "-ARMOR", "XMOG" }, --Dreadmist Belt
	[98608] = { "-ARMOR", "XMOG" }, --White Cloud Belt
	[21846] = { "-ARMOR", "XMOG" }, --Spellfire Belt
	[54503] = { "-ARMOR", "XMOG" }, --Dreamless Belt
	[114816] = { "-ARMOR", "XMOG" }, --Hexweave Belt
	[14194] = { "-ARMOR", "XMOG" }, --Raincaller Cord
	[45557] = { "-ARMOR", "XMOG" }, --Sash of Ancient Power
	[45558] = { "-ARMOR", "XMOG" }, --Cord of the White Dawn
	[24257] = { "-ARMOR", "XMOG" }, --Black Belt of Knowledge
	[21873] = { "-ARMOR", "XMOG" }, --Primal Mooncloth Belt
	[98612] = { "-ARMOR", "XMOG" }, --Belt of the Night Sky
	[43584] = { "-ARMOR", "XMOG" }, --Glacial Waistband
	[24255] = { "-ARMOR", "XMOG" }, --Unyielding Girdle
	[6418] = { "-ARMOR", "XMOG" }, --Aurora Sash
	[2283] = { "-ARMOR", "XMOG" }, --Rat Cloth Belt
	[14255] = { "-ARMOR", "XMOG" }, --Lunar Belt
	[14131] = { "-ARMOR", "XMOG" }, --Ritual Belt
	[98763] = { "-ARMOR", "XMOG" }, --Crafted Malevolent Gladiator's Cord of Cruelty
	[98765] = { "-ARMOR", "XMOG" }, --Crafted Malevolent Gladiator's Cord of Meditation
	[14235] = { "-ARMOR", "XMOG" }, --Embersilk Cord
	[4736] = { "-ARMOR", "XMOG" }, --Mistscape Sash
	[14435] = { "-ARMOR", "XMOG" }, --Windchaser Cinch
	[14304] = { "-ARMOR", "XMOG" }, --Bonecaster's Belt
	[14209] = { "-ARMOR", "XMOG" }, --Vital Sash
	[14309] = { "-ARMOR", "XMOG" }, --Celestial Belt
	[93428] = { "-ARMOR", "XMOG" }, --Crafted Dreadful Gladiator's Cord of Cruelty
	[98764] = { "-ARMOR", "XMOG" }, --Crafted Malevolent Gladiator's Cord of Accuracy
	[4714] = { "-ARMOR", "XMOG" }, --Silver-Thread Sash
	[6611] = { "-ARMOR", "XMOG" }, --Sage's Sash
	[93430] = { "-ARMOR", "XMOG" }, --Crafted Dreadful Gladiator's Cord of Meditation
	[14258] = { "-ARMOR", "XMOG" }, --Bloodwoven Cord
	[43969] = { "-ARMOR", "XMOG" }, --Frostsavage Belt
	[7526] = { "-ARMOR", "XMOG" }, --Gossamer Belt
	[14025] = { "-ARMOR", "XMOG" }, --Mystic's Belt
	[14454] = { "-ARMOR", "XMOG" }, --Highborne Cord
	[93429] = { "-ARMOR", "XMOG" }, --Crafted Dreadful Gladiator's Cord of Accuracy
	[75086] = { "-ARMOR", "XMOG" }, --Vicious Fireweave Belt
	[14205] = { "-ARMOR", "XMOG" }, --Thistlefur Belt
	[14143] = { "-ARMOR", "XMOG" }, --Ghostweave Belt
	[75096] = { "-ARMOR", "XMOG" }, --Vicious Embersilk Belt
	[10144] = { "-ARMOR", "XMOG" }, --High Councillor's Sash
	[3229] = { "-ARMOR", "XMOG" }, --Tarantula Silk Sash
	[10103] = { "-ARMOR", "XMOG" }, --Councillor's Sash
	[1299] = { "-ARMOR", "XMOG" }, --Lesser Belt of the Spire
	[87502] = { "-ARMOR", "XMOG" }, --Repression Belt
	[106737] = { "-ARMOR", "XMOG" }, --Dark Star Cord
	[14276] = { "-ARMOR", "XMOG" }, --Gaea's Belt
	[78879] = { "-ARMOR", "XMOG" }, --Sash of Relentless Truth
	[4329] = { "-ARMOR", "XMOG" }, --Star Belt
	[4720] = { "-ARMOR", "XMOG" }, --Nightsky Sash
	[54471] = { "-ARMOR", "XMOG" }, --Deathsilk Belt
	[106407] = { "-ARMOR", "XMOG" }, --Lunarglow Cord
	[14113] = { "-ARMOR", "XMOG" }, --Aboriginal Sash
	[4828] = { "-ARMOR", "XMOG" }, --Nightwind Belt
	[7476] = { "-ARMOR", "XMOG" }, --Regal Sash
	[24653] = { "-ARMOR", "XMOG" }, --Consortium Sash
	[106539] = { "-ARMOR", "XMOG" }, --Orunai Cord
	[24645] = { "-ARMOR", "XMOG" }, --Astralaan Belt
	[28495] = { "-ARMOR", "XMOG" }, --Windwalker's Sash
	[14217] = { "-ARMOR", "XMOG" }, --Geomancer's Cord
	[24637] = { "-ARMOR", "XMOG" }, --Mistyreed Belt
	[4785] = { "-ARMOR", "XMOG" }, --Brimstone Belt
	[16806] = { "-ARMOR", "XMOG" }, --Felheart Belt
	[14426] = { "-ARMOR", "XMOG" }, --Silksand Girdle
	[8253] = { "-ARMOR", "XMOG" }, --Imperial Red Sash
	[94059] = { "-ARMOR", "XMOG" }, --Exiled Dabbler's Cinch
	[14337] = { "-ARMOR", "XMOG" }, --Eternal Cord
	[106671] = { "-ARMOR", "XMOG" }, --Windswept Cord
	[82404] = { "-ARMOR", "XMOG" }, --Windwool Belt
	[7370] = { "-ARMOR", "XMOG" }, --Elder's Sash
	[16817] = { "-ARMOR", "XMOG" }, --Girdle of Prophecy
	[24613] = { "-ARMOR", "XMOG" }, --Vindicator Belt
	[24629] = { "-ARMOR", "XMOG" }, --Feralfen Sash
	[9799] = { "-ARMOR", "XMOG" }, --Ivycloth Sash
	[44309] = { "-ARMOR", "XMOG" }, --Sash of Jordan
	[13105] = { "-ARMOR", "XMOG" }, --Sutarn's Ring
	[14164] = { "-ARMOR", "XMOG" }, --Pagan Belt
	[13144] = { "-ARMOR", "XMOG" }, --Serenity Belt
	[14465] = { "-ARMOR", "XMOG" }, --Elunarian Belt
	[7061] = { "-ARMOR", "XMOG" }, --Earthen Silk Belt
	[24621] = { "-ARMOR", "XMOG" }, --Slavehandler Belt
	[54481] = { "-ARMOR", "XMOG" }, --Spiritmend Belt
	[41522] = { "-ARMOR", "XMOG" }, --Frostwoven Belt
	[21850] = { "-ARMOR", "XMOG" }, --Netherweave Belt
	[4328] = { "-ARMOR", "XMOG" }, --Spider Belt
	[7052] = { "-ARMOR", "XMOG" }, --Azure Silk Belt
	[8114] = { "-ARMOR", "XMOG" }, --Hibernal Sash
	[35955] = { "-ARMOR", "XMOG" }, --Farshire Belt
	[41543] = { "-ARMOR", "XMOG" }, --Duskweave Belt
	[7055] = { "-ARMOR", "XMOG" }, --Crimson Silk Belt
	[9853] = { "-ARMOR", "XMOG" }, --Conjurer's Cinch
	[66941] = { "-ARMOR", "XMOG" }, --Triple-Loop Belt
	[24661] = { "-ARMOR", "XMOG" }, --Shadow Council Chain
	[13856] = { "-ARMOR", "XMOG" }, --Runecloth Belt
	[10180] = { "-ARMOR", "XMOG" }, --Mystical Belt
	[24605] = { "-ARMOR", "XMOG" }, --Laughing Skull Waistguard
	[14173] = { "-ARMOR", "XMOG" }, --Buccaneer's Cord
	[24669] = { "-ARMOR", "XMOG" }, --Eldr'naan Belt
	[10404] = { "-ARMOR", "XMOG" }, --Durable Belt
	[81966] = { "-ARMOR", "XMOG" }, --Stitched Cord
	[36059] = { "-ARMOR", "XMOG" }, --Coldwraith Sash
	[55772] = { "-ARMOR", "XMOG" }, --Everstill Cord
	[82139] = { "-ARMOR", "XMOG" }, --Brewer's Cord
	[4708] = { "-ARMOR", "XMOG" }, --Bright Belt
	[37761] = { "-ARMOR", "XMOG" }, --Shimmerthread Girdle
	[36035] = { "-ARMOR", "XMOG" }, --Condor Belt
	[4699] = { "-ARMOR", "XMOG" }, --Seer's Belt
	[6539] = { "-ARMOR", "XMOG" }, --Willow Belt
	[35995] = { "-ARMOR", "XMOG" }, --Voldrune Sash
	[86186] = { "-ARMOR", "XMOG" }, --Gleaming Moth Cuffs
	[71265] = { "-ARMOR", "XMOG" }, --Emberflame Bracers
	[71990] = { "-ARMOR", "XMOG" }, --Dreamwraps of the Light
	[119332] = { "-ARMOR", "XMOG" }, --Bracers of Darkened Skies
	[86192] = { "-ARMOR", "XMOG" }, --Darting Damselfly Cuffs
	[14291] = { "-ARMOR", "XMOG" }, --Arachnidian Bracelets
	[14301] = { "-ARMOR", "XMOG" }, --Bonecaster's Bindings
	[47588] = { "-ARMOR", "XMOG" }, --Royal Moonshroud Bracers
	[24251] = { "-ARMOR", "XMOG" }, --Blackstrike Bracers
	[114814] = { "-ARMOR", "XMOG" }, --Hexweave Bracers
	[71989] = { "-ARMOR", "XMOG" }, --Bracers of Unconquered Power
	[14419] = { "-ARMOR", "XMOG" }, --Silksand Bracers
	[14457] = { "-ARMOR", "XMOG" }, --Elunarian Cuffs
	[14448] = { "-ARMOR", "XMOG" }, --Highborne Bracelets
	[98770] = { "-ARMOR", "XMOG" }, --Crafted Malevolent Gladiator's Cuffs of Prowess
	[9846] = { "-ARMOR", "XMOG" }, --Conjurer's Bracers
	[4045] = { "-ARMOR", "XMOG" }, --Mistscape Bracers
	[14166] = { "-ARMOR", "XMOG" }, --Buccaneer's Bracers
	[24250] = { "-ARMOR", "XMOG" }, --Bracers of Havok
	[14320] = { "-ARMOR", "XMOG" }, --Resplendent Bracelets
	[98771] = { "-ARMOR", "XMOG" }, --Crafted Malevolent Gladiator's Cuffs of Meditation
	[18263] = { "-ARMOR", "XMOG" }, --Flarecore Wraps
	[13106] = { "-ARMOR", "XMOG" }, --Glowing Magical Bracelets
	[14311] = { "-ARMOR", "XMOG" }, --Celestial Bindings
	[10213] = { "-ARMOR", "XMOG" }, --Elegant Bracers
	[98769] = { "-ARMOR", "XMOG" }, --Crafted Malevolent Gladiator's Cuffs of Accuracy
	[93436] = { "-ARMOR", "XMOG" }, --Crafted Dreadful Gladiator's Cuffs of Meditation
	[14260] = { "-ARMOR", "XMOG" }, --Bloodwoven Bracers
	[93435] = { "-ARMOR", "XMOG" }, --Crafted Dreadful Gladiator's Cuffs of Prowess
	[14366] = { "-ARMOR", "XMOG" }, --Mystic's Bracelets
	[24628] = { "-ARMOR", "XMOG" }, --Slavehandler Wristguards
	[118824] = { "-ARMOR", "XMOG" }, --Noxiia's Shackles
	[75098] = { "-ARMOR", "XMOG" }, --Vicious Embersilk Bracers
	[10136] = { "-ARMOR", "XMOG" }, --High Councillor's Bracers
	[75089] = { "-ARMOR", "XMOG" }, --Vicious Fireweave Bracers
	[106480] = { "-ARMOR", "XMOG" }, --Iyun Wristwraps
	[1351] = { "-ARMOR", "XMOG" }, --Fingerbone Bracers
	[87520] = { "-ARMOR", "XMOG" }, --Glowing Wind Bracers
	[14240] = { "-ARMOR", "XMOG" }, --Darkmist Bands
	[106678] = { "-ARMOR", "XMOG" }, --Windswept Wristwraps
	[24588] = { "-ARMOR", "XMOG" }, --Outlander's Bracers
	[54473] = { "-ARMOR", "XMOG" }, --Deathsilk Bracers
	[106612] = { "-ARMOR", "XMOG" }, --Ravendown Wristwraps
	[14330] = { "-ARMOR", "XMOG" }, --Eternal Bindings
	[14226] = { "-ARMOR", "XMOG" }, --Embersilk Bracelets
	[10173] = { "-ARMOR", "XMOG" }, --Mystical Bracers
	[45291] = { "-ARMOR", "XMOG" }, --Combustion Bracers
	[4043] = { "-ARMOR", "XMOG" }, --Aurora Bracers
	[6543] = { "-ARMOR", "XMOG" }, --Willow Bracers
	[43974] = { "-ARMOR", "XMOG" }, --Frostsavage Bracers
	[40338] = { "-ARMOR", "XMOG" }, --Bindings of Yearning
	[82402] = { "-ARMOR", "XMOG" }, --Windwool Bracers
	[24660] = { "-ARMOR", "XMOG" }, --Consortium Bracer
	[24604] = { "-ARMOR", "XMOG" }, --Starfire Wristwraps
	[54480] = { "-ARMOR", "XMOG" }, --Spiritmend Bracers
	[14279] = { "-ARMOR", "XMOG" }, --Opulent Bracers
	[3645] = { "-ARMOR", "XMOG" }, --Seer's Cuffs
	[35654] = { "-ARMOR", "XMOG" }, --Bindings of the Bastille
	[24620] = { "-ARMOR", "XMOG" }, --Vindicator Bracers
	[24652] = { "-ARMOR", "XMOG" }, --Astralaan Bracer
	[106579] = { "-ARMOR", "XMOG" }, --Gordunni Wristwraps
	[35682] = { "-ARMOR", "XMOG" }, --Rune Giant Bindings
	[9879] = { "-ARMOR", "XMOG" }, --Sorcerer Bracelets
	[24644] = { "-ARMOR", "XMOG" }, --Mistyreed Bracers
	[67088] = { "-ARMOR", "XMOG" }, --Falling Snow Bracers
	[71350] = { "-ARMOR", "XMOG" }, --Wristwraps of Arrogant Doom
	[35978] = { "-ARMOR", "XMOG" }, --Mur'ghoul Wristwraps
	[41551] = { "-ARMOR", "XMOG" }, --Duskweave Wristwraps
	[14248] = { "-ARMOR", "XMOG" }, --Lunar Bindings
	[14429] = { "-ARMOR", "XMOG" }, --Windchaser Cuffs
	[16799] = { "-ARMOR", "XMOG" }, --Arcanist Bindings
	[106414] = { "-ARMOR", "XMOG" }, --Lunarglow Wristwraps
	[36050] = { "-ARMOR", "XMOG" }, --Crystalsong Bracelets
	[9909] = { "-ARMOR", "XMOG" }, --Royal Bands
	[4308] = { "-ARMOR", "XMOG" }, --Green Linen Bracers
	[10059] = { "-ARMOR", "XMOG" }, --Duskwoven Bracers
	[94063] = { "-ARMOR", "XMOG" }, --Exiled Dabbler's Bracer
	[55706] = { "-ARMOR", "XMOG" }, --Baradin Wristwraps
	[82256] = { "-ARMOR", "XMOG" }, --Waterfall Wristwraps
	[14122] = { "-ARMOR", "XMOG" }, --Ritual Bands
	[14160] = { "-ARMOR", "XMOG" }, --Pagan Bands
	[60211] = { "-ARMOR", "XMOG" }, --Bracers of the Dark Pool
	[24668] = { "-ARMOR", "XMOG" }, --Shadow Council Bracer
	[9433] = { "-ARMOR", "XMOG" }, --Forgotten Wraps
	[14268] = { "-ARMOR", "XMOG" }, --Gaea's Cuffs
	[14375] = { "-ARMOR", "XMOG" }, --Sanguine Cuffs
	[16819] = { "-ARMOR", "XMOG" }, --Vambraces of Prophecy
	[6563] = { "-ARMOR", "XMOG" }, --Shimmering Bracers
	[82036] = { "-ARMOR", "XMOG" }, --Reed Wristwraps
	[13107] = { "-ARMOR", "XMOG" }, --Magiskull Cuffs
	[24676] = { "-ARMOR", "XMOG" }, --Eldr'naan Bracelets
	[36066] = { "-ARMOR", "XMOG" }, --Coldwraith Bindings
	[24684] = { "-ARMOR", "XMOG" }, --Archmage Bracelets
	[35986] = { "-ARMOR", "XMOG" }, --Foothold Cuffs
	[24612] = { "-ARMOR", "XMOG" }, --Laughing Skull Bracelets

--	19 Bracket Twink Items
	[790] = { "-WEAPON", "TWINK" }, -- Forester's Axe -- Has useless random enchants
	[890] = { "-WEAPON", "TWINK" }, -- Twisted Chanter's Staff
	[1121] = { "-ARMOR", "TWINK" }, -- Feet of the Lynx
	[1318] = { "-WEAPON", "TWINK" }, -- Night Reaver
	[1458] = { "-WEAPON", "TWINK" }, -- Shadowhide Maul
	[1482] = { "-WEAPON", "TWINK" }, -- Shadowfang
	[2046] = { "-WEAPON", "TWINK" }, -- Bluegill Kukri
	[2059] = { "-ARMOR", "TWINK" }, -- Sentry Cloak
	[2256] = { "-WEAPON", "TWINK" }, -- Skeletal Club
	[2314] = { "-ARMOR", "TWINK" }, -- Toughened Leather Armor
	[2866] = { "-ARMOR", "TWINK" }, -- Rough Bronze Cuirass
	[2911] = { "-ARMOR", "TWINK" }, -- Keller's Girdle
	[3018] = { "-ARMOR", "TWINK" }, -- Hide of Lupos
	[3022] = { "-ARMOR", "TWINK" }, -- Bluegill Breeches
	[3039] = { "-WEAPON", "TWINK" }, -- Short Ash Bow
	[3057] = { "-ARMOR", "TWINK" }, -- Forest Leather Boots
	[3065] = { "-ARMOR", "TWINK" }, -- Bright Boots
	[3066] = { "-ARMOR", "TWINK" }, -- Bright Gloves
	[3074] = { "-ARMOR", "TWINK" }, -- Smoldering Gloves
	[3076] = { "-ARMOR", "TWINK" }, -- Smoldering Boots
	[3202] = { "-ARMOR", "TWINK" }, -- Forest Leather Bracers
	[3229] = { "-ARMOR", "TWINK" }, -- Tarantula Silk Sash
	[3429] = { "-ARMOR", "TWINK" }, -- Guardsman Belt
	[3647] = { "-ARMOR", "TWINK" }, -- Bright Bracers
	[4315] = { "-ARMOR", "TWINK" }, -- Reinforced Woolen Shoulders
	[4320] = { "-ARMOR", "TWINK" }, -- Spidersilk Boots
	[4372] = { "-WEAPON", "TWINK" }, -- Lovingly Crafted Boomstick
	[4444] = { "-ARMOR", "TWINK" }, -- Black Husk Shield
	[4706] = { "-ARMOR", "TWINK" }, -- Lambent Scale Cloak
	[4708] = { "-ARMOR", "TWINK" }, -- Bright Belt
	[4785] = { "-ARMOR", "TWINK" }, -- Brimstone Belt
	[4792] = { "-ARMOR", "TWINK" }, -- Spirit Cloak
	[4793] = { "-ARMOR", "TWINK" }, -- Sylvan Cloak
	[4799] = { "-ARMOR", "TWINK" }, -- Antiquated Cloak
	[4800] = { "-ARMOR", "TWINK" }, -- Mighty Chain Pants
	[4816] = { "-ARMOR", "TWINK" }, -- Legionnaire's Leggings
	[4821] = { "-ARMOR", "TWINK" }, -- Bear Buckler
	[4822] = { "-ARMOR", "TWINK" }, -- Owl's Disk
	[4998] = { "-ARMOR", "TWINK" }, -- Blood Ring
	[5540] = { "-WEAPON", "TWINK" }, -- Pearl-Handled Dagger
	[5750] = { "-ARMOR", "TWINK" }, -- Warchief's Girdle
	[5961] = { "-ARMOR", "TWINK" }, -- Dark Leather Pants
	[5969] = { "-ARMOR", "TWINK" }, -- Regent's Cloak
	[5975] = { "-ARMOR", "TWINK" }, -- Ruffian Belt
	[6264] = { "-ARMOR", "TWINK" }, -- Greater Adept's Robe
	[6381] = { "-ARMOR", "TWINK" }, -- Bright Cloak
	[6382] = { "-ARMOR", "TWINK" }, -- Forest Leather Belt
	[6383] = { "-ARMOR", "TWINK" }, -- Forest Buckler
	[6568] = { "-ARMOR", "TWINK" }, -- Shimmering Trousers -- Has useless random enchants
	[6572] = { "-ARMOR", "TWINK" }, -- Defender Shield -- Has useless random enchants
	[6573] = { "-ARMOR", "TWINK" }, -- Defender Boots -- Has useless random enchants
	[6577] = { "-ARMOR", "TWINK" }, -- Defender Gauntlets -- Has useless random enchants
	[6578] = { "-ARMOR", "TWINK" }, -- Defender Leggings -- Has useless random enchants
	[6580] = { "-ARMOR", "TWINK" }, -- Defender Tunic -- Has useless random enchants
	[6586] = { "-ARMOR", "TWINK" }, -- Scouting Gloves -- Has useless random enchants
	[6587] = { "-ARMOR", "TWINK" }, -- Scouting Trousers -- Has useless random enchants
	[7285] = { "-ARMOR", "TWINK" }, -- Nimble Leather Gloves
	[9767] = { "-ARMOR", "TWINK" }, -- Greenweave Sandals -- Has useless random enchants
	[9782] = { "-ARMOR", "TWINK" }, -- Bandit Jerkin -- Has useless random enchants
	[9805] = { "-ARMOR", "TWINK" }, -- Superior Cloak -- Has useless random enchants
	[9811] = { "-ARMOR", "TWINK" }, -- Fortified Bracers -- Has useless random enchants
	[9814] = { "-ARMOR", "TWINK" }, -- Fortified Belt -- Has useless random enchants
	[11982] = { "-ARMOR", "TWINK" }, -- Viridian Band
	[12054] = { "-ARMOR", "TWINK" }, -- Demon Band
	[12990] = { "-WEAPON", "TWINK" }, -- Razor's Edge
	[12992] = { "-WEAPON", "TWINK" }, -- Searing Blade
	[12994] = { "-ARMOR", "TWINK" }, -- Thorbia's Gauntlets
	[12996] = { "-ARMOR", "TWINK" }, -- Band of Purification
	[12997] = { "-ARMOR", "TWINK" }, -- Redbeard Crest
	[14127] = { "-ARMOR", "TWINK" }, -- Ritual Shroud
	[14133] = { "-ARMOR", "TWINK" }, -- Ritual Tunic
	[14162] = { "-ARMOR", "TWINK" }, -- Pagan Mitts -- Has useless random enchants
	[14172] = { "-ARMOR", "TWINK" }, -- Buccaneer's Robes
	[14175] = { "-ARMOR", "TWINK" }, -- Buccaneer's Vest
	[14179] = { "-ARMOR", "TWINK" }, -- Watcher's Cape
	[14369] = { "-ARMOR", "TWINK" }, -- Mystic's Wrap
	[14371] = { "-ARMOR", "TWINK" }, -- Mystic's Robe
	[14374] = { "-ARMOR", "TWINK" }, -- Sanguine Sandals
	[14562] = { "-ARMOR", "TWINK" }, -- Prospector's Chestpiece
	[14567] = { "-ARMOR", "TWINK" }, -- Bristlebark Belt
	[14568] = { "-ARMOR", "TWINK" }, -- Bristlebark Boots
	[14572] = { "-ARMOR", "TWINK" }, -- Bristlebark Gloves
	[14730] = { "-ARMOR", "TWINK" }, -- War Paint Chestpiece
	[14742] = { "-ARMOR", "TWINK" }, -- Hulking Boots
	[14747] = { "-ARMOR", "TWINK" }, -- Hulking Gauntlets
	[15113] = { "-ARMOR", "TWINK" }, -- Rigid Buckler -- Has useless random enchants
	[15117] = { "-ARMOR", "TWINK" }, -- Rigid Leggings -- Has useless random enchants
	[15329] = { "-ARMOR", "TWINK" }, -- Wrangler's Belt -- Has useless random enchants
	[15331] = { "-ARMOR", "TWINK" }, -- Wrangler's Wristbands -- Has useless random enchants
	[15500] = { "-ARMOR", "TWINK" }, -- Outrunner's Chestguard -- Has useless random enchants
	[15511] = { "-ARMOR", "TWINK" }, -- Grunt's Legguards -- Has useless random enchants
	[15512] = { "-ARMOR", "TWINK" }, -- Grunt's Shield -- Has useless random enchants
	[15519] = { "-ARMOR", "TWINK" }, -- Spiked Chain Cloak -- Has useless random enchants
	[15526] = { "-ARMOR", "TWINK" }, -- Sentry's Cape -- Has useless random enchants
	[15912] = { "-ARMOR", "TWINK" }, -- Buccaneer's Orb -- Has useless random enchants
	[15946] = { "-ARMOR", "TWINK" }, -- Mystic's Sphere
	[15972] = { "-ARMOR", "TWINK" }, -- Ritual Stein -- Has useless random enchants
	[20823] = { "-ARMOR", "TWINK" }, -- Gloom Band
	[21933] = { "-ARMOR", "TWINK" }, -- Thick Bronze Necklace
	[21934] = { "-ARMOR", "TWINK" }, -- Ornate Tigerseye Necklace
	[25438] = { "-ARMOR", "TWINK" }, -- Malachite Pendant
	[30804] = { "-ARMOR", "TWINK" }, -- Bronze Band of Force
	[45626] = { "-ARMOR", "TWINK" }, -- Spidersilk Drape
--	29 Bracket Twink Items
	[1997] = { "-ARMOR", "TWINK" }, -- Pressed Felt Robe
	[2080] = { "-WEAPON", "TWINK" }, -- Hillborne Axe -- Has useless random enchants
	[2299] = { "-WEAPON", "TWINK" }, -- Burning War Axe
	[3020] = { "-ARMOR", "TWINK" }, -- Enduring Cap
	[3037] = { "-WEAPON", "TWINK" }, -- Whipwood Recurve Bow
	[3185] = { "-WEAPON", "TWINK" }, -- Acrobatic Staff -- Has useless random enchants
	[3836] = { "-ARMOR", "TWINK" }, -- Green Iron Helm
	[3843] = { "-ARMOR", "TWINK" }, -- Golden Scale Leggings
	[4040] = { "-ARMOR", "TWINK" }, -- Nightsky Gloves
	[4055] = { "-ARMOR", "TWINK" }, -- Insignia Boots
	[4258] = { "-ARMOR", "TWINK" }, -- Guardian Belt
	[4322] = { "-ARMOR", "TWINK" }, -- Enchanter's Cowl
	[4323] = { "-ARMOR", "TWINK" }, -- Shadow Hood
	[4455] = { "-ARMOR", "TWINK" }, -- Raptor Hide Harness
	[4456] = { "-ARMOR", "TWINK" }, -- Raptor Hide Belt
	[4476] = { "-ARMOR", "TWINK" }, -- Beastwalker Robe
	[4477] = { "-ARMOR", "TWINK" }, -- Nefarious Buckler
	[4717] = { "-ARMOR", "TWINK" }, -- Mail Combat Belt
	[4720] = { "-ARMOR", "TWINK" }, -- Nightsky Sash
	[5180] = { "-ARMOR", "TWINK" }, -- Necklace of Harmony
	[5181] = { "-ARMOR", "TWINK" }, -- Vibrant Silk Cape
	[5782] = { "-ARMOR", "TWINK" }, -- Thick Murloc Armor
	[5819] = { "-ARMOR", "TWINK" }, -- Sunblaze Coif
	[5963] = { "-ARMOR", "TWINK" }, -- Barbaric Leggings
	[6406] = { "-ARMOR", "TWINK" }, -- Nightsky Boots
	[6407] = { "-ARMOR", "TWINK" }, -- Nightsky Wristbands
	[6408] = { "-ARMOR", "TWINK" }, -- Insignia Gloves
	[6409] = { "-ARMOR", "TWINK" }, -- Insignia Belt
	[6410] = { "-ARMOR", "TWINK" }, -- Insignia Bracers
	[7051] = { "-ARMOR", "TWINK" }, -- Earthen Vest
	[7065] = { "-ARMOR", "TWINK" }, -- Green Silk Armor
	[7330] = { "-ARMOR", "TWINK" }, -- Infiltrator Buckler -- Has useless random enchants
	[7331] = { "-ARMOR", "TWINK" }, -- Phalanx Shield -- Has useless random enchants
	[7354] = { "-ARMOR", "TWINK" }, -- Elder's Boots -- Has useless random enchants
	[7357] = { "-ARMOR", "TWINK" }, -- Elder's Hat -- Has useless random enchants
	[7367] = { "-ARMOR", "TWINK" }, -- Elder's Mantle -- Has useless random enchants
	[7368] = { "-ARMOR", "TWINK" }, -- Elder's Pants -- Has useless random enchants
	[7373] = { "-ARMOR", "TWINK" }, -- Dusky Leather Leggings
	[7408] = { "-ARMOR", "TWINK" }, -- Infiltrator Shoulders -- Has useless random enchants
	[7409] = { "-ARMOR", "TWINK" }, -- Infiltrator Boots -- Has useless random enchants
	[7413] = { "-ARMOR", "TWINK" }, -- Infiltrator Cap -- Has useless random enchants
	[7414] = { "-ARMOR", "TWINK" }, -- Infiltrator Pants -- Has useless random enchants
	[7417] = { "-ARMOR", "TWINK" }, -- Phalanx Boots -- Has useless random enchants
	[7420] = { "-ARMOR", "TWINK" }, -- Phalanx Headguard -- Has useless random enchants
	[7421] = { "-ARMOR", "TWINK" }, -- Phalanx Gauntlets -- Has useless random enchants
	[7423] = { "-ARMOR", "TWINK" }, -- Phalanx Leggings -- Has useless random enchants
	[7424] = { "-ARMOR", "TWINK" }, -- Phalanx Spaulders -- Has useless random enchants
	[7460] = { "-ARMOR", "TWINK" }, -- Knight's Cloak -- Has useless random enchants
	[7728] = { "-ARMOR", "TWINK" }, -- Beguiler Robes
	[7730] = { "-WEAPON", "TWINK" }, -- Cobalt Crusher
	[7752] = { "-WEAPON", "TWINK" }, -- Dreamslayer
	[9395] = { "-ARMOR", "TWINK" }, -- Gloves of Old
	[9405] = { "-ARMOR", "TWINK" }, -- Girdle of Golem Strength
	[9819] = { "-ARMOR", "TWINK" }, -- Durable Tunic
	[9825] = { "-ARMOR", "TWINK" }, -- Durable Pants -- Has useless random enchants
	[9826] = { "-ARMOR", "TWINK" }, -- Durable Robe
	[9833] = { "-ARMOR", "TWINK" }, -- Scaled Leather Leggings -- Has useless random enchants
	[9835] = { "-ARMOR", "TWINK" }, -- Scaled Leather Tunic -- Has useless random enchants
	[9836] = { "-ARMOR", "TWINK" }, -- Banded Armor -- Has useless random enchants
	[9843] = { "-ARMOR", "TWINK" }, -- Banded Shield -- Has useless random enchants
	[9847] = { "-ARMOR", "TWINK" }, -- Conjurer's Cloak
	[9853] = { "-ARMOR", "TWINK" }, -- Conjurer's Cinch -- Has useless random enchants
	[9857] = { "-ARMOR", "TWINK" }, -- Archer's Bracers -- Has useless random enchants
	[9860] = { "-ARMOR", "TWINK" }, -- Archer's Cloak -- Has useless random enchants
	[9865] = { "-ARMOR", "TWINK" }, -- Renegade Bracers -- Has useless random enchants
	[9867] = { "-ARMOR", "TWINK" }, -- Renegade Cloak -- Has useless random enchants
	[11996] = { "-ARMOR", "TWINK" }, -- Basalt Ring -- Has useless random enchants
	[12009] = { "-ARMOR", "TWINK" }, -- Tundra Ring -- Has useless random enchants
	[12039] = { "-ARMOR", "TWINK" }, -- Tundra Necklace -- Has useless random enchants
	[12248] = { "-WEAPON", "TWINK" }, -- Daring Dirk
	[13033] = { "-WEAPON", "TWINK" }, -- Zealot Blade
	[13063] = { "-WEAPON", "TWINK" }, -- Starfaller
	[13087] = { "-ARMOR", "TWINK" }, -- River Pride Choker
	[13108] = { "-ARMOR", "TWINK" }, -- Tigerstrike Mantle
	[13137] = { "-WEAPON", "TWINK" }, -- Ironweaver
	[14199] = { "-ARMOR", "TWINK" }, -- Thistlefur Gloves -- Has useless random enchants
	[14201] = { "-ARMOR", "TWINK" }, -- Thistlefur Mantle -- Has useless random enchants
	[14209] = { "-ARMOR", "TWINK" }, -- Vital Sash -- Has useless random enchants
	[14211] = { "-ARMOR", "TWINK" }, -- Vital Handwraps -- Has useless random enchants
	[14214] = { "-ARMOR", "TWINK" }, -- Vital Boots -- Has useless random enchants
	[14219] = { "-ARMOR", "TWINK" }, -- Geomancer's Cloak
	[14398] = { "-ARMOR", "TWINK" }, -- Resilient Tunic
	[14401] = { "-ARMOR", "TWINK" }, -- Resilient Cap
	[14404] = { "-ARMOR", "TWINK" }, -- Resilient Leggings
	[14405] = { "-ARMOR", "TWINK" }, -- Resilient Robe
	[14409] = { "-ARMOR", "TWINK" }, -- Stonecloth Cape
	[14414] = { "-ARMOR", "TWINK" }, -- Stonecloth Belt
	[14416] = { "-ARMOR", "TWINK" }, -- Stonecloth Bindings
	[14581] = { "-ARMOR", "TWINK" }, -- Dokebi Chestguard
	[14759] = { "-ARMOR", "TWINK" }, -- Enduring Bracers
	[14761] = { "-ARMOR", "TWINK" }, -- Enduring Belt
	[15130] = { "-ARMOR", "TWINK" }, -- Cutthroat's Vest -- Has useless random enchants
	[15133] = { "-ARMOR", "TWINK" }, -- Cutthroat's Buckler -- Has useless random enchants
	[15137] = { "-ARMOR", "TWINK" }, -- Cutthroat's Mitts -- Has useless random enchants
	[15139] = { "-ARMOR", "TWINK" }, -- Cutthroat's Pants -- Has useless random enchants
	[15140] = { "-ARMOR", "TWINK" }, -- Cutthroat's Mantle -- Has useless random enchants
	[15143] = { "-ARMOR", "TWINK" }, -- Ghostwalker Bindings -- Has useless random enchants
	[15147] = { "-ARMOR", "TWINK" }, -- Ghostwalker Cloak -- Has useless random enchants
	[15148] = { "-ARMOR", "TWINK" }, -- Ghostwalker Belt -- Has useless random enchants
	[15225] = { "-WEAPON", "TWINK" }, -- Sequoia Hammer
	[15339] = { "-ARMOR", "TWINK" }, -- Pathfinder Hat -- Has useless random enchants
	[15349] = { "-ARMOR", "TWINK" }, -- Headhunter's Belt -- Has useless random enchants
	[15350] = { "-ARMOR", "TWINK" }, -- Headhunter's Slippers -- Has useless random enchants
	[15352] = { "-ARMOR", "TWINK" }, -- Headhunter's Buckler -- Has useless random enchants
	[15355] = { "-ARMOR", "TWINK" }, -- Headhunter's Mitts -- Has useless random enchants
	[15536] = { "-ARMOR", "TWINK" }, -- Wicked Chain Chestpiece -- Has useless random enchants
	[15540] = { "-ARMOR", "TWINK" }, -- Wicked Chain Helmet
	[15541] = { "-ARMOR", "TWINK" }, -- Wicked Chain Legguards -- Has useless random enchants
	[15543] = { "-ARMOR", "TWINK" }, -- Wicked Chain Shield -- Has useless random enchants
	[15553] = { "-ARMOR", "TWINK" }, -- Thick Scale Shoulder Pads -- Has useless random enchants
	[15554] = { "-ARMOR", "TWINK" }, -- Pillager's Girdle -- Has useless random enchants
	[15555] = { "-ARMOR", "TWINK" }, -- Pillager's Boots -- Has useless random enchants
	[15560] = { "-ARMOR", "TWINK" }, -- Pillager's Gloves -- Has useless random enchants
	[15568] = { "-ARMOR", "TWINK" }, -- Marauder's Cloak -- Has useless random enchants
	[15935] = { "-ARMOR", "TWINK" }, -- Durable Rod -- Has useless random enchants
	[15962] = { "-ARMOR", "TWINK" }, -- Satyr's Rod
	[45627] = { "-ARMOR", "TWINK" }, -- Amulet of Truesight
--	39 Bracket Twink Items
	[1521] = { "-WEAPON", "TWINK" }, -- Lumbering Ogre Axe
	[1613] = { "-WEAPON", "TWINK" }, -- Spiritchaser Staff -- Has useless random enchants
	[1714] = { "-ARMOR", "TWINK" }, -- Necklace of Calisea
	[1718] = { "-ARMOR", "TWINK" }, -- Basilisk Hide Pants
	[1980] = { "-ARMOR", "TWINK" }, -- Underworld Band
	[1982] = { "-WEAPON", "TWINK" }, -- Nightblade
	[3187] = { "-WEAPON", "TWINK" }, -- Sacrificial Kris -- Has useless random enchants
	[3430] = { "-WEAPON", "TWINK" }, -- Sniper Rifle -- Has useless random enchants
	[4047] = { "-ARMOR", "TWINK" }, -- Mistscape Boots
	[4063] = { "-ARMOR", "TWINK" }, -- Imperial Leather Gloves
	[4734] = { "-ARMOR", "TWINK" }, -- Mistscape Mantle
	[4737] = { "-ARMOR", "TWINK" }, -- Imperial Leather Spaulders
	[6428] = { "-ARMOR", "TWINK" }, -- Mistscape Gloves
	[6429] = { "-ARMOR", "TWINK" }, -- Mistscape Wizard Hat
	[6431] = { "-ARMOR", "TWINK" }, -- Imperial Leather Boots
	[6433] = { "-ARMOR", "TWINK" }, -- Imperial Leather Helm
	[7469] = { "-ARMOR", "TWINK" }, -- Regal Leggings -- Has useless random enchants
	[7478] = { "-ARMOR", "TWINK" }, -- Ranger Leggings -- Has useless random enchants
	[7486] = { "-ARMOR", "TWINK" }, -- Captain's Breastplate -- Has useless random enchants
	[7487] = { "-ARMOR", "TWINK" }, -- Captain's Leggings -- Has useless random enchants
	[7491] = { "-ARMOR", "TWINK" }, -- Captain's Shoulderguards -- Has useless random enchants
	[7495] = { "-ARMOR", "TWINK" }, -- Captain's Buckler -- Has useless random enchants
	[7496] = { "-ARMOR", "TWINK" }, -- Field Plate Shield -- Has useless random enchants
	[7524] = { "-ARMOR", "TWINK" }, -- Gossamer Cape -- Has useless random enchants
	[7533] = { "-ARMOR", "TWINK" }, -- Cabalist Cloak
	[7544] = { "-ARMOR", "TWINK" }, -- Champion's Cape -- Has useless random enchants
	[7924] = { "-ARMOR", "TWINK" }, -- Mithril Scale Bracers
	[7942] = { "-WEAPON", "TWINK" }, -- Blue Glittering Axe
	[8194] = { "-WEAPON", "TWINK" }, -- Goblin Nutcracker
	[8196] = { "-WEAPON", "TWINK" }, -- Ebon Scimitar
	[8200] = { "-ARMOR", "TWINK" }, -- Big Voodoo Robe
	[8201] = { "-ARMOR", "TWINK" }, -- Big Voodoo Mask
	[8210] = { "-ARMOR", "TWINK" }, -- Wild Leather Shoulders
	[9874] = { "-ARMOR", "TWINK" }, -- Sorcerer Drape
	[9882] = { "-ARMOR", "TWINK" }, -- Sorcerer Sphere -- Has useless random enchants
	[9884] = { "-ARMOR", "TWINK" }, -- Sorcerer Robe
	[9887] = { "-ARMOR", "TWINK" }, -- Huntsman's Armor
	[9906] = { "-ARMOR", "TWINK" }, -- Royal Sash -- Has useless random enchants
	[9907] = { "-ARMOR", "TWINK" }, -- Royal Boots -- Has useless random enchants
	[9908] = { "-ARMOR", "TWINK" }, -- Royal Cape
	[9909] = { "-ARMOR", "TWINK" }, -- Royal Bands
	[9910] = { "-ARMOR", "TWINK" }, -- Royal Gloves -- Has useless random enchants
	[9916] = { "-ARMOR", "TWINK" }, -- Tracker's Belt -- Has useless random enchants
	[9917] = { "-ARMOR", "TWINK" }, -- Tracker's Boots -- Has useless random enchants
	[9919] = { "-ARMOR", "TWINK" }, -- Tracker's Cloak
	[9920] = { "-ARMOR", "TWINK" }, -- Tracker's Gloves -- Has useless random enchants
	[9925] = { "-ARMOR", "TWINK" }, -- Tracker's Wristguards -- Has useless random enchants
	[9926] = { "-ARMOR", "TWINK" }, -- Brigade Boots -- Has useless random enchants
	[9930] = { "-ARMOR", "TWINK" }, -- Brigade Gauntlets -- Has useless random enchants
	[9931] = { "-ARMOR", "TWINK" }, -- Brigade Girdle -- Has useless random enchants
	[9932] = { "-ARMOR", "TWINK" }, -- Brigade Circlet -- Has useless random enchants
	[9934] = { "-ARMOR", "TWINK" }, -- Brigade Pauldrons -- Has useless random enchants
	[10003] = { "-ARMOR", "TWINK" }, -- Black Mageweave Gloves
	[10004] = { "-ARMOR", "TWINK" }, -- Shadoweave Robe
	[10007] = { "-ARMOR", "TWINK" }, -- Red Mageweave Vest
	[10008] = { "-ARMOR", "TWINK" }, -- White Bandit Mask
	[10009] = { "-ARMOR", "TWINK" }, -- Red Mageweave Pants
	[11987] = { "-ARMOR", "TWINK" }, -- Iridium Circle
	[12031] = { "-ARMOR", "TWINK" }, -- Lodestone Necklace -- Has useless random enchants
	[12254] = { "-ARMOR", "TWINK" }, -- Well Oiled Cloak
	[13029] = { "-ARMOR", "TWINK" }, -- Umbral Crystal
	[13100] = { "-ARMOR", "TWINK" }, -- Furen's Boots
	[13132] = { "-ARMOR", "TWINK" }, -- Skeletal Shoulders
	[14242] = { "-ARMOR", "TWINK" }, -- Darkmist Pants -- Has useless random enchants
	[14243] = { "-ARMOR", "TWINK" }, -- Darkmist Mantle -- Has useless random enchants
	[14246] = { "-ARMOR", "TWINK" }, -- Darkmist Wizard Hat -- Has useless random enchants
	[14247] = { "-ARMOR", "TWINK" }, -- Lunar Mantle -- Has useless random enchants
	[14253] = { "-ARMOR", "TWINK" }, -- Lunar Handwraps -- Has useless random enchants
	[14260] = { "-ARMOR", "TWINK" }, -- Bloodwoven Bracers
	[14261] = { "-ARMOR", "TWINK" }, -- Bloodwoven Cloak
	[14417] = { "-ARMOR", "TWINK" }, -- Silksand Tunic
	[14425] = { "-ARMOR", "TWINK" }, -- Silksand Wraps
	[14428] = { "-ARMOR", "TWINK" }, -- Windchaser Footpads
	[14429] = { "-ARMOR", "TWINK" }, -- Windchaser Cuffs
	[14431] = { "-ARMOR", "TWINK" }, -- Windchaser Handguards
	[14435] = { "-ARMOR", "TWINK" }, -- Windchaser Cinch
	[14601] = { "-ARMOR", "TWINK" }, -- Warden's Wraps
	[14605] = { "-ARMOR", "TWINK" }, -- Warden's Woolies
	[14654] = { "-ARMOR", "TWINK" }, -- Scorpashi Wristbands
	[14774] = { "-ARMOR", "TWINK" }, -- Ravager's Crown
	[14775] = { "-ARMOR", "TWINK" }, -- Ravager's Woolies
	[14776] = { "-ARMOR", "TWINK" }, -- Ravager's Mantle
	[14777] = { "-ARMOR", "TWINK" }, -- Ravager's Shield
	[14781] = { "-ARMOR", "TWINK" }, -- Khan's Cloak
	[14825] = { "-ARMOR", "TWINK" }, -- Symbolic Crest
	[15156] = { "-ARMOR", "TWINK" }, -- Nocturnal Cap -- Has useless random enchants
	[15161] = { "-ARMOR", "TWINK" }, -- Imposing Belt -- Has useless random enchants
	[15163] = { "-ARMOR", "TWINK" }, -- Imposing Bracers
	[15169] = { "-ARMOR", "TWINK" }, -- Imposing Shoulders -- Has useless random enchants
	[15370] = { "-ARMOR", "TWINK" }, -- Wolf Rider's Boots -- Has useless random enchants
	[15372] = { "-ARMOR", "TWINK" }, -- Wolf Rider's Gloves -- Has useless random enchants
	[15374] = { "-ARMOR", "TWINK" }, -- Wolf Rider's Leggings -- Has useless random enchants
	[15375] = { "-ARMOR", "TWINK" }, -- Wolf Rider's Shoulder Pads -- Has useless random enchants
	[15591] = { "-ARMOR", "TWINK" }, -- Steadfast Breastplate -- Has useless random enchants
	[15592] = { "-ARMOR", "TWINK" }, -- Steadfast Buckler -- Has useless random enchants
	[15599] = { "-ARMOR", "TWINK" }, -- Ancient Greaves -- Has useless random enchants
	[15607] = { "-ARMOR", "TWINK" }, -- Ancient Legguards -- Has useless random enchants
	[15608] = { "-ARMOR", "TWINK" }, -- Ancient Pauldrons -- Has useless random enchants
	[15610] = { "-ARMOR", "TWINK" }, -- Bonelink Bracers -- Has useless random enchants
	[15611] = { "-ARMOR", "TWINK" }, -- Bonelink Cape -- Has useless random enchants
	[15612] = { "-ARMOR", "TWINK" }, -- Bonelink Gauntlets -- Has useless random enchants
--	49 Bracket Twink Items
	[810] = { "-WEAPON", "TWINK" }, -- Hammer of the Northern Wind
	[812] = { "-WEAPON", "TWINK" }, -- Glowing Brightwood Staff
	[1203] = { "-ARMOR", "TWINK" }, -- Aegis of Stormwind
	[1721] = { "-WEAPON", "TWINK" }, -- Viking Warhammer
	[2163] = { "-WEAPON", "TWINK" }, -- Shadowblade
	[2824] = { "-WEAPON", "TWINK" }, -- Hurricane
	[3075] = { "-ARMOR", "TWINK" }, -- Eye of Flame
	[5266] = { "-ARMOR", "TWINK" }, -- Eye of Adaegus
	[8251] = { "-ARMOR", "TWINK" }, -- Imperial Red Pants
	[8254] = { "-ARMOR", "TWINK" }, -- Imperial Red Circlet
	[8261] = { "-ARMOR", "TWINK" }, -- Serpentskin Helm
	[8262] = { "-ARMOR", "TWINK" }, -- Serpentskin Leggings
	[8263] = { "-ARMOR", "TWINK" }, -- Serpentskin Spaulders
	[8267] = { "-ARMOR", "TWINK" }, -- Ebonhold Gauntlets
	[8268] = { "-ARMOR", "TWINK" }, -- Ebonhold Girdle
	[8272] = { "-ARMOR", "TWINK" }, -- Ebonhold Shoulderpads
	[8316] = { "-ARMOR", "TWINK" }, -- Alabaster Plate Greaves
	[9943] = { "-ARMOR", "TWINK" }, -- Abjurer's Robe -- Has useless random enchants
	[9944] = { "-ARMOR", "TWINK" }, -- Abjurer's Crystal -- Has useless random enchants
	[9946] = { "-ARMOR", "TWINK" }, -- Abjurer's Tunic
	[9950] = { "-ARMOR", "TWINK" }, -- Chieftain's Breastplate
	[10064] = { "-ARMOR", "TWINK" }, -- Duskwoven Pants -- Has useless random enchants
	[10074] = { "-ARMOR", "TWINK" }, -- Righteous Leggings -- Has useless random enchants
	[10077] = { "-ARMOR", "TWINK" }, -- Lord's Breastplate -- Has useless random enchants
	[10078] = { "-ARMOR", "TWINK" }, -- Lord's Crest -- Has useless random enchants
	[10093] = { "-ARMOR", "TWINK" }, -- Revenant Deflector -- Has useless random enchants
	[10096] = { "-ARMOR", "TWINK" }, -- Councillor's Cuffs -- Has useless random enchants
	[10098] = { "-ARMOR", "TWINK" }, -- Councillor's Cloak -- Has useless random enchants
	[10103] = { "-ARMOR", "TWINK" }, -- Councillor's Sash -- Has useless random enchants
	[10107] = { "-ARMOR", "TWINK" }, -- Wanderer's Bracers -- Has useless random enchants
	[10108] = { "-ARMOR", "TWINK" }, -- Wanderer's Cloak -- Has useless random enchants
	[10109] = { "-ARMOR", "TWINK" }, -- Wanderer's Belt -- Has useless random enchants
	[10120] = { "-ARMOR", "TWINK" }, -- Ornate Cloak -- Has useless random enchants
	[10126] = { "-ARMOR", "TWINK" }, -- Ornate Bracers -- Has useless random enchants
	[10128] = { "-ARMOR", "TWINK" }, -- Revenant Chestplate -- Has useless random enchants
	[10166] = { "-ARMOR", "TWINK" }, -- Templar Girdle -- Has useless random enchants
	[10171] = { "-ARMOR", "TWINK" }, -- Templar Bracers -- Has useless random enchants
	[10173] = { "-ARMOR", "TWINK" }, -- Mystical Bracers -- Has useless random enchants
	[10176] = { "-ARMOR", "TWINK" }, -- Mystical Gloves -- Has useless random enchants
	[10179] = { "-ARMOR", "TWINK" }, -- Mystical Boots -- Has useless random enchants
	[10183] = { "-ARMOR", "TWINK" }, -- Swashbuckler's Boots -- Has useless random enchants
	[10186] = { "-ARMOR", "TWINK" }, -- Swashbuckler's Gloves -- Has useless random enchants
	[10192] = { "-ARMOR", "TWINK" }, -- Crusader's Boots -- Has useless random enchants
	[10198] = { "-ARMOR", "TWINK" }, -- Crusader's Helm -- Has useless random enchants
	[10199] = { "-ARMOR", "TWINK" }, -- Crusader's Leggings -- Has useless random enchants
	[10200] = { "-ARMOR", "TWINK" }, -- Crusader's Pauldrons -- Has useless random enchants
	[10241] = { "-ARMOR", "TWINK" }, -- Heavy Lamellar Helm -- Has useless random enchants
	[10244] = { "-ARMOR", "TWINK" }, -- Heavy Lamellar Leggings -- Has useless random enchants
	[10245] = { "-ARMOR", "TWINK" }, -- Heavy Lamellar Pauldrons -- Has useless random enchants
	[12002] = { "-ARMOR", "TWINK" }, -- Marble Circle -- Has useless random enchants
	[12014] = { "-ARMOR", "TWINK" }, -- Arctic Ring -- Has useless random enchants
	[12025] = { "-ARMOR", "TWINK" }, -- Selenium Chain -- Has useless random enchants
	[12034] = { "-ARMOR", "TWINK" }, -- Marble Necklace -- Has useless random enchants
	[12425] = { "-ARMOR", "TWINK" }, -- Imperial Plate Bracers
	[12624] = { "-ARMOR", "TWINK" }, -- Wildthorn Mail
	[13014] = { "-WEAPON", "TWINK" }, -- Axe of Rin'ji
	[13111] = { "-ARMOR", "TWINK" }, -- Sandals of the Insurgent
	[13126] = { "-ARMOR", "TWINK" }, -- Battlecaller Gauntlets
	[13144] = { "-ARMOR", "TWINK" }, -- Serenity Belt
	[13860] = { "-ARMOR", "TWINK" }, -- Runecloth Cloak
	[14043] = { "-ARMOR", "TWINK" }, -- Cindercloth Gloves
	[14142] = { "-ARMOR", "TWINK" }, -- Ghostweave Gloves
	[14143] = { "-ARMOR", "TWINK" }, -- Ghostweave Belt
	[14281] = { "-ARMOR", "TWINK" }, -- Opulent Crown -- Has useless random enchants
	[14283] = { "-ARMOR", "TWINK" }, -- Opulent Leggings -- Has useless random enchants
	[14299] = { "-ARMOR", "TWINK" }, -- Bonecaster's Boots -- Has useless random enchants
	[14301] = { "-ARMOR", "TWINK" }, -- Bonecaster's Bindings -- Has useless random enchants
	[14313] = { "-ARMOR", "TWINK" }, -- Celestial Cape
	[14447] = { "-ARMOR", "TWINK" }, -- Highborne Footpads
	[14451] = { "-ARMOR", "TWINK" }, -- Highborne Gloves
	[14454] = { "-ARMOR", "TWINK" }, -- Highborne Cord
	[14664] = { "-ARMOR", "TWINK" }, -- Keeper's Armor
	[14667] = { "-ARMOR", "TWINK" }, -- Keeper's Wreath
	[14672] = { "-ARMOR", "TWINK" }, -- Pridelord Bands
	[14807] = { "-ARMOR", "TWINK" }, -- Bloodlust Bracelets
	[14852] = { "-ARMOR", "TWINK" }, -- Sunscale Shield
	[14915] = { "-ARMOR", "TWINK" }, -- Jade Breastplate -- Has useless random enchants
	[14916] = { "-ARMOR", "TWINK" }, -- Jade Deflector -- Has useless random enchants
	[14922] = { "-ARMOR", "TWINK" }, -- Lofty Sabatons -- Has useless random enchants
	[14926] = { "-ARMOR", "TWINK" }, -- Lofty Gauntlets -- Has useless random enchants
	[14929] = { "-ARMOR", "TWINK" }, -- Lofty Shoulder Pads -- Has useless random enchants
	[14962] = { "-ARMOR", "TWINK" }, -- High Chief's Legguards -- Has useless random enchants
	[14963] = { "-ARMOR", "TWINK" }, -- High Chief's Pauldrons -- Has useless random enchants
	[15046] = { "-ARMOR", "TWINK" }, -- Green Dragonscale Leggings
	[15061] = { "-ARMOR", "TWINK" }, -- Living Shoulders
	[15067] = { "-ARMOR", "TWINK" }, -- Ironfeather Shoulders
	[15076] = { "-ARMOR", "TWINK" }, -- Heavy Scorpid Vest
	[15084] = { "-ARMOR", "TWINK" }, -- Wicked Leather Bracers
	[15180] = { "-ARMOR", "TWINK" }, -- Praetorian Girdle -- Has useless random enchants
	[15184] = { "-ARMOR", "TWINK" }, -- Praetorian Gloves -- Has useless random enchants
	[15187] = { "-ARMOR", "TWINK" }, -- Praetorian Pauldrons -- Has useless random enchants
	[15217] = { "-WEAPON", "TWINK" }, -- Widow Blade
	[15254] = { "-WEAPON", "TWINK" }, -- Dark Espadon -- Has useless random enchants
	[15280] = { "-WEAPON", "TWINK" }, -- Wizard's Hand -- Has useless random enchants
	[15389] = { "-ARMOR", "TWINK" }, -- Jadefire Sabatons -- Has useless random enchants
	[15394] = { "-ARMOR", "TWINK" }, -- Jadefire Pants -- Has useless random enchants
	[15395] = { "-ARMOR", "TWINK" }, -- Jadefire Epaulets -- Has useless random enchants
	[15427] = { "-ARMOR", "TWINK" }, -- Peerless Cloak
	[15647] = { "-ARMOR", "TWINK" }, -- Ironhide Pauldrons -- Has useless random enchants
	[15653] = { "-ARMOR", "TWINK" }, -- Merciless Gauntlets -- Has useless random enchants
	[15654] = { "-ARMOR", "TWINK" }, -- Merciless Belt -- Has useless random enchants
	[15656] = { "-ARMOR", "TWINK" }, -- Merciless Epaulets -- Has useless random enchants
	[15661] = { "-ARMOR", "TWINK" }, -- Impenetrable Cloak -- Has useless random enchants
	[15694] = { "-ARMOR", "TWINK" }, -- Merciless Greaves -- Has useless random enchants
	[18736] = { "-ARMOR", "TWINK" }, -- Plaguehound Leggings
	[18741] = { "-ARMOR", "TWINK" }, -- Morlune's Bracer
	[18742] = { "-ARMOR", "TWINK" }, -- Stratholme Militia Shoulderguard
	[20296] = { "-ARMOR", "TWINK" }, -- Green Dragonscale Gauntlets
	[30422] = { "-ARMOR", "TWINK" }, -- Diamond Focus Ring
	[45052] = { "-ARMOR", "TWINK" }, -- Gruffscale Leggings
	[45631] = { "-ARMOR", "TWINK" }, -- High-Powered Flashlight
--	59 Bracket Twink Items
	[24589] = { "-ARMOR", "TWINK" }, -- Fireheart Girdle -- Has useless random enchants
	[24590] = { "-ARMOR", "TWINK" }, -- Fireheart Boots -- Has useless random enchants
	[24591] = { "-ARMOR", "TWINK" }, -- Fireheart Chestpiece -- Has useless random enchants
	[24592] = { "-ARMOR", "TWINK" }, -- Fireheart Gloves -- Has useless random enchants
	[24593] = { "-ARMOR", "TWINK" }, -- Fireheart Skullcap -- Has useless random enchants
	[24594] = { "-ARMOR", "TWINK" }, -- Fireheart Leggings -- Has useless random enchants
	[24595] = { "-ARMOR", "TWINK" }, -- Fireheart Shoulderpads -- Has useless random enchants
	[24596] = { "-ARMOR", "TWINK" }, -- Fireheart Bracers -- Has useless random enchants
	[24597] = { "-ARMOR", "TWINK" }, -- Starfire Sash -- Has useless random enchants
	[24598] = { "-ARMOR", "TWINK" }, -- Starfire Sandals -- Has useless random enchants
	[24599] = { "-ARMOR", "TWINK" }, -- Starfire Vest -- Has useless random enchants
	[24600] = { "-ARMOR", "TWINK" }, -- Starfire Gloves -- Has useless random enchants
	[24601] = { "-ARMOR", "TWINK" }, -- Starfire Circlet -- Has useless random enchants
	[24602] = { "-ARMOR", "TWINK" }, -- Starfire Trousers -- Has useless random enchants
	[24603] = { "-ARMOR", "TWINK" }, -- Starfire Mantle -- Has useless random enchants
	[24604] = { "-ARMOR", "TWINK" }, -- Starfire Wristwraps -- Has useless random enchants
	[24701] = { "-ARMOR", "TWINK" }, -- Haal'eshi Cord -- Has useless random enchants
	[24702] = { "-ARMOR", "TWINK" }, -- Haal'eshi Boots -- Has useless random enchants
	[24703] = { "-ARMOR", "TWINK" }, -- Haal'eshi Jerkin -- Has useless random enchants
	[24704] = { "-ARMOR", "TWINK" }, -- Haal'eshi Gloves -- Has useless random enchants
	[24705] = { "-ARMOR", "TWINK" }, -- Haal'eshi Hat -- Has useless random enchants
	[24706] = { "-ARMOR", "TWINK" }, -- Haal'eshi Leggings -- Has useless random enchants
	[24707] = { "-ARMOR", "TWINK" }, -- Haal'eshi Pauldrons -- Has useless random enchants
	[24708] = { "-ARMOR", "TWINK" }, -- Haal'eshi Bindings -- Has useless random enchants
	[24709] = { "-ARMOR", "TWINK" }, -- Vengeance Belt -- Has useless random enchants
	[24710] = { "-ARMOR", "TWINK" }, -- Vengeance Boots -- Has useless random enchants
	[24711] = { "-ARMOR", "TWINK" }, -- Vengeance Chestpiece -- Has useless random enchants
	[24712] = { "-ARMOR", "TWINK" }, -- Vengeance Gloves -- Has useless random enchants
	[24713] = { "-ARMOR", "TWINK" }, -- Vengeance Helm -- Has useless random enchants
	[24714] = { "-ARMOR", "TWINK" }, -- Vengeance Legguards -- Has useless random enchants
	[24715] = { "-ARMOR", "TWINK" }, -- Vengeance Pauldrons -- Has useless random enchants
	[24716] = { "-ARMOR", "TWINK" }, -- Vengeance Bands -- Has useless random enchants
	[24814] = { "-ARMOR", "TWINK" }, -- Felstone Waistband -- Has useless random enchants
	[24815] = { "-ARMOR", "TWINK" }, -- Felstone Greaves -- Has useless random enchants
	[24816] = { "-ARMOR", "TWINK" }, -- Felstone Chain Vest -- Has useless random enchants
	[24817] = { "-ARMOR", "TWINK" }, -- Felstone Gauntlets -- Has useless random enchants
	[24818] = { "-ARMOR", "TWINK" }, -- Felstone Helm -- Has useless random enchants
	[24819] = { "-ARMOR", "TWINK" }, -- Felstone Leggings -- Has useless random enchants
	[24820] = { "-ARMOR", "TWINK" }, -- Felstone Spaulders -- Has useless random enchants
	[24821] = { "-ARMOR", "TWINK" }, -- Felstone Bindings -- Has useless random enchants
	[24822] = { "-ARMOR", "TWINK" }, -- Netherstalker Belt -- Has useless random enchants
	[24823] = { "-ARMOR", "TWINK" }, -- Netherstalker Greaves -- Has useless random enchants
	[24824] = { "-ARMOR", "TWINK" }, -- Netherstalker Armor -- Has useless random enchants
	[24825] = { "-ARMOR", "TWINK" }, -- Netherstalker Gloves -- Has useless random enchants
	[24826] = { "-ARMOR", "TWINK" }, -- Netherstalker Helmet -- Has useless random enchants
	[24827] = { "-ARMOR", "TWINK" }, -- Netherstalker Legguards -- Has useless random enchants
	[24828] = { "-ARMOR", "TWINK" }, -- Netherstalker Mantle -- Has useless random enchants
	[24829] = { "-ARMOR", "TWINK" }, -- Netherstalker Bracer -- Has useless random enchants
	[24926] = { "-ARMOR", "TWINK" }, -- Ango'rosh Belt -- Has useless random enchants
	[24927] = { "-ARMOR", "TWINK" }, -- Ango'rosh Sabatons -- Has useless random enchants
	[24928] = { "-ARMOR", "TWINK" }, -- Ango'rosh Breastplate -- Has useless random enchants
	[24929] = { "-ARMOR", "TWINK" }, -- Ango'rosh Gauntlets -- Has useless random enchants
	[24930] = { "-ARMOR", "TWINK" }, -- Ango'rosh Helm -- Has useless random enchants
	[24931] = { "-ARMOR", "TWINK" }, -- Ango'rosh Legguards -- Has useless random enchants
	[24932] = { "-ARMOR", "TWINK" }, -- Ango'rosh Pauldrons -- Has useless random enchants
	[24933] = { "-ARMOR", "TWINK" }, -- Ango'rosh Vambraces -- Has useless random enchants
	[24934] = { "-ARMOR", "TWINK" }, -- Darkcrest Belt -- Has useless random enchants
	[24935] = { "-ARMOR", "TWINK" }, -- Darkcrest Sabatons -- Has useless random enchants
	[24936] = { "-ARMOR", "TWINK" }, -- Darkcrest Breastplate -- Has useless random enchants
	[24937] = { "-ARMOR", "TWINK" }, -- Darkcrest Gauntlets -- Has useless random enchants
	[24938] = { "-ARMOR", "TWINK" }, -- Darkcrest Helm -- Has useless random enchants
	[24939] = { "-ARMOR", "TWINK" }, -- Darkcrest Legguards -- Has useless random enchants
	[24940] = { "-ARMOR", "TWINK" }, -- Darkcrest Pauldrons -- Has useless random enchants
	[24941] = { "-ARMOR", "TWINK" }, -- Darkcrest Bracers -- Has useless random enchants
	[25031] = { "-ARMOR", "TWINK" }, -- Silvermoon Royal Cloak -- Has useless random enchants
	[25032] = { "-ARMOR", "TWINK" }, -- Hellfire Cloak -- Has useless random enchants
	[25045] = { "-ARMOR", "TWINK" }, -- Azurite Ring -- Has useless random enchants
	[25046] = { "-ARMOR", "TWINK" }, -- Spined Ring -- Has useless random enchants
	[25059] = { "-ARMOR", "TWINK" }, -- Fire Opal Collar -- Has useless random enchants
	[25060] = { "-ARMOR", "TWINK" }, -- Sunstone Necklace -- Has useless random enchants
	[25073] = { "-ARMOR", "TWINK" }, -- Emperor Shield -- Has useless random enchants
	[25074] = { "-ARMOR", "TWINK" }, -- Telaari Shield -- Has useless random enchants
	[25087] = { "-ARMOR", "TWINK" }, -- Bleeding Eye -- Has useless random enchants
	[25088] = { "-ARMOR", "TWINK" }, -- Laughing Skull Orb -- Has useless random enchants
	[25102] = { "-WEAPON", "TWINK" }, -- Jaedenis Dagger -- Has useless random enchants
	[25116] = { "-WEAPON", "TWINK" }, -- Pneumatic War Hammer -- Has useless random enchants
	[25130] = { "-WEAPON", "TWINK" }, -- Gronn-Bone Club -- Has useless random enchants
	[25144] = { "-WEAPON", "TWINK" }, -- Skettis Curved Blade -- Has useless random enchants
	[25158] = { "-WEAPON", "TWINK" }, -- Skeletal Broadsword -- Has useless random enchants
	[25172] = { "-WEAPON", "TWINK" }, -- Jinbali Warp-Staff -- Has useless random enchants
	[25186] = { "-WEAPON", "TWINK" }, -- Vampiric Handscythes -- Has useless random enchants
	[25200] = { "-WEAPON", "TWINK" }, -- Jagged Broadaxe -- Has useless random enchants
	[25214] = { "-WEAPON", "TWINK" }, -- Mok'Nathal Battleaxe -- Has useless random enchants
	[25228] = { "-WEAPON", "TWINK" }, -- Halberd Polearm -- Has useless random enchants
	[25242] = { "-WEAPON", "TWINK" }, -- Telaari Longbow -- Has useless random enchants
	[25256] = { "-WEAPON", "TWINK" }, -- Stronghold Crossbow -- Has useless random enchants
	[25270] = { "-WEAPON", "TWINK" }, -- Gnomish Assault Rifle -- Has useless random enchants
	[25284] = { "-WEAPON", "TWINK" }, -- Purpleheart Wand -- Has useless random enchants
	[25298] = { "-WEAPON", "TWINK" }, -- Combustion Dagger -- Has useless random enchants
	[25312] = { "-WEAPON", "TWINK" }, -- Glorious Scepter -- Has useless random enchants
	[25326] = { "-WEAPON", "TWINK" }, -- Primal Lore-Staff -- Has useless random enchants
--	69 Bracket Twink Items
	[35963] = { "-ARMOR", "TWINK" }, -- Bloodspore Sash -- Has useless random enchants
	[35965] = { "-ARMOR", "TWINK" }, -- Bloodspore Robe -- Has useless random enchants
	[35966] = { "-ARMOR", "TWINK" }, -- Bloodspore Gloves -- Has useless random enchants
	[35967] = { "-ARMOR", "TWINK" }, -- Bloodspore Hood -- Has useless random enchants
	[35968] = { "-ARMOR", "TWINK" }, -- Bloodspore Leggings -- Has useless random enchants
	[35969] = { "-ARMOR", "TWINK" }, -- Bloodspore Mantle -- Has useless random enchants
	[35970] = { "-ARMOR", "TWINK" }, -- Bloodspore Bracelets -- Has useless random enchants
	[35971] = { "-ARMOR", "TWINK" }, -- Mur'ghoul Girdle -- Has useless random enchants
	[35972] = { "-ARMOR", "TWINK" }, -- Mur'ghoul Boots -- Has useless random enchants
	[35973] = { "-ARMOR", "TWINK" }, -- Mur'ghoul Robe -- Has useless random enchants
	[35974] = { "-ARMOR", "TWINK" }, -- Mur'ghoul Handwraps -- Has useless random enchants
	[35975] = { "-ARMOR", "TWINK" }, -- Mur'ghoul Cap -- Has useless random enchants
	[35976] = { "-ARMOR", "TWINK" }, -- Mur'ghoul Leggings -- Has useless random enchants
	[35977] = { "-ARMOR", "TWINK" }, -- Mur'ghoul Shoulderpads -- Has useless random enchants
	[35978] = { "-ARMOR", "TWINK" }, -- Mur'ghoul Wristwraps -- Has useless random enchants
	[36075] = { "-ARMOR", "TWINK" }, -- Winterfin Cord -- Has useless random enchants
	[36076] = { "-ARMOR", "TWINK" }, -- Winterfin Boots -- Has useless random enchants
	[36077] = { "-ARMOR", "TWINK" }, -- Winterfin Chestpiece -- Has useless random enchants
	[36078] = { "-ARMOR", "TWINK" }, -- Winterfin Gloves -- Has useless random enchants
	[36079] = { "-ARMOR", "TWINK" }, -- Winterfin Cowl -- Has useless random enchants
	[36080] = { "-ARMOR", "TWINK" }, -- Winterfin Legguards -- Has useless random enchants
	[36081] = { "-ARMOR", "TWINK" }, -- Winterfin Shoulderguards -- Has useless random enchants
	[36082] = { "-ARMOR", "TWINK" }, -- Winterfin Bindings -- Has useless random enchants
	[36083] = { "-ARMOR", "TWINK" }, -- Riplash Belt -- Has useless random enchants
	[36084] = { "-ARMOR", "TWINK" }, -- Riplash Boots -- Has useless random enchants
	[36085] = { "-ARMOR", "TWINK" }, -- Riplash Jerkin -- Has useless random enchants
	[36086] = { "-ARMOR", "TWINK" }, -- Riplash Gloves -- Has useless random enchants
	[36087] = { "-ARMOR", "TWINK" }, -- Riplash Cover -- Has useless random enchants
	[36088] = { "-ARMOR", "TWINK" }, -- Riplash Leggings -- Has useless random enchants
	[36089] = { "-ARMOR", "TWINK" }, -- Riplash Pauldrons -- Has useless random enchants
	[36090] = { "-ARMOR", "TWINK" }, -- Riplash Wristguards -- Has useless random enchants
	[36187] = { "-ARMOR", "TWINK" }, -- Njord Belt -- Has useless random enchants
	[36188] = { "-ARMOR", "TWINK" }, -- Njord Boots -- Has useless random enchants
	[36189] = { "-ARMOR", "TWINK" }, -- Njord Chain Vest -- Has useless random enchants
	[36190] = { "-ARMOR", "TWINK" }, -- Njord Gauntlets -- Has useless random enchants
	[36191] = { "-ARMOR", "TWINK" }, -- Njord Helm -- Has useless random enchants
	[36192] = { "-ARMOR", "TWINK" }, -- Njord Leggings -- Has useless random enchants
	[36193] = { "-ARMOR", "TWINK" }, -- Njord Shoulderguards -- Has useless random enchants
	[36194] = { "-ARMOR", "TWINK" }, -- Njord Bracers -- Has useless random enchants
	[36195] = { "-ARMOR", "TWINK" }, -- Skom Stitched-Belt -- Has useless random enchants
	[36196] = { "-ARMOR", "TWINK" }, -- Skom Greaves -- Has useless random enchants
	[36197] = { "-ARMOR", "TWINK" }, -- Skom Chain Vest -- Has useless random enchants
	[36198] = { "-ARMOR", "TWINK" }, -- Skom Gloves -- Has useless random enchants
	[36199] = { "-ARMOR", "TWINK" }, -- Skom Helm -- Has useless random enchants
	[36200] = { "-ARMOR", "TWINK" }, -- Skom Leggings -- Has useless random enchants
	[36201] = { "-ARMOR", "TWINK" }, -- Skom Spaulders -- Has useless random enchants
	[36202] = { "-ARMOR", "TWINK" }, -- Skom Bracers -- Has useless random enchants
	[36299] = { "-ARMOR", "TWINK" }, -- Coldrock Girdle -- Has useless random enchants
	[36300] = { "-ARMOR", "TWINK" }, -- Coldrock Sabatons -- Has useless random enchants
	[36301] = { "-ARMOR", "TWINK" }, -- Coldrock Breastplate -- Has useless random enchants
	[36302] = { "-ARMOR", "TWINK" }, -- Coldrock Gauntlets -- Has useless random enchants
	[36303] = { "-ARMOR", "TWINK" }, -- Coldrock Helmet -- Has useless random enchants
	[36304] = { "-ARMOR", "TWINK" }, -- Coldrock Legplates -- Has useless random enchants
	[36305] = { "-ARMOR", "TWINK" }, -- Coldrock Pauldrons -- Has useless random enchants
	[36306] = { "-ARMOR", "TWINK" }, -- Coldrock Bracers -- Has useless random enchants
	[36307] = { "-ARMOR", "TWINK" }, -- Baleheim Belt -- Has useless random enchants
	[36308] = { "-ARMOR", "TWINK" }, -- Baleheim Greaves -- Has useless random enchants
	[36309] = { "-ARMOR", "TWINK" }, -- Baleheim Armor -- Has useless random enchants
	[36310] = { "-ARMOR", "TWINK" }, -- Baleheim Gloves -- Has useless random enchants
	[36311] = { "-ARMOR", "TWINK" }, -- Baleheim Helmet -- Has useless random enchants
	[36312] = { "-ARMOR", "TWINK" }, -- Baleheim Legguards -- Has useless random enchants
	[36313] = { "-ARMOR", "TWINK" }, -- Baleheim Epaulets -- Has useless random enchants
	[36314] = { "-ARMOR", "TWINK" }, -- Baleheim Vambraces -- Has useless random enchants
	[36404] = { "-ARMOR", "TWINK" }, -- Suede Cloak -- Has useless random enchants
	[36405] = { "-ARMOR", "TWINK" }, -- Double Cape -- Has useless random enchants
	[36418] = { "-ARMOR", "TWINK" }, -- Floral Loop -- Has useless random enchants
	[36419] = { "-ARMOR", "TWINK" }, -- Glass Ring -- Has useless random enchants
	[36432] = { "-ARMOR", "TWINK" }, -- Silver Rope Chain -- Has useless random enchants
	[36433] = { "-ARMOR", "TWINK" }, -- Snake Entwined Necklace -- Has useless random enchants
	[36446] = { "-ARMOR", "TWINK" }, -- Forged-Iron Shield -- Has useless random enchants
	[36447] = { "-ARMOR", "TWINK" }, -- Kaskala Buckler -- Has useless random enchants
	[36460] = { "-ARMOR", "TWINK" }, -- Northern Star -- Has useless random enchants
	[36461] = { "-ARMOR", "TWINK" }, -- Demon-Skull Orb -- Has useless random enchants
	[36475] = { "-WEAPON", "TWINK" }, -- Seal Shortblade -- Has useless random enchants
	[36489] = { "-WEAPON", "TWINK" }, -- Iron Flanged Scepter -- Has useless random enchants
	[36503] = { "-WEAPON", "TWINK" }, -- Toothless Bludgeon -- Has useless random enchants
	[36517] = { "-WEAPON", "TWINK" }, -- Iron-Grip Shortsword -- Has useless random enchants
	[36531] = { "-WEAPON", "TWINK" }, -- Sawtooth Greatsword -- Has useless random enchants
	[36545] = { "-WEAPON", "TWINK" }, -- Branched Stick -- Has useless random enchants
	[36559] = { "-WEAPON", "TWINK" }, -- Prized Handscythes -- Has useless random enchants
	[36573] = { "-WEAPON", "TWINK" }, -- Primeval Adze -- Has useless random enchants
	[36587] = { "-WEAPON", "TWINK" }, -- Taunka Axe -- Has useless random enchants
	[36601] = { "-WEAPON", "TWINK" }, -- Patient Harpoon -- Has useless random enchants
	[36615] = { "-WEAPON", "TWINK" }, -- Expert's Longbow -- Has useless random enchants
	[36629] = { "-WEAPON", "TWINK" }, -- Ferocious Crossbow -- Has useless random enchants
	[36643] = { "-WEAPON", "TWINK" }, -- Tracker's Musket -- Has useless random enchants
	[36657] = { "-WEAPON", "TWINK" }, -- Vicious Wand -- Has useless random enchants
	[36671] = { "-WEAPON", "TWINK" }, -- Ominous Dagger -- Has useless random enchants
	[36685] = { "-WEAPON", "TWINK" }, -- Placid Lightmace -- Has useless random enchants
	[36699] = { "-WEAPON", "TWINK" }, -- Iceberg Staff -- Has useless random enchants
	[37743] = { "-ARMOR", "TWINK" }, -- Legguards of Brutalization
	[37744] = { "-ARMOR", "TWINK" }, -- Horrorblood Treads
	[37745] = { "-ARMOR", "TWINK" }, -- Greenhealer's Garb
	[37746] = { "-ARMOR", "TWINK" }, -- Helm of the Burning Soul
	[37747] = { "-ARMOR", "TWINK" }, -- Beneficent Bulwark
	[37748] = { "-ARMOR", "TWINK" }, -- Winterfall's Frozen Necklace
	[38412] = { "-ARMOR", "TWINK" }, -- Frostscale Belt
	[38414] = { "-ARMOR", "TWINK" }, -- Frostscale Chestguard
	[38418] = { "-ARMOR", "TWINK" }, -- Nerubian Belt
	[38420] = { "-ARMOR", "TWINK" }, -- Nerubian Chestguard
	[38422] = { "-ARMOR", "TWINK" }, -- Nerubian Legguards
	[40942] = { "-ARMOR", "TWINK" }, -- Spiked Cobalt Helm
	[41520] = { "-ARMOR", "TWINK" }, -- Frostwoven Boots
	[41522] = { "-ARMOR", "TWINK" }, -- Frostwoven Belt
	[44211] = { "-ARMOR", "TWINK" }, -- Frostwoven Gloves
--	79 Bracket Twink Items
	[52306] = { "-ARMOR", "TWINK" }, -- Jasper Ring
	[52310] = { "-ARMOR", "TWINK" }, -- Jasper Ring
	[52312] = { "-ARMOR", "TWINK" }, -- Alicite Pendant
	[55260] = { "-ARMOR", "TWINK" }, -- Alpheus Legguards
	[55261] = { "-ARMOR", "TWINK" }, -- Ring of the Great Whale
	[55262] = { "-ARMOR", "TWINK" }, -- Barnacle Pendant
	[55283] = { "-WEAPON", "TWINK" }, -- Angerfang Axe
	[55292] = { "-WEAPON", "TWINK" }, -- Angerfang Broadaxe
	[55301] = { "-WEAPON", "TWINK" }, -- Angerfang Bow
	[55309] = { "-ARMOR", "TWINK" }, -- Swamplight Cloak
	[55310] = { "-ARMOR", "TWINK" }, -- Sishir Cloak
	[55319] = { "-WEAPON", "TWINK" }, -- Angerfang Crossbow
	[55328] = { "-WEAPON", "TWINK" }, -- Angerfang Dagger
	[55337] = { "-WEAPON", "TWINK" }, -- Angerfang Staff
	[55346] = { "-WEAPON", "TWINK" }, -- Angerfang Knuckles
	[55355] = { "-WEAPON", "TWINK" }, -- Angerfang Gun
	[55364] = { "-WEAPON", "TWINK" }, -- Sishir Scepter
	[55373] = { "-ARMOR", "TWINK" }, -- Sishir Crystal
	[55382] = { "-WEAPON", "TWINK" }, -- Angerfang Mace
	[55391] = { "-WEAPON", "TWINK" }, -- Angerfang Hammer
	[55399] = { "-ARMOR", "TWINK" }, -- Swamplight Amulet
	[55400] = { "-ARMOR", "TWINK" }, -- Sishir Amulet
	[55409] = { "-WEAPON", "TWINK" }, -- Angerfang Spear
	[55417] = { "-ARMOR", "TWINK" }, -- Swamplight Ring
	[55418] = { "-ARMOR", "TWINK" }, -- Sishir Ring
	[55426] = { "-ARMOR", "TWINK" }, -- Rethban Shield
	[55427] = { "-ARMOR", "TWINK" }, -- Jasperlode Shield
	[55436] = { "-WEAPON", "TWINK" }, -- Sishir Spellblade
	[55445] = { "-WEAPON", "TWINK" }, -- Angerfang Staff
	[55454] = { "-WEAPON", "TWINK" }, -- Angerfang Sword
	[55463] = { "-WEAPON", "TWINK" }, -- Angerfang Greatsword
	[55481] = { "-WEAPON", "TWINK" }, -- Sishir Wand
	[55489] = { "-ARMOR", "TWINK" }, -- Rethban Vambraces
	[55490] = { "-ARMOR", "TWINK" }, -- Jasperlode Vambraces
	[55498] = { "-ARMOR", "TWINK" }, -- Rethban Breastplate
	[55499] = { "-ARMOR", "TWINK" }, -- Jasperlode Breastplate
	[55507] = { "-ARMOR", "TWINK" }, -- Rethban Sabatons
	[55508] = { "-ARMOR", "TWINK" }, -- Jasperlode Sabatons
	[55516] = { "-ARMOR", "TWINK" }, -- Rethban Gauntlets
	[55517] = { "-ARMOR", "TWINK" }, -- Jasperlode Gauntlets
	[55525] = { "-ARMOR", "TWINK" }, -- Rethban Helm
	[55526] = { "-ARMOR", "TWINK" }, -- Jasperlode Helm
	[55534] = { "-ARMOR", "TWINK" }, -- Rethban Legplates
	[55535] = { "-ARMOR", "TWINK" }, -- Jasperlode Legplates
	[55543] = { "-ARMOR", "TWINK" }, -- Rethban Pauldrons
	[55544] = { "-ARMOR", "TWINK" }, -- Jasperlode Pauldrons
	[55552] = { "-ARMOR", "TWINK" }, -- Rethban Girdle
	[55553] = { "-ARMOR", "TWINK" }, -- Jasperlode Girdle
	[55561] = { "-ARMOR", "TWINK" }, -- Southfury Bracers
	[55562] = { "-ARMOR", "TWINK" }, -- Sundown Bracers
	[55570] = { "-ARMOR", "TWINK" }, -- Southfury Vest
	[55571] = { "-ARMOR", "TWINK" }, -- Sundown Vest
	[55579] = { "-ARMOR", "TWINK" }, -- Southfury Greaves
	[55580] = { "-ARMOR", "TWINK" }, -- Sundown Greaves
	[55588] = { "-ARMOR", "TWINK" }, -- Southfury Gauntlets
	[55589] = { "-ARMOR", "TWINK" }, -- Sundown Gauntlets
	[55597] = { "-ARMOR", "TWINK" }, -- Southfury Helm
	[55598] = { "-ARMOR", "TWINK" }, -- Sundown Helm
	[55606] = { "-ARMOR", "TWINK" }, -- Southfury Legguards
	[55607] = { "-ARMOR", "TWINK" }, -- Sundown Legguards
	[55615] = { "-ARMOR", "TWINK" }, -- Southfury Spaulders
	[55616] = { "-ARMOR", "TWINK" }, -- Sundown Spaulders
	[55624] = { "-ARMOR", "TWINK" }, -- Southfury Belt
	[55625] = { "-ARMOR", "TWINK" }, -- Sundown Belt
	[55633] = { "-ARMOR", "TWINK" }, -- Mosshide Bindings
	[55634] = { "-ARMOR", "TWINK" }, -- Yojamba Bindings
	[55642] = { "-ARMOR", "TWINK" }, -- Mosshide Jerkin
	[55643] = { "-ARMOR", "TWINK" }, -- Yojamba Jerkin
	[55651] = { "-ARMOR", "TWINK" }, -- Mosshide Boots
	[55652] = { "-ARMOR", "TWINK" }, -- Yojamba Boots
	[55660] = { "-ARMOR", "TWINK" }, -- Mosshide Gloves
	[55661] = { "-ARMOR", "TWINK" }, -- Yojamba Gloves
	[55669] = { "-ARMOR", "TWINK" }, -- Mosshide Hood
	[55670] = { "-ARMOR", "TWINK" }, -- Yojamba Hood
	[55678] = { "-ARMOR", "TWINK" }, -- Mosshide Britches
	[55679] = { "-ARMOR", "TWINK" }, -- Yojamba Britches
	[55687] = { "-ARMOR", "TWINK" }, -- Mosshide Shoulders
	[55688] = { "-ARMOR", "TWINK" }, -- Yojamba Shoulders
	[55696] = { "-ARMOR", "TWINK" }, -- Mosshide Waistband
	[55697] = { "-ARMOR", "TWINK" }, -- Yojamba Waistband
	[55705] = { "-ARMOR", "TWINK" }, -- Mistmantle Wristwraps
	[55706] = { "-ARMOR", "TWINK" }, -- Baradin Wristwraps
	[55714] = { "-ARMOR", "TWINK" }, -- Mistmantle Robe
	[55715] = { "-ARMOR", "TWINK" }, -- Baradin Robe
	[55723] = { "-ARMOR", "TWINK" }, -- Mistmantle Sandals
	[55724] = { "-ARMOR", "TWINK" }, -- Baradin Sandals
	[55732] = { "-ARMOR", "TWINK" }, -- Mistmantle Handwraps
	[55733] = { "-ARMOR", "TWINK" }, -- Baradin Handwraps
	[55741] = { "-ARMOR", "TWINK" }, -- Mistmantle Cowl
	[55742] = { "-ARMOR", "TWINK" }, -- Baradin Cowl
	[55750] = { "-ARMOR", "TWINK" }, -- Mistmantle Leggings
	[55751] = { "-ARMOR", "TWINK" }, -- Baradin Leggings
	[55759] = { "-ARMOR", "TWINK" }, -- Mistmantle Shoulderpads
	[55760] = { "-ARMOR", "TWINK" }, -- Baradin Shoulderpads
	[55768] = { "-ARMOR", "TWINK" }, -- Mistmantle Cord
	[55769] = { "-ARMOR", "TWINK" }, -- Baradin Cord
	[55789] = { "-WEAPON", "TWINK" }, -- Berto's Staff
	[55790] = { "-WEAPON", "TWINK" }, -- Toxidunk Dagger
	[56480] = { "-ARMOR", "TWINK" }, -- Savage Cloak
--	89 Bracket Twink Items
	[82241] = { "-ARMOR", "TWINK" }, -- Yak Belt
	[82242] = { "-ARMOR", "TWINK" }, -- Yak Bracers
	[82243] = { "-ARMOR", "TWINK" }, -- Yak Gauntlets
	[82244] = { "-ARMOR", "TWINK" }, -- Yak Greaves
	[82245] = { "-ARMOR", "TWINK" }, -- Yak Helm
	[82246] = { "-ARMOR", "TWINK" }, -- Yak Legguards
	[82247] = { "-ARMOR", "TWINK" }, -- Yak Spaulders
	[82248] = { "-ARMOR", "TWINK" }, -- Yak Vest
	[82249] = { "-ARMOR", "TWINK" }, -- Waterfall Cord
	[82250] = { "-ARMOR", "TWINK" }, -- Waterfall Cowl
	[82251] = { "-ARMOR", "TWINK" }, -- Waterfall Handwraps
	[82252] = { "-ARMOR", "TWINK" }, -- Waterfall Leggings
	[82253] = { "-ARMOR", "TWINK" }, -- Waterfall Robe
	[82254] = { "-ARMOR", "TWINK" }, -- Waterfall Sandals
	[82255] = { "-ARMOR", "TWINK" }, -- Waterfall Shoulderpads
	[82256] = { "-ARMOR", "TWINK" }, -- Waterfall Wristwraps
	[82257] = { "-ARMOR", "TWINK" }, -- Vine Bindings
	[82258] = { "-ARMOR", "TWINK" }, -- Vine Boots
	[82259] = { "-ARMOR", "TWINK" }, -- Vine Britches
	[82260] = { "-ARMOR", "TWINK" }, -- Vine Gloves
	[82261] = { "-ARMOR", "TWINK" }, -- Vine Hood
	[82262] = { "-ARMOR", "TWINK" }, -- Vine Jerkin
	[82263] = { "-ARMOR", "TWINK" }, -- Vine Shoulders
	[82264] = { "-ARMOR", "TWINK" }, -- Vine Waistband
	[82265] = { "-WEAPON", "TWINK" }, -- Engraved Axe
	[82266] = { "-WEAPON", "TWINK" }, -- Engraved Bow
	[82267] = { "-WEAPON", "TWINK" }, -- Engraved Broadaxe
	[82268] = { "-WEAPON", "TWINK" }, -- Engraved Crossbow
	[82269] = { "-WEAPON", "TWINK" }, -- Engraved Dagger
	[82270] = { "-WEAPON", "TWINK" }, -- Engraved Greatsword
	[82271] = { "-WEAPON", "TWINK" }, -- Engraved Gun
	[82272] = { "-WEAPON", "TWINK" }, -- Engraved Hammer
	[82274] = { "-WEAPON", "TWINK" }, -- Engraved Knuckles
	[82275] = { "-WEAPON", "TWINK" }, -- Engraved Mace
	[82276] = { "-WEAPON", "TWINK" }, -- Engraved Spear
	[82277] = { "-WEAPON", "TWINK" }, -- Engraved Staff
	[82278] = { "-WEAPON", "TWINK" }, -- Engraved Staff
	[82279] = { "-WEAPON", "TWINK" }, -- Engraved Sword
	[82280] = { "-ARMOR", "TWINK" }, -- Immaculate Amulet
	[82281] = { "-ARMOR", "TWINK" }, -- Immaculate Cloak
	[82282] = { "-ARMOR", "TWINK" }, -- Immaculate Crystal
	[82283] = { "-ARMOR", "TWINK" }, -- Immaculate Ring
	[82284] = { "-WEAPON", "TWINK" }, -- Immaculate Scepter
	[82285] = { "-WEAPON", "TWINK" }, -- Immaculate Spellblade
	[82286] = { "-WEAPON", "TWINK" }, -- Immaculate Wand
	[82287] = { "-ARMOR", "TWINK" }, -- Temple Breastplate
	[82288] = { "-ARMOR", "TWINK" }, -- Temple Gauntlets
	[82289] = { "-ARMOR", "TWINK" }, -- Temple Girdle
	[82290] = { "-ARMOR", "TWINK" }, -- Temple Helm
	[82291] = { "-ARMOR", "TWINK" }, -- Temple Legplates
	[82292] = { "-ARMOR", "TWINK" }, -- Temple Pauldrons
	[82293] = { "-ARMOR", "TWINK" }, -- Temple Sabatons
	[82294] = { "-ARMOR", "TWINK" }, -- Temple Shield
	[82295] = { "-ARMOR", "TWINK" }, -- Temple Vambraces
}

Auctions.PetStatus = {
	[39] = {}, --Mechanical Squirrel
	[40] = {}, --Bombay Cat
	[41] = {}, --Cornish Rex Cat
	[42] = {}, --Black Tabby Cat
	[43] = {}, --Orange Tabby Cat
	[44] = {}, --Siamese Cat
	[45] = {}, --Silver Tabby Cat
	[46] = {}, --White Kitten
	[47] = {}, --Cockatiel
	[49] = {}, --Hyacinth Macaw
	[50] = {}, --Green Wing Macaw
	[51] = {}, --Senegal
	[52] = {}, --Ancona Chicken
	[55] = {}, --Undercity Cockroach
	[56] = {}, --Dark Whelpling
	[57] = {}, --Azure Whelpling
	[58] = {}, --Crimson Whelpling
	[59] = {}, --Emerald Whelpling
	[64] = {}, --Wood Frog
	[65] = {}, --Tree Frog
	[67] = {}, --Hawk Owl
	[68] = {}, --Great Horned Owl
	[70] = {}, --Brown Prairie Dog
	[72] = {}, --Snowshoe Rabbit
	[74] = {}, --Albino Snake
	[75] = {}, --Black Kingsnake
	[77] = {}, --Brown Snake
	[78] = {}, --Crimson Snake
	[85] = {}, --Pet Bombling
	[86] = {}, --Lil' Smoky
	[87] = {}, --Sprite Darter Hatchling
	[89] = {}, --Worg Pup
	[90] = {}, --Smolderweb Hatchling
	[95] = {}, --Lifelike Toad
	[114] = {}, --Disgusting Oozeling
	[115] = {}, --Land Shark
	[116] = {}, --Tranquil Mechanical Yeti
	[117] = {}, --Tiny Snowman
	[118] = {}, --Winter Reindeer
	[119] = {}, --Father Winter's Helper
	[120] = {}, --Winter's Little Helper
	[122] = {}, --Peddlefeet
	[125] = {}, --Speedy
	[126] = {}, --Mr. Wiggles
	[127] = {}, --Whiskers the Rat
	[128] = {}, --Spirit of Summer
	[130] = {}, --Hippogryph Hatchling
	[132] = {}, --Magical Crawdad
	[136] = {}, --Mana Wyrmling
	[137] = {}, --Brown Rabbit
	[138] = {}, --Blue Moth
	[139] = {}, --Red Moth
	[140] = {}, --Yellow Moth
	[141] = {}, --White Moth
	[142] = {}, --Golden Dragonhawk Hatchling
	[143] = {}, --Red Dragonhawk Hatchling
	[144] = {}, --Silver Dragonhawk Hatchling
	[145] = {}, --Blue Dragonhawk Hatchling
	[146] = {}, --Firefly
	[153] = {}, --Wolpertinger
	[156] = {}, --Bananas
	[157] = {}, --Willy
	[158] = {}, --Egbert
	[159] = {}, --Peanut
	[162] = {}, --Sinister Squashling
	[163] = {}, --Toothy
	[164] = {}, --Muckbreath
	[165] = {}, --Mojo
	[166] = {}, --Pint-Sized Pink Pachyderm
	[167] = {}, --Tiny Sporebat
	[168] = {}, --Rocket Chicken
	[169] = {}, --Dragon Kite
	[172] = {}, --Searing Scorchling
	[173] = {}, --Snarly
	[174] = {}, --Chuck
	[175] = {}, --Phoenix Hatchling
	[183] = {}, --Ethereal Soul-Trader
	[186] = {}, --Nether Ray Fry
	[190] = {}, --Ghostly Skull
	[191] = {}, --Clockwork Rocket Bot
	[193] = {}, --Giant Sewer Rat
	[194] = {}, --Tickbird Hatchling
	[195] = {}, --White Tickbird Hatchling
	[196] = {}, --Proto-Drake Whelp
	[197] = {}, --Cobra Hatchling
	[198] = {}, --Pengu
	[200] = {}, --Spring Rabbit
	[204] = {}, --Teldrassil Sproutling
	[205] = {}, --Dun Morogh Cub
	[206] = {}, --Tirisfal Batling
	[207] = {}, --Durotar Scorpion
	[209] = {}, --Elwynn Lamb
	[210] = {}, --Mulgore Hatchling
	[211] = {}, --Strand Crawler
	[212] = {}, --Ammen Vale Lashling
	[213] = {}, --Enchanted Broom
	[215] = {}, --Mechanopeep
	[218] = {}, --Sen'jin Fetish
	[224] = {}, --Calico Cat
	[229] = {}, --Shimmering Wyrmling
	[232] = {}, --Darting Hatchling
	[233] = {}, --Deviate Hatchling
	[234] = {}, --Gundrak Hatchling
	[235] = {}, --Leaping Hatchling
	[236] = {}, --Obsidian Hatchling
	[237] = {}, --Ravasaur Hatchling
	[238] = {}, --Razormaw Hatchling
	[239] = {}, --Razzashi Hatchling
	[241] = {}, --Tuskarr Kite
	[242] = {}, --Spectral Tiger Cub
	[251] = {}, --Toxic Wasteling
	[253] = {}, --Frigid Frostling
	[254] = {}, --Blue Clockwork Rocket Bot
	[261] = {}, --Personal World Destroyer
	[262] = {}, --De-Weaponized Mechanical Companion
	[264] = {}, --Crawling Claw
	[266] = {}, --Fossilized Hatchling
	[267] = {}, --Enchanted Lantern
	[271] = {}, --Rustberg Gull
	[277] = {}, --Clockwork Gnome
	[278] = {}, --Fox Kit
	[279] = {}, --Tiny Shale Spider
	[285] = {}, --Landro's Lil' XT
	[286] = {}, --Mr. Grubbs
	[289] = {}, --Scooter the Snail
	[292] = {}, --Magic Lamp
	[293] = {}, --Elementium Geode
	[302] = {}, --Landro's Lichling
	[303] = {}, --Nightsaber Cub
	[306] = {}, --Winterspring Cub
	[308] = {}, --Legs
	[309] = {}, --Pterrordax Hatchling
	[310] = {}, --Voodoo Figurine
	[311] = {}, --Guardian Cub
	[317] = {}, --Hyjal Bear Cub
	[318] = {}, --Crimson Lasher
	[319] = {}, --Feline Familiar
	[328] = {}, --Purple Puffer
	[330] = {}, --Darkmoon Monkey
	[333] = {}, --Gregarious Grell
	[335] = {}, --Darkmoon Turtle
	[337] = {}, --Lumpy
	[338] = {}, --Darkmoon Tonk
	[339] = {}, --Darkmoon Zeppelin
	[340] = {}, --Sea Pony
	[341] = {}, --Lunar Lantern
	[342] = {}, --Festival Lantern
	[343] = {}, --Darkmoon Cub
	[348] = {}, --Eye of the Legion
	[381] = {}, --Porcupette
	[629] = {}, --Shore Crawler
	[630] = {}, --Gilnean Raven
	[650] = {}, --Terrible Turnip
	[652] = {}, --Tiny Goldfish
	[665] = {}, --Sand Scarab
	[792] = {}, --Jade Crane Chick
	[834] = {}, --Grinder
	[836] = {}, --Aqua Strider
	[844] = {}, --Mechanical Pandaren Dragonling
	[845] = {}, --Jade Owl
	[846] = {}, --Sapphire Cub
	[847] = {}, --Fishy
	[848] = {}, --Darkmoon Rabbit
	[868] = {}, --Pandaren Water Spirit
	[1039] = {}, --Imperial Moth
	[1040] = {}, --Imperial Silkworm
	[1061] = {}, --Darkmoon Hatchling
	[1063] = {}, --Darkmoon Eye
	[1124] = {}, --Pandaren Fire Spirit
	[1125] = {}, --Pandaren Air Spirit
	[1126] = {}, --Pandaren Earth Spirit
	[1143] = {}, --Giant Bone Spider
	[1144] = {}, --Fungal Abomination
	[1146] = {}, --Stitched Pup
	[1147] = {}, --Harbinger of Flame
	[1149] = {}, --Corefire Imp
	[1150] = {}, --Ashstone Core
	[1151] = {}, --Untamed Hatchling
	[1152] = {}, --Chrominius
	[1153] = {}, --Death Talon Whelpguard
	[1154] = {}, --Viscidus Globule
	[1155] = {}, --Anubisath Idol
	[1156] = {}, --Mini Mindslayer
	[1174] = {}, --Gusting Grimoire
	[1177] = {}, --Living Sandling
	[1178] = {}, --Sunreaver Micro-Sentry
	[1180] = {}, --Zandalari Kneebiter
	[1183] = {}, --Son of Animus
	[1185] = {}, --Spectral Porcupette
	[1196] = {}, --Sunfur Panda
	[1197] = {}, --Snowy Panda
	[1198] = {}, --Mountain Panda
	[1200] = {}, --Pygmy Direhorn
	[1201] = {}, --Spawn of G'nathus
	[1202] = {}, --Ji-Kun Hatchling
	[1204] = {}, --Pierre
	[1205] = {}, --Direhorn Runt
	[1206] = {}, --Tiny Red Carp
	[1207] = {}, --Tiny Blue Carp
	[1208] = {}, --Tiny Green Carp
	[1209] = {}, --Tiny White Carp
	[1211] = {}, --Zandalari Anklerender
	[1212] = {}, --Zandalari Footslasher
	[1213] = {}, --Zandalari Toenibbler
	[1226] = {}, --Lil' Bad Wolf
	[1227] = {}, --Menagerie Custodian
	[1228] = {}, --Netherspace Abyssal
	[1229] = {}, --Fiendish Imp
	[1230] = {}, --Tideskipper
	[1231] = {}, --Tainted Waveling
	[1232] = {}, --Coilfang Stalker
	[1233] = {}, --Pocket Reaver
	[1234] = {}, --Lesser Voidcaller
	[1235] = {}, --Phoenix Hawk Hatchling
	[1237] = {}, --Gahz'rooki
	[1243] = {}, --Living Fluid
	[1244] = {}, --Viscous Horror
	[1245] = {}, --Filthling
	[1256] = {}, --Rascal-Bot
	[1276] = {}, --Moon Moon
	[1320] = {}, --Lil' Bling
	[1321] = {}, --Azure Crane Chick
	[1322] = {}, --Blackfuse Bombling
	[1323] = {}, --Ashleaf Spriteling
	[1328] = {}, --Ruby Droplet
	[1329] = {}, --Dandelion Frolicker
	[1330] = {}, --Death Adder Hatchling
	[1331] = {}, --Droplet of Y'Shaarj
	[1332] = {}, --Gooey Sha-ling
	[1333] = {}, --Jademist Dancer
	[1334] = {}, --Kovok
	[1335] = {}, --Ominous Flame
	[1336] = {}, --Skunky Alemental
	[1337] = {}, --Spineclaw Crab
	[1338] = {}, --Gulp Froglet
	[1344] = {}, --Vengeful Porcupette
	[1345] = {}, --Gu'chi Swarmling
	[1346] = {}, --Harmonious Porcupette
	[1348] = {}, --Jadefire Spirit
	[1349] = {}, --Rotten Little Helper
	[1351] = {}, --Macabre Marionette
	[1385] = {}, --Albino Chimaeraling
	[1387] = {}, --Iron Starlette
	[1394] = {}, --Weebomination
	[1395] = {}, --Lil' Leftovers
	[1396] = {}, --Crazy Carrot
	[1403] = {}, --Mechanical Axebeak
	[1412] = {}, --Lifelike Mechanical Frostboar
	[1416] = {}, --Teroclaw Hatchling
	[1426] = {}, --Elekk Plushie
	[1428] = {}, --Zomstrok
	[1430] = {}, --Forest Sproutling
	[1432] = {}, --Nightshade Sproutling
	[1434] = {}, --Sun Sproutling
	[1442] = {}, --Ghastly Kid
	[1446] = {}, --Meadowstomper Calf
	[1448] = {}, --Sea Calf
	[1450] = {}, --Draenei Micro Defender
	[1458] = {}, --Bone Wasp
	[1467] = {}, --Sky-Bo
	[1471] = {}, --Fruit Hunter
	[1478] = {}, --Syd the Squid
	[1495] = {}, --Ore Eater
	[1511] = {}, --Lovebird Hatchling
	[1515] = {}, --Stonegrinder
	[1516] = {}, --Bush Chicken
	[1517] = {}, --Blazing Cindercrawler
	[1518] = {}, --Stout Alemental
	[1521] = {}, --Cursed Birman
	[1523] = {}, --Widget the Departed
	[1524] = {}, --Netherspawn, Spawn of Netherspawn
	[1530] = {}, --Frostwolf Ghostpup
	[1531] = {}, --Ancient Nest Guardian
	[1532] = {}, --Ikky
	[1533] = {}, --Lanticore Spawnling
	[1537] = {}, --Crimson Spore
	[1538] = {}, --Umbrafen Spore
	[1540] = {}, --Brilliant Spore
	[1541] = {}, --Hydraling
	[1542] = {}, --Frostwolf Pup
	[1544] = {}, --Hatespark the Tiny
	[1545] = {}, --Firewing
	[1563] = {}, --Bronze Whelpling
	[1564] = {}, --Doom Bloom
	[1565] = {}, --Mechanical Scorpid
	[1566] = {}, --Everbloom Peachick
	[1567] = {}, --Sentinel's Companion
	[1568] = {}, --Puddle Terror
	[1569] = {}, --Soul of the Forge
	[1570] = {}, --Sunfire Kaliri
	[1571] = {}, --Albino River Calf
	[1574] = {}, --Son of Sethe
	[1575] = {}, --Sky Fry
	[1576] = {}, --Eye of Observation
	[1596] = {}, --Veilwatcher Hatchling
	[1597] = {}, --Kaliri Hatchling
	[1600] = {}, --Bone Serpent
	[1601] = {}, --Servant of Demidos
	[1622] = {}, --Grotesque
	[1623] = {}, --Leviathan Hatchling
	[1624] = {}, --Abyssius
	[1625] = {}, --Fragment of Anger
	[1626] = {}, --Fragment of Suffering
	[1627] = {}, --Fragment of Desire
	[1628] = {}, --Sister of Temptation
	[1629] = {}, --Stinkrot
	[1631] = {}, --Hyjal Wisp
	[1632] = {}, --Sunblade Micro-Defender
	[1633] = {}, --Chaos Pup
	[1634] = {}, --Wretched Servant
	[1636] = {}, --Race MiniZep
	[1642] = {}, --Salad
	[1655] = {}, --Slithershock Elver
	[1656] = {}, --Young Talbuk
}
